/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.atom.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProfessorStageDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscStatusCirculationConfDAO;
import com.tydic.ssc.dao.po.SscProfessorStagePO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscStatusCirculationConfPO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscDealStatusCirculationConfAtomServiceImpl
implements SscDealStatusCirculationConfAtomService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscStatusCirculationConfDAO sscStatusCirculationConfDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProfessorStageDAO sscProfessorStageDAO;

    @Override
    public SscDealStatusCirculationConfAtomRspBO dealStatusCirculationConf(SscDealStatusCirculationConfAtomReqBO atomReqBO) {
        SscDealStatusCirculationConfAtomRspBO rsp = new SscDealStatusCirculationConfAtomRspBO();
        if (null == atomReqBO.getProjectId()) {
            throw new BusinessException("0001", "\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010projectId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == atomReqBO.getId()) {
            throw new BusinessException("0001", "\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010id\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)atomReqBO.getStatusChangeOperCode())) {
            throw new BusinessException("0001", "\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010statusChangeOperCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SscProjectPO whereProjectPO = new SscProjectPO();
        whereProjectPO.setProjectId(atomReqBO.getProjectId());
        whereProjectPO.setPlanId(atomReqBO.getPlanId());
        SscProjectPO sscProjectPO = this.sscProjectDAO.getModelBy(whereProjectPO);
        if (null == sscProjectPO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode(atomReqBO.getStatusChangeOperCode());
        whereStatusCirculationConfPO.setPurchaseMode(sscProjectPO.getPurchaseMode());
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        block10: for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            switch (po.getChangeTable()) {
                case "1": {
                    this.dealProjectStatus(atomReqBO, po);
                    continue block10;
                }
                case "3": {
                    this.dealProjectSupplierStatus(atomReqBO, po);
                    continue block10;
                }
                case "4": {
                    this.dealProfessorStatus(atomReqBO, po);
                    continue block10;
                }
            }
            throw new BusinessException("8888", "\u672a\u77e5\u7684\u53d8\u66f4\u8868\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u72b6\u6001\u53d8\u66f4\u6210\u529f\uff01");
        return rsp;
    }

    private void dealProfessorStatus(SscDealStatusCirculationConfAtomReqBO atomReqBO, SscStatusCirculationConfPO sscStatusCirculationConfPO) {
        SscProfessorStagePO whereProfessorStagePO = new SscProfessorStagePO();
        whereProfessorStagePO.setProjectId(atomReqBO.getProjectId());
        whereProfessorStagePO.setPlanId(atomReqBO.getPlanId());
        List<SscProfessorStagePO> sscProfessorStagePOs = this.sscProfessorStageDAO.getList(whereProfessorStagePO);
        if (!CollectionUtils.isEmpty(sscProfessorStagePOs)) {
            ArrayList<String> oldStatuss = new ArrayList<String>();
            if (sscStatusCirculationConfPO.getOldStatus().contains(",")) {
                oldStatuss = Arrays.asList(sscStatusCirculationConfPO.getOldStatus().split(","));
            } else {
                oldStatuss.add(sscStatusCirculationConfPO.getOldStatus());
            }
            SscProfessorStagePO updatePO = new SscProfessorStagePO();
            updatePO.setOldProfessorStatuss(oldStatuss);
            updatePO.setProjectId(atomReqBO.getProjectId());
            updatePO.setPlanId(atomReqBO.getPlanId());
            updatePO.setProfessorStatus(sscStatusCirculationConfPO.getNewStatus());
            int n = this.sscProfessorStageDAO.updateByCondition(updatePO);
        }
    }

    private void dealProjectSupplierStatus(SscDealStatusCirculationConfAtomReqBO atomReqBO, SscStatusCirculationConfPO sscStatusCirculationConfPO) {
        SscProjectSupplierPO whwereProjectSupplierPO = new SscProjectSupplierPO();
        whwereProjectSupplierPO.setProjectId(atomReqBO.getProjectId());
        whwereProjectSupplierPO.setPlanId(atomReqBO.getPlanId());
        List<SscProjectSupplierPO> sscProjectSupplierPOs = this.sscProjectSupplierDAO.getList(whwereProjectSupplierPO);
        if (!CollectionUtils.isEmpty(sscProjectSupplierPOs)) {
            ArrayList<String> oldStatuss = new ArrayList<String>();
            if (sscStatusCirculationConfPO.getOldStatus().contains(",")) {
                oldStatuss = Arrays.asList(sscStatusCirculationConfPO.getOldStatus().split(","));
            } else {
                oldStatuss.add(sscStatusCirculationConfPO.getOldStatus());
            }
            SscProjectSupplierPO updatePO = new SscProjectSupplierPO();
            updatePO.setOldSupplierStatuss(oldStatuss);
            updatePO.setProjectId(atomReqBO.getProjectId());
            updatePO.setPlanId(atomReqBO.getPlanId());
            updatePO.setSupplierStatus(sscStatusCirculationConfPO.getNewStatus());
            int n = this.sscProjectSupplierDAO.updateByCondition(updatePO);
        }
    }

    private void dealProjectStatus(SscDealStatusCirculationConfAtomReqBO atomReqBO, SscStatusCirculationConfPO sscStatusCirculationConfPO) {
        SscProjectPO whereProjectPO = new SscProjectPO();
        whereProjectPO.setProjectId(atomReqBO.getProjectId());
        whereProjectPO.setPlanId(atomReqBO.getPlanId());
        SscProjectPO sscProjectPO = this.sscProjectDAO.getModelBy(whereProjectPO);
        if (null == sscProjectPO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList<String> oldStatuss = new ArrayList<String>();
        if (sscStatusCirculationConfPO.getOldStatus().contains(",")) {
            oldStatuss = Arrays.asList(sscStatusCirculationConfPO.getOldStatus().split(","));
        } else {
            oldStatuss.add(sscStatusCirculationConfPO.getOldStatus());
        }
        whereProjectPO.setOldProjectStatuss(oldStatuss);
        whereProjectPO.setProjectStatus(sscStatusCirculationConfPO.getNewStatus());
        int isUpdate = this.sscProjectDAO.updateByPrimaryKeySelective(whereProjectPO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01\uff01");
        }
    }
}

