/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectSupplierBO;
import com.tydic.ssc.dao.SscProjectBidRoundDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectQuotationRoundDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.po.SscProjectBidRoundPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectQuotationRoundPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.service.busi.SscAddProjectQuotationRoundBusiService;
import com.tydic.ssc.service.busi.bo.SscAddProjectQuotationRoundBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscAddProjectQuotationRoundBusiRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscAddProjectQuotationRoundBusiServiceImpl
implements SscAddProjectQuotationRoundBusiService {
    @Autowired
    private SscProjectQuotationRoundDAO sscProjectQuotationRoundDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscProjectBidRoundDAO sscProjectBidRoundDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProjectDAO sscProjectDAO;

    @Override
    public SscAddProjectQuotationRoundBusiRspBO addProjectQuotationRound(SscAddProjectQuotationRoundBusiReqBO reqBO) {
        if (CollectionUtils.isNotEmpty(reqBO.getProjectSupplierBOs())) {
            List<SscProjectSupplierPO> list = this.sscProjectSupplierDAO.selectProjectSupplier(reqBO.getProjectSupplierBOs());
            if (CollectionUtils.isEmpty(list)) {
                this.changeParams(reqBO.getProjectSupplierBOs(), reqBO.getProjectId());
            } else if (CollectionUtils.isEqualCollection((Collection)reqBO.getProjectSupplierBOs().stream().map(v -> v.getSupplierId()).distinct().collect(Collectors.toList()), (Collection)list.stream().map(g -> g.getSupplierId()).distinct().collect(Collectors.toList()))) {
                int z = this.sscProjectSupplierDAO.updateProjectSuppliers(list, reqBO.getQuotationRound());
                if (z < 1) {
                    throw new BusinessException("8888", "\u4f9b\u5e94\u5546\u66f4\u65b0\u5931\u8d25");
                }
            } else {
                List<SscProjectSupplierPO> supplierPOS = list.stream().filter(i -> reqBO.getProjectSupplierBOs().stream().map(e -> e.getSupplierId()).collect(Collectors.toList()).contains(i.getSupplierId())).collect(Collectors.toList());
                int z = this.sscProjectSupplierDAO.updateProjectSuppliers(supplierPOS, reqBO.getQuotationRound());
                if (z < 1) {
                    throw new BusinessException("8888", "\u4f9b\u5e94\u5546\u66f4\u65b0\u5931\u8d25");
                }
                List<SscProjectSupplierBO> supplierPOList = reqBO.getProjectSupplierBOs().stream().filter(e -> !list.stream().map(i -> i.getSupplierId()).collect(Collectors.toList()).contains(e.getSupplierId())).collect(Collectors.toList());
                this.changeParams(supplierPOList, reqBO.getProjectId());
            }
        }
        SscProjectBidRoundPO sscProjectBidRoundPO = this.sscProjectBidRoundDAO.selectBeforeQUotationRound(reqBO);
        SscProjectBidRoundPO bidRoundPO = new SscProjectBidRoundPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)bidRoundPO);
        if (sscProjectBidRoundPO != null) {
            bidRoundPO.setEstimateBidProfessorNum(sscProjectBidRoundPO.getEstimateBidProfessorNum());
            bidRoundPO.setSignInProfessorNum(sscProjectBidRoundPO.getSignInProfessorNum());
            bidRoundPO.setSignInFinishTime(sscProjectBidRoundPO.getSignInFinishTime());
            bidRoundPO.setBidOpenStatus(sscProjectBidRoundPO.getBidOpenStatus());
        }
        bidRoundPO.setBidRoundId(Sequence.getInstance().nextId());
        bidRoundPO.setBidStatus("4");
        bidRoundPO.setScoreRound(reqBO.getQuotationRound());
        bidRoundPO.setQuotationLimitTime(reqBO.getQuotationEndTime());
        bidRoundPO.setOperTime(new Date());
        this.sscProjectBidRoundDAO.insertSelective(bidRoundPO);
        SscProjectQuotationRoundPO roundPO = new SscProjectQuotationRoundPO();
        roundPO.setQuotationRoundId(Sequence.getInstance().nextId());
        BeanUtils.copyProperties((Object)reqBO, (Object)roundPO);
        this.sscProjectQuotationRoundDAO.insertSelective(roundPO);
        this.sscProjectDetailDAO.updateMoreQuotationRound(reqBO);
        SscAddProjectQuotationRoundBusiRspBO roundBusiRspBO = new SscAddProjectQuotationRoundBusiRspBO();
        roundBusiRspBO.setRespCode("0000");
        roundBusiRspBO.setRespDesc("\u62a5\u4ef7\u8f6e\u6b21\u65b0\u589e\u6210\u529f");
        return roundBusiRspBO;
    }

    private void changeParams(List<SscProjectSupplierBO> supplierPOList, Long id) {
        SscProjectPO sscProjectPO = new SscProjectPO();
        sscProjectPO.setProjectId(id);
        SscProjectPO modelBy = this.sscProjectDAO.getModelBy(sscProjectPO);
        for (SscProjectSupplierBO projectSupplierBO : supplierPOList) {
            projectSupplierBO.setProjectId(id);
            projectSupplierBO.setProjectSupplierId(Long.valueOf(Sequence.getInstance().nextId()));
            projectSupplierBO.setPayMode(modelBy.getPayMode());
            projectSupplierBO.setTradeMode(modelBy.getTradeMode());
            projectSupplierBO.setExpecSettleDay(modelBy.getExpecSettleDay());
            projectSupplierBO.setExpecSettleMethod(modelBy.getExpecSettleMethod());
            projectSupplierBO.setPrePay(modelBy.getPrePay());
            projectSupplierBO.setPilPay(modelBy.getPilPay());
            projectSupplierBO.setVerPay(modelBy.getVerPay());
            projectSupplierBO.setTradeModeShow(modelBy.getTradeModeShow());
            projectSupplierBO.setPayModeShow(modelBy.getPayModeShow());
            projectSupplierBO.setQualityMoney(modelBy.getQualityMoney());
            projectSupplierBO.setQualityPeriod(modelBy.getQualityPeriod());
            projectSupplierBO.setSupplierStatus("5");
            projectSupplierBO.setInvitationSession("4");
        }
        int i = this.sscProjectSupplierDAO.insertProjectSuppliers(supplierPOList);
        if (i < 1) {
            throw new BusinessException("8888", "\u4f9b\u5e94\u5546\u6dfb\u52a0\u5931\u8d25");
        }
    }
}

