/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscImoprtTemplateBO;
import com.tydic.ssc.common.SscProjectDetailBO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscAddProjectDetailBusiService;
import com.tydic.ssc.service.busi.SscImportProjectMaterialItemBusiService;
import com.tydic.ssc.service.busi.bo.SscAddProjectDetailBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscAddProjectDetailBusiRspBO;
import com.tydic.ssc.service.busi.bo.SscImportProjectMaterialItemBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscImportProjectMaterialItemBusiRspBO;
import com.tydic.ssc.service.utils.ExcelUtils;
import com.tydic.ssc.service.utils.HttpUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SscImportProjectMaterialItemBusiServiceImpl
implements SscImportProjectMaterialItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscImportProjectMaterialItemBusiServiceImpl.class);
    @Autowired
    private SscAddProjectDetailBusiService sscAddProjectDetailBusiService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscImportProjectMaterialItemBusiRspBO importProjectMaterialItem(SscImportProjectMaterialItemBusiReqBO reqBO) {
        SscImportProjectMaterialItemBusiRspBO rspBO = new SscImportProjectMaterialItemBusiRspBO();
        List<SscProjectDetailBO> sscProjectDetailBOS = this.analysisFile(reqBO);
        SscAddProjectDetailBusiReqBO sscAddProjectDetailBusiReqBO = new SscAddProjectDetailBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)sscAddProjectDetailBusiReqBO);
        sscAddProjectDetailBusiReqBO.setSscProjectDetailBOs(sscProjectDetailBOS);
        SscAddProjectDetailBusiRspBO sscAddProjectDetailBusiRspBO = this.sscAddProjectDetailBusiService.addProjectDetail(sscAddProjectDetailBusiReqBO);
        if (!"0000".equals(sscAddProjectDetailBusiRspBO.getRespCode())) {
            throw new BusinessException(sscAddProjectDetailBusiRspBO.getRespCode(), sscAddProjectDetailBusiRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u7269\u6599\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6210\u529f");
        return rspBO;
    }

    private List<SscProjectDetailBO> analysisFile(SscImportProjectMaterialItemBusiReqBO materialBusiReqBO) {
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        if (StringUtils.isBlank((CharSequence)materialBusiReqBO.getFileUrl())) {
            throw new BusinessException("8888", "\u9879\u76ee\u7269\u6599\u660e\u7ec6\u5bfc\u5165API\u5165\u53c2\u3010fileUrl\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(materialBusiReqBO.getFileUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            ExcelUtils.getExcelDate((MultipartFile)multipartFile, data, title, 14);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>(16);
        String importTemplateStr = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("SSC", "IMPORT_MATERIAL_TEMPLATE_CODE", "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, SscImoprtTemplateBO.class);
        log.info("templateBOs=============\uff1a" + JSON.toJSONString((Object)templateBOs));
        block2: for (SscImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block2;
            }
        }
        log.info("dateMapIndex===========\uff1a" + JSON.toJSONString(dateMapIndex));
        ArrayList materialList = new ArrayList();
        int row = 2;
        int lastSheet = 0;
        for (List list : data) {
            if (data.size() < 1) {
                throw new BusinessException("8888", "\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            }
            HashMap<String, Object> materialMap = new HashMap<String, Object>(16);
            for (SscImoprtTemplateBO templateBO : templateBOs) {
                boolean bool;
                Object content;
                log.info("templateBO==========\uff1a" + JSON.toJSONString((Object)templateBO));
                Integer sheetKey = (Integer)dateMapIndex.get(templateBO.getFieldNameEng());
                if (null != sheetKey) {
                    lastSheet = sheetKey;
                }
                log.info("sheetKey==========\uff1a" + JSON.toJSONString((Object)sheetKey));
                if (null != sheetKey) {
                    content = list.get(sheetKey);
                    if (templateBO.getIsMustFill().booleanValue()) {
                        if (null == content || "".equals(content) || "null".equals(content)) {
                            throw new BusinessException("8888", "\u9879\u76ee\u7269\u6599\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7b2c" + row + "\u884c\u7b2c" + (sheetKey + 1) + "\u5217\u3010" + templateBO.getFieldName() + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    } else if ("null".equals(content)) {
                        content = "";
                    }
                } else {
                    throw new BusinessException("8888", "\u9879\u76ee\u7269\u6599\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7b2c" + (lastSheet + 2) + "\u5217\u3010" + templateBO.getFieldName() + "\u3011\u6a21\u677f\u914d\u7f6e\u4e3a\u7a7a");
                }
                if ("deliveryEndTime".equals(templateBO.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)content.toString()) && !(bool = this.verifyDate(content.toString()))) {
                    throw new BusinessException("8888", "\u9879\u76ee\u7269\u6599\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7b2c" + row + "\u884c\u7b2c" + (sheetKey + 1) + "\u5217\u3010" + templateBO.getFieldName() + "\u3011\u65e5\u671f\u683c\u5f0f\u6709\u8bef");
                }
                if ("bugetUnitPrice".equals(templateBO.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)content.toString())) {
                    content = new BigDecimal(content.toString()).multiply(new BigDecimal(10000));
                }
                if ("historyUnitPrice".equals(templateBO.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)content.toString())) {
                    content = new BigDecimal(content.toString()).multiply(new BigDecimal(10000));
                }
                materialMap.put(templateBO.getFieldNameEng(), content);
            }
            materialList.add(materialMap);
            ++row;
        }
        String jsonString = JSON.toJSONString(materialList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List list = JSON.parseArray((String)jsonString, SscProjectDetailBO.class);
        return list;
    }

    private boolean verifyDate(String obj) {
        String timeRegex = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s+([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        return Pattern.matches(timeRegex, obj);
    }
}

