/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProfessorProjectBO;
import com.tydic.ssc.dao.SscProfessorStageDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryProfessorProjectListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProfessorProjectListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProfessorProjectListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryProfessorProjectListBusiServiceImpl
implements SscQryProfessorProjectListBusiService {
    @Autowired
    private SscProfessorStageDAO sscProfessorStageDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryProfessorProjectListBusiRspBO qryProfessorProjectList(SscQryProfessorProjectListBusiReqBO reqBO) {
        List<SscProfessorProjectBO> professorProjectList;
        SscQryProfessorProjectListBusiRspBO rspBO = new SscQryProfessorProjectListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (reqBO.getQueryPageFlag().booleanValue()) {
            professorProjectList = this.sscProfessorStageDAO.getProfessorProjectList(reqBO, (Page<SscProfessorProjectBO>)page);
        } else {
            page.setPageNo(-1);
            page.setPageSize(-1);
            professorProjectList = this.sscProfessorStageDAO.getProfessorProjectList(reqBO, (Page<SscProfessorProjectBO>)page);
        }
        if (CollectionUtils.isEmpty(professorProjectList)) {
            rspBO.setRespDesc("\u4e13\u5bb6\u9879\u76ee\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        List<Long> projectIds = professorProjectList.stream().map(SscProfessorProjectBO::getProjectId).collect(Collectors.toList());
        if (reqBO.getQueryExtInfo().booleanValue()) {
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                professorProjectList.forEach(e -> e.setSscProjectExtMap((Map)sscProjectExtMap.get(e.getProjectId())));
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateField(professorProjectList);
        }
        rspBO.setRows(professorProjectList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespDesc("\u4e13\u5bb6\u9879\u76ee\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateField(List<SscProfessorProjectBO> professorProjectList) {
        Map<String, String> projectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_STATUS");
        Map<String, String> purchaseModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
        Map<String, String> quotationModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUOTATION_MODE");
        Map<String, String> commonMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
        Map<String, String> professorStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROFESSOR_STATUS");
        for (SscProfessorProjectBO sscProfessorProjectBO : professorProjectList) {
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getProjectStatus())) {
                sscProfessorProjectBO.setProjectStatusStr(projectStatusMap.get(sscProfessorProjectBO.getProjectStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getPurchaseMode())) {
                sscProfessorProjectBO.setPurchaseModeStr(purchaseModeMap.get(sscProfessorProjectBO.getPurchaseMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getTenderMode())) {
                sscProfessorProjectBO.setTenderModeStr(tenderModeMap.get(sscProfessorProjectBO.getTenderMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getQuotationMode())) {
                sscProfessorProjectBO.setQuotationModeStr(quotationModeMap.get(sscProfessorProjectBO.getQuotationMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getIsNeedMargin())) {
                sscProfessorProjectBO.setIsNeedMarginStr(commonMap.get(sscProfessorProjectBO.getIsNeedMargin()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getBudgetPublic())) {
                sscProfessorProjectBO.setBudgetPublicStr(commonMap.get(sscProfessorProjectBO.getBudgetPublic()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getIsAttend())) {
                sscProfessorProjectBO.setIsAttendStr(commonMap.get(sscProfessorProjectBO.getIsAttend()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getIsSign())) {
                sscProfessorProjectBO.setIsSignStr(commonMap.get(sscProfessorProjectBO.getIsSign()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getIsEvaBid())) {
                sscProfessorProjectBO.setIsEvaBidStr(commonMap.get(sscProfessorProjectBO.getIsEvaBid()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getIsSignCommit())) {
                sscProfessorProjectBO.setIsSignCommitStr(commonMap.get(sscProfessorProjectBO.getIsSignCommit()));
            }
            if (!StringUtils.isNotBlank((CharSequence)sscProfessorProjectBO.getProfessorStatus())) continue;
            sscProfessorProjectBO.setProfessorStatusStr(professorStatusMap.get(sscProfessorProjectBO.getProfessorStatus()));
        }
    }
}

