/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscSupplierStageBO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryStageSupplierListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryStageSupplierListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryStageSupplierListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryStageSupplierListBusiServiceImpl
implements SscQryStageSupplierListBusiService {
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryStageSupplierListBusiRspBO qryStageSupplierList(SscQryStageSupplierListBusiReqBO reqBO) {
        Page page;
        List<SscSupplierStageBO> sscSupplierProjectBOS;
        SscQryStageSupplierListBusiRspBO rspBO = new SscQryStageSupplierListBusiRspBO();
        if (!reqBO.getQueryPageFlag().booleanValue()) {
            reqBO.setPageNo(-1);
            reqBO.setPageSize(-1);
        }
        if (CollectionUtils.isEmpty(sscSupplierProjectBOS = this.sscSupplierStageDAO.getStageSupplierList(reqBO, (Page<SscSupplierStageBO>)(page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue()))))) {
            rspBO.setRespDesc("\u6807\u6bb5\u4f9b\u5e94\u5546\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectObjectIds = sscSupplierProjectBOS.stream().map(SscSupplierStageBO::getSupplierStageId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("6");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectObjectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                for (SscSupplierStageBO sscSupplierProjectBO : sscSupplierProjectBOS) {
                    sscSupplierProjectBO.setStageSupplierExtMap(sscProjectExtMap.get(sscSupplierProjectBO.getSupplierStageId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscSupplierProjectBOS);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscSupplierProjectBOS);
        rspBO.setRespDesc("\u6807\u6bb5\u4f9b\u5e94\u5546\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscSupplierStageBO> sscSupplierProjectBOS) {
        Map<String, String> stageSupplierStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "SUPPLIER_STATUS");
        Map<String, String> stageMarginStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "STAGE_MARGIN_STATUS");
        for (SscSupplierStageBO bo : sscSupplierProjectBOS) {
            if (StringUtils.isNotBlank((CharSequence)bo.getStageSupplierStatus())) {
                bo.setStageSupplierStatusStr(stageSupplierStatusMap.get(bo.getStageSupplierStatus()));
            }
            if (!StringUtils.isNotBlank((CharSequence)bo.getStageMarginStatus())) continue;
            bo.setStageMarginStatusStr(stageMarginStatusMap.get(bo.getStageMarginStatus()));
        }
    }
}

