/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectBidRoundDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscStatusCirculationConfDAO;
import com.tydic.ssc.dao.po.SscProjectBidRoundPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscStatusCirculationConfPO;
import com.tydic.ssc.service.busi.SscUpdateProjectStatusTimeBusiService;
import com.tydic.ssc.service.busi.bo.SscUpdateProjectStatusTimeBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscUpdateProjectStatusTimeBusiRspBO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscUpdateProjectStatusTimeBusiServiceImpl
implements SscUpdateProjectStatusTimeBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscStatusCirculationConfDAO sscStatusCirculationConfDAO;
    @Autowired
    private SscProjectBidRoundDAO sscProjectBidRoundDAO;

    @Override
    public SscUpdateProjectStatusTimeBusiRspBO updateProjectStatus(SscUpdateProjectStatusTimeBusiReqBO busiReqBO) {
        SscUpdateProjectStatusTimeBusiRspBO rsp = new SscUpdateProjectStatusTimeBusiRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9879\u76ee\u72b6\u6001\u6d41\u8f6c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff01");
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
        SscStatusCirculationConfPO sscStatusCirculationConfPO = this.sscStatusCirculationConfDAO.getModelBy(whereStatusCirculationConfPO);
        if (null == sscStatusCirculationConfPO) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        switch (busiReqBO.getCirculationType()) {
            case "1": {
                this.updateProjectStatus(busiReqBO, sscStatusCirculationConfPO);
                break;
            }
            case "2": {
                this.updateProjectStatus(busiReqBO, sscStatusCirculationConfPO);
                break;
            }
            case "3": {
                this.updateProjectBidRoundStatus(busiReqBO, sscStatusCirculationConfPO);
                break;
            }
        }
        return rsp;
    }

    private void updateProjectBidRoundStatus(SscUpdateProjectStatusTimeBusiReqBO busiReqBO, SscStatusCirculationConfPO sscStatusCirculationConfPO) {
        SscProjectBidRoundPO wherePO = new SscProjectBidRoundPO();
        wherePO.setQuotationLimitTime(busiReqBO.getQryTime());
        wherePO.setBidStatus(sscStatusCirculationConfPO.getOldStatus());
        List<Long> bidRoundIds = this.sscProjectBidRoundDAO.getListForTime(wherePO);
        if (CollectionUtils.isEmpty(bidRoundIds)) {
            return;
        }
        SscProjectBidRoundPO updatePO = new SscProjectBidRoundPO();
        updatePO.setBidRoundIds(bidRoundIds);
        updatePO.setBidStatus(sscStatusCirculationConfPO.getNewStatus());
        int isUpdate = this.sscProjectBidRoundDAO.updateByCondition(updatePO);
        if (isUpdate != bidRoundIds.size()) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8bc4\u6807\u8f6e\u6b21\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateProjectStatus(SscUpdateProjectStatusTimeBusiReqBO busiReqBO, SscStatusCirculationConfPO sscStatusCirculationConfPO) {
        SscProjectPO whereProjectPO = new SscProjectPO();
        whereProjectPO.setProjectStatus(sscStatusCirculationConfPO.getOldStatus());
        if ("1".equals(busiReqBO.getCirculationType())) {
            whereProjectPO.setApplyEndTime(busiReqBO.getQryTime());
        } else if ("2".equals(busiReqBO.getCirculationType())) {
            whereProjectPO.setBidEndTime(busiReqBO.getQryTime());
        }
        List<Long> projectIds = this.sscProjectDAO.getListForTime(whereProjectPO);
        if (CollectionUtils.isEmpty(projectIds)) {
            return;
        }
        SscProjectPO updatePO = new SscProjectPO();
        updatePO.setProjectIds(projectIds);
        updatePO.setProjectStatus(sscStatusCirculationConfPO.getNewStatus());
        int isUpdate = this.sscProjectDAO.updateByPrimaryKeySelective(updatePO);
        if (isUpdate != projectIds.size()) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
        }
    }
}

