/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectAttachBO;
import com.tydic.ssc.common.SscProjectClearBO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectClearDAO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryClearListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryClearListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryClearListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQryClearListBusiServiceImpl
implements SscQryClearListBusiService {
    @Autowired
    private SscProjectClearDAO sscProjectClearDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;

    @Override
    public SscQryClearListBusiRspBO qryClearList(SscQryClearListBusiReqBO busiReqBO) {
        Page page;
        List<SscProjectClearBO> rows;
        SscQryClearListBusiRspBO rsp = new SscQryClearListBusiRspBO();
        if (!busiReqBO.getQueryPageFlag().booleanValue()) {
            busiReqBO.setPageNo(-1);
            busiReqBO.setPageSize(-1);
        }
        if (CollectionUtils.isEmpty(rows = this.sscProjectClearDAO.getListPage(busiReqBO, (Page<SscProjectClearBO>)(page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue()))))) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (busiReqBO.getTranslateFlag().booleanValue()) {
            Map<String, String> yesOrNoMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
            Map<String, String> clearLaunchSourceMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "CLEAR_LAUNCH_SOURCE");
            Map<String, String> clearStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "CLEAR_STATUS");
            Map<String, String> clearStageMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "CLEAR_STAGE");
            for (SscProjectClearBO bo : rows) {
                if (StringUtils.isNotBlank((CharSequence)bo.getClearIsPublic())) {
                    bo.setClearIsPublicStr(yesOrNoMap.get(bo.getClearIsPublic()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getClearLaunchSource())) {
                    bo.setClearLaunchSourceStr(clearLaunchSourceMap.get(bo.getClearLaunchSource()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getClearStatus())) {
                    bo.setClearStatusStr(clearStatusMap.get(bo.getClearStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getResponseIsPublic())) {
                    bo.setResponseIsPublicStr(yesOrNoMap.get(bo.getResponseIsPublic()));
                }
                if (!StringUtils.isNotBlank((CharSequence)bo.getClearStage())) continue;
                bo.setClearStageStr(clearStageMap.get(bo.getClearStage()));
            }
        }
        this.getAttachList(rows, "3");
        this.getAttachList(rows, "4");
        rsp.setPageNo(page.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6f84\u6e05\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private void getAttachList(List<SscProjectClearBO> rows, String ProjectObjectType2) {
        List<Long> clearIds = rows.stream().map(SscProjectClearBO::getClearId).collect(Collectors.toList());
        SscProjectAttachPO sscProjectAttachPO = new SscProjectAttachPO();
        sscProjectAttachPO.setProjectObjectIds(clearIds);
        sscProjectAttachPO.setProjectObjectType(ProjectObjectType2);
        List<SscProjectAttachPO> sscProjectAttachPOS = this.sscProjectAttachDAO.getList(sscProjectAttachPO);
        if (CollectionUtils.isNotEmpty(sscProjectAttachPOS)) {
            for (SscProjectClearBO row : rows) {
                String clearId = row.getClearId().toString();
                List sscProjectAttachPOList = sscProjectAttachPOS.stream().filter(e -> e.getProjectObjectId().toString().equals(clearId)).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(sscProjectAttachPOList)) continue;
                String jsonString = JSON.toJSONString(sscProjectAttachPOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                List clearAttachBOs = JSON.parseArray((String)jsonString, SscProjectAttachBO.class);
                if ("3".equals(ProjectObjectType2)) {
                    row.setClearAttachBOs(clearAttachBOs);
                    continue;
                }
                if (!"4".equals(ProjectObjectType2)) continue;
                row.setResponseAttachBOs(clearAttachBOs);
            }
        }
    }
}

