/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscAuditBO;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscAuditDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscProjectTempAttachDAO;
import com.tydic.ssc.dao.SscSupplierAttachDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailLogDAO;
import com.tydic.ssc.dao.SscSupplierQuotationLogDAO;
import com.tydic.ssc.dao.po.SscAuditPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscProjectTempAttachPO;
import com.tydic.ssc.dao.po.SscSupplierAttachPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailLogPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationLogPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationPO;
import com.tydic.ssc.service.busi.SscSupplierQuotationApprovalBusiService;
import com.tydic.ssc.service.busi.bo.SscSupplierQuotationApprovalBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscSupplierQuotationApprovalBusiRspBO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscSupplierQuotationApprovalBusiServiceImpl
implements SscSupplierQuotationApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscSupplierQuotationApprovalBusiServiceImpl.class);
    @Autowired
    private SscAuditDAO sscAuditDAO;
    @Autowired
    private SscSupplierQuotationDAO sscSupplierQuotationDAO;
    @Autowired
    private SscSupplierQuotationDetailDAO sscSupplierQuotationDetailDAO;
    @Autowired
    private SscSupplierQuotationLogDAO sscSupplierQuotationLogDAO;
    @Autowired
    private SscSupplierQuotationDetailLogDAO sscSupplierQuotationDetailLogDAO;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProjectTempAttachDAO sscProjectTempAttachDAO;
    @Autowired
    private SscSupplierAttachDAO sscSupplierAttachDAO;

    @Override
    public SscSupplierQuotationApprovalBusiRspBO dealSupplierQuotationApproval(SscSupplierQuotationApprovalBusiReqBO busiReqBO) {
        SscSupplierQuotationApprovalBusiRspBO rsp = new SscSupplierQuotationApprovalBusiRspBO();
        SscSupplierQuotationPO whereSupplierQuotationPO = new SscSupplierQuotationPO();
        whereSupplierQuotationPO.setQuotationIds(busiReqBO.getQuotationIds());
        List<SscSupplierQuotationPO> sscSupplierQuotationPOs = this.sscSupplierQuotationDAO.getList(whereSupplierQuotationPO);
        if (CollectionUtils.isEmpty(sscSupplierQuotationPOs)) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (sscSupplierQuotationPOs.size() != busiReqBO.getQuotationIds().size()) {
            throw new BusinessException("8888", "\u5b58\u5728\u62a5\u4ef7Id\u4e0d\u5728\u6570\u636e\u5e93\u4e2d\uff01");
        }
        HashMap<Long, SscSupplierQuotationPO> quotationPOMap = new HashMap<Long, SscSupplierQuotationPO>();
        for (SscSupplierQuotationPO po : sscSupplierQuotationPOs) {
            quotationPOMap.put(po.getQuotationId(), po);
        }
        Map<String, Set<Long>> stepProjectIdMap = this.validProjectInfo(busiReqBO, sscSupplierQuotationPOs);
        for (String stepId : stepProjectIdMap.keySet()) {
            busiReqBO.setQuotationIds(new ArrayList<Long>((Collection)stepProjectIdMap.get(stepId)));
            Boolean processEndFlag = this.invokeProcess(busiReqBO, stepId);
            if (!processEndFlag.booleanValue()) continue;
            for (Long quotationId : busiReqBO.getQuotationIds()) {
                SscSupplierQuotationPO sscSupplierQuotationPO = (SscSupplierQuotationPO)quotationPOMap.get(quotationId);
                if (1 == busiReqBO.getAuditResult()) {
                    this.updateQuotationStatus(sscSupplierQuotationPO, "2");
                    if (busiReqBO.getIsOperAttach().booleanValue()) {
                        this.deleteProjectTempAttach(sscSupplierQuotationPO);
                    }
                } else if (0 == busiReqBO.getAuditResult()) {
                    this.updateQuotationStatus(sscSupplierQuotationPO, "1");
                    sscSupplierQuotationPO.setQuotationStatus("1");
                    this.insertLog(sscSupplierQuotationPO);
                    if (busiReqBO.getIsOperAttach().booleanValue()) {
                        this.updateAttachToSupplier(sscSupplierQuotationPO);
                    }
                }
                this.updateSupplierStatus(sscSupplierQuotationPO, busiReqBO.getAuditResult());
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f9b\u5e94\u5546\u62a5\u4ef7\u5ba1\u6838\u6210\u529f\uff01");
        return rsp;
    }

    private void updateAttachToSupplier(SscSupplierQuotationPO sscSupplierQuotationPO) {
        SscSupplierAttachPO deletePO = new SscSupplierAttachPO();
        deletePO.setProjectId(sscSupplierQuotationPO.getProjectId());
        deletePO.setSupplierId(sscSupplierQuotationPO.getSupplierId());
        this.sscSupplierAttachDAO.deleteBy(deletePO);
        SscProjectTempAttachPO wherePO = new SscProjectTempAttachPO();
        wherePO.setProjectId(sscSupplierQuotationPO.getProjectId());
        wherePO.setSupplierId(sscSupplierQuotationPO.getSupplierId());
        wherePO.setTacheCode("1");
        wherePO.setProjectObjectType("9");
        wherePO.setProjectObjectId(sscSupplierQuotationPO.getSupplierId());
        List<SscProjectTempAttachPO> sscProjectTempAttachPOs = this.sscProjectTempAttachDAO.getList(wherePO);
        if (!CollectionUtils.isEmpty(sscProjectTempAttachPOs)) {
            ArrayList<SscSupplierAttachPO> insertPOs = new ArrayList<SscSupplierAttachPO>();
            for (SscProjectTempAttachPO po : sscProjectTempAttachPOs) {
                SscSupplierAttachPO sscSupplierAttachPO = new SscSupplierAttachPO();
                sscSupplierAttachPO.setEncryAttachId(Sequence.getInstance().nextId());
                sscSupplierAttachPO.setProjectId(sscSupplierQuotationPO.getProjectId());
                sscSupplierAttachPO.setSupplierId(sscSupplierQuotationPO.getSupplierId());
                sscSupplierAttachPO.setSupplierAttachName(po.getProjectAttachName());
                sscSupplierAttachPO.setSupplierAttachAddress(po.getProjectAttachAddress());
                sscSupplierAttachPO.setSupplierAttachType(po.getProjectAttachType());
                insertPOs.add(sscSupplierAttachPO);
            }
            int isInsert = this.sscSupplierAttachDAO.insertList(insertPOs);
            if (isInsert != insertPOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u9644\u4ef6\u8868\u5931\u8d25\uff01");
            }
        }
        this.sscProjectTempAttachDAO.deleteBy(wherePO);
    }

    private void deleteProjectTempAttach(SscSupplierQuotationPO sscSupplierQuotationPO) {
        SscProjectTempAttachPO deletePO = new SscProjectTempAttachPO();
        deletePO.setProjectId(sscSupplierQuotationPO.getProjectId());
        deletePO.setSupplierId(sscSupplierQuotationPO.getSupplierId());
        deletePO.setTacheCode("1");
        deletePO.setProjectObjectType("9");
        deletePO.setProjectObjectId(sscSupplierQuotationPO.getSupplierId());
        this.sscProjectTempAttachDAO.deleteBy(deletePO);
    }

    private void updateSupplierStatus(SscSupplierQuotationPO sscSupplierQuotationPO, Integer auditResult) {
        SscProjectSupplierPO updateProjectSupplierPO = new SscProjectSupplierPO();
        updateProjectSupplierPO.setProjectId(sscSupplierQuotationPO.getProjectId());
        updateProjectSupplierPO.setStageId(sscSupplierQuotationPO.getStageId());
        updateProjectSupplierPO.setSupplierId(sscSupplierQuotationPO.getSupplierId());
        if (1 == auditResult) {
            updateProjectSupplierPO.setSupplierStatus("7");
        } else if (0 == auditResult) {
            updateProjectSupplierPO.setSupplierStatus("8");
        }
        int isUpdate = this.sscProjectSupplierDAO.updateByCondition(updateProjectSupplierPO);
        if (isUpdate != 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
        }
    }

    private void insertLog(SscSupplierQuotationPO sscSupplierQuotationPO) {
        SscSupplierQuotationLogPO sscSupplierQuotationLogPO = new SscSupplierQuotationLogPO();
        BeanUtils.copyProperties((Object)sscSupplierQuotationPO, (Object)sscSupplierQuotationLogPO);
        int isInsert = this.sscSupplierQuotationLogDAO.insert(sscSupplierQuotationLogPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u4ef7\u5386\u53f2\u8868\u5931\u8d25\uff01");
        }
        SscSupplierQuotationDetailPO wherePO = new SscSupplierQuotationDetailPO();
        wherePO.setQuotationId(sscSupplierQuotationPO.getQuotationId());
        wherePO.setPlanId(sscSupplierQuotationPO.getPlanId());
        wherePO.setProjectId(sscSupplierQuotationPO.getProjectId());
        wherePO.setStageId(sscSupplierQuotationPO.getStageId());
        wherePO.setSupplierId(sscSupplierQuotationPO.getSupplierId());
        List<SscSupplierQuotationDetailPO> valuePOs = this.sscSupplierQuotationDetailDAO.getList(wherePO);
        if (CollectionUtils.isEmpty(valuePOs)) {
            throw new BusinessException("8888", "\u4f9b\u5e94\u5546\u62a5\u4ef7\u660e\u7ec6\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        ArrayList<SscSupplierQuotationDetailLogPO> sscSupplierQuotationDetailLogPOs = new ArrayList<SscSupplierQuotationDetailLogPO>();
        for (SscSupplierQuotationDetailPO po : valuePOs) {
            SscSupplierQuotationDetailLogPO sscSupplierQuotationDetailLogPO = new SscSupplierQuotationDetailLogPO();
            BeanUtils.copyProperties((Object)po, (Object)sscSupplierQuotationDetailLogPO);
            sscSupplierQuotationDetailLogPOs.add(sscSupplierQuotationDetailLogPO);
        }
        int isInsert2 = this.sscSupplierQuotationDetailLogDAO.insertBatch(sscSupplierQuotationDetailLogPOs);
        if (isInsert2 != valuePOs.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u4ef7\u660e\u7ec6\u5386\u53f2\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateQuotationStatus(SscSupplierQuotationPO sscSupplierQuotationPO, String quotationStatus) {
        SscSupplierQuotationPO updateWherePO = new SscSupplierQuotationPO();
        updateWherePO.setQuotationId(sscSupplierQuotationPO.getQuotationId());
        updateWherePO.setProjectId(sscSupplierQuotationPO.getProjectId());
        updateWherePO.setQuotationStatus(quotationStatus);
        int isUpdate = this.sscSupplierQuotationDAO.updateByPrimaryKeySelective(updateWherePO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u62a5\u4ef7\u8868\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    private Boolean invokeProcess(SscSupplierQuotationApprovalBusiReqBO busiReqBO, String stepId) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setObjId(busiReqBO.getQuotationIds());
        uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(busiReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(busiReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setOperId(busiReqBO.getOperId().toString());
        uacNoTaskAuditOrderAuditReqBO.setUsername(busiReqBO.getOperName());
        uacNoTaskAuditOrderAuditReqBO.setOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditOrderAuditReqBO.setObjType(SscCommConstant.AuditObjType.SUPPLIER_QUOTATION_AUDIT);
        uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }

    private Map<String, Set<Long>> validProjectInfo(SscSupplierQuotationApprovalBusiReqBO busiReqBO, List<SscSupplierQuotationPO> sscSupplierQuotationPOs) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        HashSet<Long> statusErrors = new HashSet<Long>();
        HashSet<Long> quotationIds = new HashSet<Long>();
        for (SscSupplierQuotationPO po : sscSupplierQuotationPOs) {
            if (!"0".equals(po.getQuotationStatus())) {
                statusErrors.add(po.getQuotationId());
            }
            quotationIds.add(po.getQuotationId());
        }
        if (statusErrors.size() > 0) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u3010" + ((Object)statusErrors).toString() + "\u3011\u72b6\u6001\u4e0d\u662f\u5ba1\u6838\u4e2d");
        }
        if (quotationIds.size() < busiReqBO.getQuotationIds().size()) {
            busiReqBO.getQuotationIds().removeAll(quotationIds);
            throw new BusinessException("8888", "\u62a5\u4ef7\u3010" + busiReqBO.getQuotationIds() + "\u3011\u4e0d\u5b58\u5728");
        }
        SscAuditPO sscAuditPO = new SscAuditPO();
        sscAuditPO.setObjType(SscCommConstant.AuditObjType.SUPPLIER_QUOTATION_AUDIT);
        sscAuditPO.setObjIds(quotationIds);
        sscAuditPO.setTabValue(1);
        sscAuditPO.setStationCodes(busiReqBO.getStationCodes());
        List<SscAuditBO> sscAuditBOs = this.sscAuditDAO.getAuditInfoByObjIds(sscAuditPO);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(sscAuditBOs)) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        HashSet stepIds = new HashSet();
        HashSet<Long> auditSize = new HashSet<Long>();
        Object stepId = null;
        for (SscAuditBO bo : sscAuditBOs) {
            HashSet<Long> quotationIdSet = (HashSet<Long>)result.get(bo.getStepId());
            if (null == quotationIdSet) {
                quotationIdSet = new HashSet<Long>();
            }
            quotationIdSet.add(bo.getObjId());
            result.put(bo.getStepId(), quotationIdSet);
            auditSize.add(bo.getObjId());
        }
        if (auditSize.size() < busiReqBO.getQuotationIds().size()) {
            busiReqBO.getQuotationIds().removeAll(auditSize);
            throw new BusinessException("8888", "\u62a5\u4ef7\u3010" + busiReqBO.getQuotationIds() + "\u3011\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        return result;
    }
}

