/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectExtDAO;
import com.tydic.ssc.dao.SscProjectMaterialTypeDAO;
import com.tydic.ssc.dao.SscProjectStageDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.ssc.dao.po.SscProjectExtPO;
import com.tydic.ssc.dao.po.SscProjectMaterialTypePO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.service.busi.SscProjectCopyBusiService;
import com.tydic.ssc.service.busi.bo.SscProjectCopyBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscProjectCopyBusiRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscProjectCopyBusiServiceImpl
implements SscProjectCopyBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;
    @Autowired
    private SscProjectExtDAO sscProjectExtDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProjectStageDAO sscProjectStageDAO;
    @Autowired
    private SscProjectMaterialTypeDAO sscProjectMaterialTypeDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;

    @Override
    public SscProjectCopyBusiRspBO dealSscProjectCopy(SscProjectCopyBusiReqBO busiReqBO) {
        SscProjectCopyBusiRspBO rsp = new SscProjectCopyBusiRspBO();
        this.copyProject(busiReqBO);
        this.copyProjectStage(busiReqBO);
        this.copyProjectMaterialType(busiReqBO);
        this.copyProjectDetail(busiReqBO);
        this.addProjectSupplier(busiReqBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9879\u76ee\u590d\u5236\u6210\u529f\uff01");
        return rsp;
    }

    private void copyProjectDetail(SscProjectCopyBusiReqBO busiReqBO) {
        SscProjectDetailPO whereProjectDetailPO = new SscProjectDetailPO();
        whereProjectDetailPO.setProjectId(busiReqBO.getOldProjectId());
        List<SscProjectDetailPO> sscProjectDetailPOs = this.sscProjectDetailDAO.getList(whereProjectDetailPO);
        if (!CollectionUtils.isEmpty(sscProjectDetailPOs)) {
            for (SscProjectDetailPO po : sscProjectDetailPOs) {
                po.setProjectDetailId(Sequence.getInstance().nextId());
                po.setProjectId(busiReqBO.getNewProjectId());
                po.setQuotationRound(1);
                po.setOperId(busiReqBO.getOperId());
                po.setOperName(busiReqBO.getOperName());
                po.setOperTime(new Date());
            }
            int isInsert = this.sscProjectDetailDAO.insertBatch(sscProjectDetailPOs);
            if (isInsert != sscProjectDetailPOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u660e\u7ec6\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void copyProjectMaterialType(SscProjectCopyBusiReqBO busiReqBO) {
        SscProjectMaterialTypePO whereProjectMaterialTypePO = new SscProjectMaterialTypePO();
        whereProjectMaterialTypePO.setProjectId(busiReqBO.getOldProjectId());
        List<SscProjectMaterialTypePO> sscProjectMaterialTypePOs = this.sscProjectMaterialTypeDAO.getList(whereProjectMaterialTypePO);
        if (!CollectionUtils.isEmpty(sscProjectMaterialTypePOs)) {
            for (SscProjectMaterialTypePO po : sscProjectMaterialTypePOs) {
                po.setProjectMaterialTypeId(Sequence.getInstance().nextId());
                po.setProjectId(busiReqBO.getNewProjectId());
            }
            int isInsert = this.sscProjectMaterialTypeDAO.insertBatch(sscProjectMaterialTypePOs);
            if (isInsert != sscProjectMaterialTypePOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u7269\u6599\u7c7b\u578b\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void copyProjectStage(SscProjectCopyBusiReqBO busiReqBO) {
    }

    private void copyProject(SscProjectCopyBusiReqBO busiReqBO) {
        SscProjectPO checkExeistPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getOldProjectId());
        if (null == checkExeistPO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76eeId\u4e0d\u5b58\u5728\uff01");
        }
        SscProjectPO insertProjectPO = new SscProjectPO();
        BeanUtils.copyProperties((Object)checkExeistPO, (Object)insertProjectPO);
        insertProjectPO.setProjectId(busiReqBO.getNewProjectId());
        insertProjectPO.setProjectNo(busiReqBO.getNewProjectNo());
        insertProjectPO.setProjectStatus("1");
        insertProjectPO.setProjectProducerId(busiReqBO.getOperId());
        insertProjectPO.setProjectProducerName(busiReqBO.getOperName());
        insertProjectPO.setProjectProducerTime(new Date());
        insertProjectPO.setProjectUpdateId(busiReqBO.getOperId());
        insertProjectPO.setProjectUpdateName(busiReqBO.getOperName());
        insertProjectPO.setProjectUpdateTime(new Date());
        insertProjectPO.setBidEndTime(null);
        insertProjectPO.setBidOpenTime(null);
        insertProjectPO.setBidOpenZone(null);
        insertProjectPO.setBidOpenAddress(null);
        insertProjectPO.setBidOpenNo(null);
        insertProjectPO.setBidOpenName(null);
        insertProjectPO.setBidOpenRoomId(null);
        insertProjectPO.setBidOpenRoomName(null);
        insertProjectPO.setProjectExtField1(null);
        int isUpdate = this.sscProjectDAO.updateByPrimaryKey(insertProjectPO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
        }
        this.addAttach(busiReqBO.getNewProjectId(), busiReqBO.getOldProjectId(), "1", busiReqBO.getNewProjectId());
        this.addExt(busiReqBO.getNewProjectId(), busiReqBO.getOldProjectId(), "1", busiReqBO.getNewProjectId());
    }

    private void addProjectSupplier(SscProjectCopyBusiReqBO busiReqBO) {
        SscProjectSupplierPO whereProjectSupplierPO = new SscProjectSupplierPO();
        whereProjectSupplierPO.setProjectId(busiReqBO.getOldProjectId());
        whereProjectSupplierPO.setInvitationSession("1");
        List<SscProjectSupplierPO> sscProjectSupplierPOs = this.sscProjectSupplierDAO.getList(whereProjectSupplierPO);
        if (!CollectionUtils.isEmpty(sscProjectSupplierPOs)) {
            ArrayList<SscProjectSupplierPO> intsertProjectSupplierPO = new ArrayList<SscProjectSupplierPO>();
            for (SscProjectSupplierPO po : sscProjectSupplierPOs) {
                SscProjectSupplierPO insertPO = new SscProjectSupplierPO();
                insertPO.setProjectSupplierId(Sequence.getInstance().nextId());
                insertPO.setPlanId(po.getPlanId());
                insertPO.setProjectId(busiReqBO.getNewProjectId());
                insertPO.setStageId(po.getStageId());
                insertPO.setSupplierId(po.getSupplierId());
                insertPO.setSupplierName(po.getSupplierName());
                insertPO.setInvitationId(busiReqBO.getOperId());
                insertPO.setInvitationName(busiReqBO.getOperName());
                insertPO.setInvitationTime(new Date());
                insertPO.setSupplierStatus("1");
                insertPO.setSupplierLinkMan(po.getSupplierLinkMan());
                insertPO.setSupplierLinkPhone(po.getSupplierLinkPhone());
                insertPO.setPayMode(po.getPayMode());
                insertPO.setTradeMode(po.getTradeMode());
                insertPO.setExpecSettleMethod(po.getExpecSettleMethod());
                insertPO.setExpecSettleDay(po.getExpecSettleDay());
                insertPO.setPrePay(po.getPrePay());
                insertPO.setPilPay(po.getPilPay());
                insertPO.setVerPay(po.getVerPay());
                insertPO.setTradeModeShow(po.getTradeModeShow());
                insertPO.setPayModeShow(po.getPayModeShow());
                insertPO.setSupplierExtField1(po.getSupplierExtField1());
                insertPO.setSupplierExtField2(po.getSupplierExtField2());
                insertPO.setSupplierExtField3(po.getSupplierExtField3());
                insertPO.setSupplierExtField4(po.getSupplierExtField4());
                insertPO.setSupplierExtField5(po.getSupplierExtField5());
                insertPO.setInvitationSession(po.getInvitationSession());
                insertPO.setIsNeedMargin(po.getIsNeedMargin());
                intsertProjectSupplierPO.add(insertPO);
            }
            int isInsert = this.sscProjectSupplierDAO.insertBatch(intsertProjectSupplierPO);
            if (isInsert != sscProjectSupplierPOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void addExt(Long projectId, Long oldProjectObjectId, String projectObjectType, Long newProjectObjectId) {
        SscProjectExtPO whereProjectExtPO = new SscProjectExtPO();
        whereProjectExtPO.setProjectObjectId(oldProjectObjectId);
        whereProjectExtPO.setProjectObjectType(projectObjectType);
        List<SscProjectExtPO> sscProjectExtPOs = this.sscProjectExtDAO.getList(whereProjectExtPO);
        if (!CollectionUtils.isEmpty(sscProjectExtPOs)) {
            for (SscProjectExtPO po : sscProjectExtPOs) {
                po.setProjectExtId(Sequence.getInstance().nextId());
                po.setProjectId(projectId);
                po.setProjectObjectId(newProjectObjectId);
            }
            int isInsert = this.sscProjectExtDAO.insertBatch(sscProjectExtPOs);
            if (isInsert != sscProjectExtPOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u6269\u5c55\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void addAttach(Long projectId, Long oldProjectObjectId, String projectObjectType, Long newProjectObjectId) {
        SscProjectAttachPO whereProjectAttacPO = new SscProjectAttachPO();
        whereProjectAttacPO.setProjectObjectId(oldProjectObjectId);
        whereProjectAttacPO.setProjectObjectType(projectObjectType);
        List<SscProjectAttachPO> sscProjectAttachPOs = this.sscProjectAttachDAO.getList(whereProjectAttacPO);
        if (!CollectionUtils.isEmpty(sscProjectAttachPOs)) {
            for (SscProjectAttachPO po : sscProjectAttachPOs) {
                po.setProjectAttachId(Sequence.getInstance().nextId());
                po.setProjectId(projectId);
                po.setProjectObjectId(newProjectObjectId);
            }
            int isInsert = this.sscProjectAttachDAO.insertBatch(sscProjectAttachPOs);
            if (isInsert != sscProjectAttachPOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9644\u4ef6\u8868\u5931\u8d25\uff01");
            }
        }
    }
}

