/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscSupplierAdviceNoteBO;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscProjectApprovalDAO;
import com.tydic.ssc.dao.SscProjectBidRoundDAO;
import com.tydic.ssc.dao.SscProjectTempResultDAO;
import com.tydic.ssc.dao.SscProjectTempResultDetailDAO;
import com.tydic.ssc.dao.SscSupplierAdviceNoteDAO;
import com.tydic.ssc.dao.po.SscProjectApprovalPO;
import com.tydic.ssc.dao.po.SscProjectBidRoundPO;
import com.tydic.ssc.dao.po.SscProjectTempResultDetailPO;
import com.tydic.ssc.dao.po.SscProjectTempResultPO;
import com.tydic.ssc.dao.po.SscSupplierAdviceNotePO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.busi.SscTempResultSubmitBusiService;
import com.tydic.ssc.service.busi.bo.SscTempResultSubmitBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscTempResultSubmitBusiRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscTempResultSubmitBusiServiceImpl
implements SscTempResultSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscTempResultSubmitBusiServiceImpl.class);
    @Autowired
    private SscProjectTempResultDAO sscProjectTempResultDAO;
    @Autowired
    private SscProjectApprovalDAO sscProjectApprovalDAO;
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private SscProjectBidRoundDAO sscProjectBidRoundDAO;
    @Autowired
    private SscSupplierAdviceNoteDAO sscSupplierAdviceNoteDAO;
    @Autowired
    private SscProjectTempResultDetailDAO sscProjectTempResultDetailDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscTempResultSubmitBusiRspBO dealTempResultSubmit(SscTempResultSubmitBusiReqBO busiReqBO) {
        SscTempResultSubmitBusiRspBO rsp = new SscTempResultSubmitBusiRspBO();
        SscProjectTempResultPO sscProjectTempResultPO = this.sscProjectTempResultDAO.selectByPrimaryKey(busiReqBO.getTempResultId());
        if (null == sscProjectTempResultPO) {
            throw new BusinessException("8888", "\u62df\u5b9a\u7ed3\u679c\u8868\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!"3".equals(sscProjectTempResultPO.getTempResultStatus())) {
            throw new BusinessException("8888", "\u53ea\u6709\u5f85\u6295\u7968\u72b6\u6001\u7684\u62df\u5b9a\u7ed3\u679c\u624d\u80fd\u63d0\u4ea4\u5ba1\u6838\uff01");
        }
        this.updateTempResultStatus(sscProjectTempResultPO, busiReqBO.getProcessKey());
        this.updateProjectStatus(sscProjectTempResultPO, busiReqBO.getStatusChangeOperCode());
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getProcessKey())) {
            Long projectAuditOrderId = Sequence.getInstance().nextId();
            Long auditOrderId = this.createApprovalOrder(busiReqBO, projectAuditOrderId);
            this.updateProjectApproal(busiReqBO, projectAuditOrderId, auditOrderId, sscProjectTempResultPO.getProjectId());
        }
        this.updateProjectBidRoundStatus(sscProjectTempResultPO);
        if (StringUtils.isBlank((CharSequence)busiReqBO.getProcessKey())) {
            List<SscSupplierAdviceNotePO> insertPOs = this.insertSupplierAdviceNote(busiReqBO.getTempResultId(), sscProjectTempResultPO.getProjectId(), busiReqBO);
            HashMap<Long, SscSupplierAdviceNoteBO> sscSupplierAdviceNoteBOMap = new HashMap<Long, SscSupplierAdviceNoteBO>();
            if (!CollectionUtils.isEmpty(insertPOs)) {
                for (SscSupplierAdviceNotePO po : insertPOs) {
                    SscSupplierAdviceNoteBO sscSupplierAdviceNoteBO = new SscSupplierAdviceNoteBO();
                    BeanUtils.copyProperties((Object)po, (Object)sscSupplierAdviceNoteBO);
                    sscSupplierAdviceNoteBOMap.put(po.getSupplierId(), sscSupplierAdviceNoteBO);
                }
            }
            rsp.setSscSupplierAdviceNoteBOMap(sscSupplierAdviceNoteBOMap);
        }
        rsp.setProjectId(sscProjectTempResultPO.getProjectId());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62df\u5b9a\u7ed3\u679c\u63d0\u4ea4\u5ba1\u6838\u6210\u529f\uff01");
        return rsp;
    }

    private List<SscSupplierAdviceNotePO> insertSupplierAdviceNote(Long tempResultId, Long projectId, SscTempResultSubmitBusiReqBO busiReqBO) {
        ArrayList<SscSupplierAdviceNotePO> insertPOs = new ArrayList<SscSupplierAdviceNotePO>();
        SscProjectTempResultDetailPO wherePO = new SscProjectTempResultDetailPO();
        wherePO.setTempResultId(tempResultId);
        List<SscProjectTempResultDetailPO> sscProjectTempResultDetailPOs = this.sscProjectTempResultDetailDAO.getList(wherePO);
        if (!CollectionUtils.isEmpty(sscProjectTempResultDetailPOs)) {
            HashMap<Long, String> supplierMap = new HashMap<Long, String>();
            for (SscProjectTempResultDetailPO sscProjectTempResultDetailPO : sscProjectTempResultDetailPOs) {
                supplierMap.put(sscProjectTempResultDetailPO.getSupplierId(), sscProjectTempResultDetailPO.getSupplierName());
            }
            Map<String, String> adviceNoteTemplateCodeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "ADVICE_NOTE_TEMPLATE_CODE");
            for (Long supplierId : supplierMap.keySet()) {
                SscSupplierAdviceNotePO sscSupplierAdviceNotePO = new SscSupplierAdviceNotePO();
                sscSupplierAdviceNotePO.setSupplierAdviceNoteId(Sequence.getInstance().nextId());
                sscSupplierAdviceNotePO.setProjectId(projectId);
                sscSupplierAdviceNotePO.setAdviceNoteTitle("\u4e2d\u6807\u901a\u77e5\u4e66");
                sscSupplierAdviceNotePO.setAdviceNoteType("1");
                sscSupplierAdviceNotePO.setAdviceNoteTemplateCode(adviceNoteTemplateCodeMap.get("1"));
                sscSupplierAdviceNotePO.setOperNo(busiReqBO.getOperId());
                sscSupplierAdviceNotePO.setOperName(busiReqBO.getOperName());
                sscSupplierAdviceNotePO.setOperTime(new Date());
                sscSupplierAdviceNotePO.setSupplierId(supplierId);
                sscSupplierAdviceNotePO.setSupplierName((String)supplierMap.get(supplierId));
                insertPOs.add(sscSupplierAdviceNotePO);
            }
            int n = this.sscSupplierAdviceNoteDAO.insertBatch(insertPOs);
            if (n != supplierMap.keySet().size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u901a\u77e5\u4e66\u8868\u5931\u8d25\uff01");
            }
        }
        return insertPOs;
    }

    private void updateProjectBidRoundStatus(SscProjectTempResultPO busiReqBO) {
        SscProjectBidRoundPO updatePO = new SscProjectBidRoundPO();
        updatePO.setProjectId(busiReqBO.getProjectId());
        updatePO.setPlanId(busiReqBO.getPlanId());
        updatePO.setStageId(busiReqBO.getStageId());
        updatePO.setScoreRound(busiReqBO.getScoreRound());
        updatePO.setBidStatus("6");
        int isUpdate = this.sscProjectBidRoundDAO.updateByCondition(updatePO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8bc4\u6807\u8f6e\u6b21\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateProjectApproal(SscTempResultSubmitBusiReqBO busiReqBO, Long projectAuditOrderId, Long auditOrderId, Long projectId) {
        SscProjectApprovalPO insertPO = new SscProjectApprovalPO();
        insertPO.setProjectApprovalId(Sequence.getInstance().nextId());
        insertPO.setProjectId(projectId);
        insertPO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_TEMP_RESULT_AUDIT);
        insertPO.setApprovalId(auditOrderId);
        insertPO.setToApprovalId(projectAuditOrderId);
        insertPO.setOperId(busiReqBO.getOperId());
        insertPO.setOperName(busiReqBO.getOperName());
        insertPO.setOperTime(new Date());
        int isInsert = this.sscProjectApprovalDAO.insert(insertPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u5ba1\u6279\u8868\u5931\u8d25\uff01");
        }
    }

    private Long createApprovalOrder(SscTempResultSubmitBusiReqBO busiReqBO, Long projectAuditOrderId) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(SscCommConstant.AuditObjType.PROJECT_TEMP_RESULT_AUDIT);
        approvalObjBO.setObjId(projectAuditOrderId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(SscCommConstant.AuditObjType.PROJECT_TEMP_RESULT_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(projectAuditOrderId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u9879\u76ee\u62df\u5b9a\u7ed3\u679c\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setProcDefKey(busiReqBO.getProcessKey());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getOperId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getOperName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        return (Long)uacNoTaskAuditCreateRspBO.getAuditOrderId().get(0);
    }

    private void updateProjectStatus(SscProjectTempResultPO sscProjectTempResultPO, String statusChangeOperCode) {
        SscDealStatusCirculationConfAtomReqBO sscDealStatusCirculationConfAtomReqBO = new SscDealStatusCirculationConfAtomReqBO();
        sscDealStatusCirculationConfAtomReqBO.setProjectId(sscProjectTempResultPO.getProjectId());
        sscDealStatusCirculationConfAtomReqBO.setPlanId(sscProjectTempResultPO.getPlanId());
        sscDealStatusCirculationConfAtomReqBO.setId(sscProjectTempResultPO.getProjectId());
        sscDealStatusCirculationConfAtomReqBO.setStatusChangeOperCode(statusChangeOperCode);
        SscDealStatusCirculationConfAtomRspBO sscDealStatusCirculationConfAtomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(sscDealStatusCirculationConfAtomReqBO);
        if (!"0000".equals(sscDealStatusCirculationConfAtomRspBO.getRespCode())) {
            throw new BusinessException(sscDealStatusCirculationConfAtomRspBO.getRespCode(), sscDealStatusCirculationConfAtomRspBO.getRespDesc());
        }
    }

    private void updateTempResultStatus(SscProjectTempResultPO sscProjectTempResultPO, String processKey) {
        SscProjectTempResultPO wherePO = new SscProjectTempResultPO();
        wherePO.setTempResultId(sscProjectTempResultPO.getTempResultId());
        if (StringUtils.isBlank((CharSequence)processKey)) {
            wherePO.setTempResultStatus("1");
        } else {
            wherePO.setTempResultStatus("0");
        }
        int isUpdate = this.sscProjectTempResultDAO.updateByPrimaryKeySelective(wherePO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u62df\u5b9a\u7ed3\u679c\u8868\u5931\u8d25\uff01");
        }
    }
}

