/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.common.SscProjectInfoBO;
import com.tydic.ssc.common.SscSupplierInfoBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQueryPriceComparisonItemHeaderBusiService;
import com.tydic.ssc.service.busi.bo.SscQueryPriceComparisonItemHeaderBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQueryPriceComparisonItemHeaderBusiRspBO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQueryPriceComparisonItemHeaderBusiServiceImpl
implements SscQueryPriceComparisonItemHeaderBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscSupplierQuotationDAO sscSupplierQuotationDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQueryPriceComparisonItemHeaderBusiRspBO queryPriceComparisonItemHeader(SscQueryPriceComparisonItemHeaderBusiReqBO reqBO) {
        List<SscSupplierInfoBO> list;
        SscProjectInfoBO sscProjectInfoBO = this.sscProjectDAO.selectProjectInfo(reqBO);
        if (StringUtils.isNotBlank((CharSequence)sscProjectInfoBO.getTradeMode())) {
            Map<String, String> tradeModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TRADE_MODE");
            sscProjectInfoBO.setTradeModeStr(tradeModeMap.get(sscProjectInfoBO.getTradeMode()));
        }
        if (sscProjectInfoBO.getProjectBudgetAmount() != null) {
            sscProjectInfoBO.setProjectBudgetAmount(sscProjectInfoBO.getProjectBudgetAmount().divide(new BigDecimal("10000"), 2, 1));
        }
        if (CollectionUtils.isNotEmpty(list = this.sscSupplierQuotationDAO.selectSupplierInfo(reqBO))) {
            for (SscSupplierInfoBO sscSupplierInfoBO : list) {
                if (!StringUtils.isNotBlank((CharSequence)sscSupplierInfoBO.getTradeMode())) continue;
                Map<String, String> tradeModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TRADE_MODE");
                sscSupplierInfoBO.setTradeModeStr(tradeModeMap.get(sscSupplierInfoBO.getTradeMode()));
            }
        }
        SscQueryPriceComparisonItemHeaderBusiRspBO rspBO = new SscQueryPriceComparisonItemHeaderBusiRspBO();
        rspBO.setSscProjectInfoBO(sscProjectInfoBO);
        rspBO.setSscSupplierInfoBOs(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6bd4\u4ef7\u660e\u7ec6\u8868\u5934\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

