/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.ssc.ability.SscTimingTaskAbilityService;
import com.tydic.ssc.base.bo.SscRspBaseBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_DEV", serviceInterface=SscTimingTaskAbilityService.class)
public class SscTimingTaskAbilityServiceImpl
implements SscTimingTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SscTimingTaskAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SscTimingTaskAbilityServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    @Autowired
    private SscProjectDAO sscProjectDAO;

    public SscRspBaseBO initProjectDate(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("-1");
        this.sscProjectDAO.deleteByProjectStatus(qryParam);
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u670d\u52a1\u7ed3\u675f=================");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u6e05\u9664\u6210\u529f");
        return rspBaseBO;
    }

    public SscRspBaseBO registering(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("11");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (CollectionUtils.isEmpty(qryResult) && (IS_INFO_ENABLED || IS_DEBUG_ENABLED)) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u5f85\u5f00\u6807\u7684\u9879\u76ee=================");
        }
        for (SscProjectPO po : qryResult) {
            int result = po.getBidOpenTime().compareTo(new Date());
            if (result != -1) continue;
            SscProjectPO updateParam = new SscProjectPO();
            updateParam.setProjectId(po.getProjectId());
            updateParam.setProjectStatus("5");
            this.sscProjectDAO.changeToBeOpened(updateParam);
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(11->5)");
        return rspBaseBO;
    }

    public SscRspBaseBO bidOpening(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("5");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (CollectionUtils.isEmpty(qryResult) && (IS_INFO_ENABLED || IS_DEBUG_ENABLED)) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u62a5\u540d\u4e2d\u7684\u9879\u76ee=================");
        }
        for (SscProjectPO po : qryResult) {
            int result = po.getBidEndTime().compareTo(new Date());
            if (result != -1) continue;
            SscProjectPO updateParam = new SscProjectPO();
            updateParam.setProjectId(po.getProjectId());
            updateParam.setProjectStatus("6");
            this.sscProjectDAO.changeToBeOpened(updateParam);
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(5->6)");
        return rspBaseBO;
    }

    public SscRspBaseBO examine(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("6");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (CollectionUtils.isEmpty(qryResult) && (IS_INFO_ENABLED || IS_DEBUG_ENABLED)) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u516c\u793a\u4e2d\u7684\u9879\u76ee=================");
        }
        for (SscProjectPO po : qryResult) {
            Integer bidPublicPeriod = po.getBidPublicPeriod();
            log.debug("\u6295\u6807\u622a\u81f3\u65f6\u95f4{}", (Object)po.getBidPublicPeriod().toString());
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(po.getBidEndTime());
            ((Calendar)calendar).add(5, bidPublicPeriod);
            Date showEndTime = calendar.getTime();
            log.debug("\u516c\u793a\u622a\u81f3\u65f6\u95f4{}", (Object)showEndTime.toString());
            int result = showEndTime.compareTo(new Date());
            if (result != -1) continue;
            SscProjectPO updateParam = new SscProjectPO();
            updateParam.setProjectId(po.getProjectId());
            updateParam.setProjectStatus("7");
            this.sscProjectDAO.changeToBeOpened(updateParam);
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(6->7)");
        return rspBaseBO;
    }
}

