/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectAttachBO;
import com.tydic.ssc.common.SscProjectDetailBO;
import com.tydic.ssc.common.SscProjectExtBO;
import com.tydic.ssc.common.SscProjectStageBO;
import com.tydic.ssc.common.SscProjectSupplierInfoBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectStageDAO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectStagePO;
import com.tydic.ssc.dao.po.SscSupplierStagePO;
import com.tydic.ssc.service.atom.SscOperProjectAttachAtomService;
import com.tydic.ssc.service.atom.SscOperProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscOperProjectAttachAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectAttachAtomRspBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscProjectAddBusiService;
import com.tydic.ssc.service.busi.bo.SscProjectAddBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscProjectAddBusiRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscProjectAddBusiServiceImpl
implements SscProjectAddBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectStageDAO sscProjectStageDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscOperProjectAttachAtomService sscOperProjectAttachAtomService;
    @Autowired
    private SscOperProjectExtAtomService sscOperProjectExtAtomService;

    @Override
    public SscProjectAddBusiRspBO dealSscProjectAdd(SscProjectAddBusiReqBO busiReqBO) {
        SscProjectAddBusiRspBO rsp = new SscProjectAddBusiRspBO();
        SscProjectPO checkExeistPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        if (null != checkExeistPO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee[" + busiReqBO.getProjectId() + "]\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff01");
        }
        SscProjectPO insertProjectPO = new SscProjectPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)insertProjectPO);
        insertProjectPO.setProjectProducerTime(new Date());
        int isInsert = this.sscProjectDAO.insert(insertProjectPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u8868\u5931\u8d25\uff01");
        }
        ArrayList<Long> stageIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(busiReqBO.getProjectStageBOs())) {
            for (SscProjectStageBO sscProjectStageBO : busiReqBO.getProjectStageBOs()) {
                stageIds.add(sscProjectStageBO.getStageId());
                SscProjectStagePO checkExeistStagePO = this.sscProjectStageDAO.selectByPrimaryKey(sscProjectStageBO.getStageId());
                if (null != checkExeistStagePO) {
                    throw new BusinessException("8888", "\u8be5\u9879\u76ee\u6807\u6bb5[" + sscProjectStageBO.getStageId() + "]\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff01");
                }
                SscProjectStagePO insertProjectStagePO = new SscProjectStagePO();
                BeanUtils.copyProperties((Object)sscProjectStageBO, (Object)insertProjectStagePO);
                insertProjectStagePO.setProjectId(busiReqBO.getProjectId());
                insertProjectStagePO.setPlanId(busiReqBO.getPlanId());
                int isInsert2 = this.sscProjectStageDAO.insert(insertProjectStagePO);
                if (isInsert2 < 1) {
                    throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u6807\u6bb5\u8868\u5931\u8d25\uff01");
                }
                if (!CollectionUtils.isEmpty((Collection)sscProjectStageBO.getSscProjectAttachBOs())) {
                    this.operProjectAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), sscProjectStageBO.getSscProjectAttachBOs(), "2", sscProjectStageBO.getStageId());
                }
                if (!CollectionUtils.isEmpty((Collection)sscProjectStageBO.getSscProjectExtBOs())) {
                    this.operProjectExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), sscProjectStageBO.getSscProjectExtBOs(), "2", sscProjectStageBO.getStageId());
                }
                if (CollectionUtils.isEmpty((Collection)sscProjectStageBO.getSscProjectDetailBOs())) continue;
                ArrayList<SscProjectDetailPO> sscProjectDetailPOs = new ArrayList<SscProjectDetailPO>();
                for (SscProjectDetailBO bo1 : sscProjectStageBO.getSscProjectDetailBOs()) {
                    SscProjectDetailPO sscProjectDetailPO = new SscProjectDetailPO();
                    BeanUtils.copyProperties((Object)bo1, (Object)sscProjectDetailPO);
                    sscProjectDetailPO.setProjectDetailId(Sequence.getInstance().nextId());
                    sscProjectDetailPO.setPlanId(busiReqBO.getPlanId());
                    sscProjectDetailPO.setProjectId(busiReqBO.getProjectId());
                    sscProjectDetailPO.setStageId(sscProjectStageBO.getStageId());
                    sscProjectDetailPO.setOperId(busiReqBO.getProjectProducerId());
                    sscProjectDetailPO.setOperName(busiReqBO.getProjectProducerName());
                    sscProjectDetailPO.setOperTime(new Date());
                    sscProjectDetailPOs.add(sscProjectDetailPO);
                    if (!CollectionUtils.isEmpty((Collection)bo1.getSscProjectAttachBOs())) {
                        this.operProjectAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo1.getSscProjectAttachBOs(), "8", sscProjectDetailPO.getProjectDetailId());
                    }
                    if (CollectionUtils.isEmpty((Collection)bo1.getSscProjectExtBOs())) continue;
                    this.operProjectExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo1.getSscProjectExtBOs(), "8", sscProjectDetailPO.getProjectDetailId());
                }
                int isInsert3 = this.sscProjectDetailDAO.insertBatch(sscProjectDetailPOs);
                if (isInsert3 >= 1) continue;
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u660e\u7ec6\u8868\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getProjectAttachBOs())) {
            this.operProjectAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), busiReqBO.getProjectAttachBOs(), "1", busiReqBO.getProjectId());
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectExtBOs())) {
            this.operProjectExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), busiReqBO.getSscProjectExtBOs(), "1", busiReqBO.getProjectId());
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectSupplierInfoBOs())) {
            for (SscProjectSupplierInfoBO sscProjectSupplierInfoBO : busiReqBO.getSscProjectSupplierInfoBOs()) {
                if (null == sscProjectSupplierInfoBO.getStageId()) {
                    this.insertSupplierStage(busiReqBO.getPlanId(), busiReqBO.getProjectId(), sscProjectSupplierInfoBO, stageIds, busiReqBO.getProjectProducerId(), busiReqBO.getProjectProducerName());
                    continue;
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(sscProjectSupplierInfoBO.getStageId());
                this.insertSupplierStage(busiReqBO.getPlanId(), busiReqBO.getProjectId(), sscProjectSupplierInfoBO, ids, busiReqBO.getProjectProducerId(), busiReqBO.getProjectProducerName());
            }
        }
        rsp.setProjectId(busiReqBO.getProjectId());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62db\u6807\u9879\u76ee\u65b0\u589e\u6210\u529f\uff01");
        return rsp;
    }

    private void insertSupplierStage(Long planId, Long projectId, SscProjectSupplierInfoBO bo, List<Long> stageIds, Long operId, String operName) {
        ArrayList<SscSupplierStagePO> list = new ArrayList<SscSupplierStagePO>();
        for (Long stageId : stageIds) {
            SscSupplierStagePO sscSupplierStagePO = new SscSupplierStagePO();
            sscSupplierStagePO.setSupplierStageId(Sequence.getInstance().nextId());
            sscSupplierStagePO.setPlanId(planId);
            sscSupplierStagePO.setProjectId(projectId);
            sscSupplierStagePO.setStageId(stageId);
            sscSupplierStagePO.setSupplierId(bo.getSupplierId());
            sscSupplierStagePO.setSupplierName(bo.getSupplierName());
            sscSupplierStagePO.setStageInvitationId(operId);
            sscSupplierStagePO.setStageInvitationName(operName);
            sscSupplierStagePO.setStageInvitationTime(new Date());
            list.add(sscSupplierStagePO);
        }
        ((SscSupplierStagePO)list.get(0)).setMainDataFlag("1");
        int isInsert = this.sscSupplierStageDAO.insertBatch(list);
        if (isInsert != stageIds.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u6807\u6bb5\u8868\u5931\u8d25\uff01");
        }
    }

    private void operProjectExt(Long projectId, Long planId, List<SscProjectExtBO> sscProjectExtBOs, String projectObjectType, Long projectObjectId) {
        for (SscProjectExtBO bo : sscProjectExtBOs) {
            bo.setProjectId(projectId);
            bo.setPlanId(planId);
            bo.setProjectObjectId(projectObjectId);
            bo.setProjectObjectType(projectObjectType);
        }
        SscOperProjectExtAtomReqBO sscOperProjectExtAtomReqBO = new SscOperProjectExtAtomReqBO();
        sscOperProjectExtAtomReqBO.setOperType("1");
        sscOperProjectExtAtomReqBO.setProjectObjectId(projectObjectId);
        sscOperProjectExtAtomReqBO.setProjectObjectType(projectObjectType);
        sscOperProjectExtAtomReqBO.setSscProjectExtBOs(sscProjectExtBOs);
        SscOperProjectExtAtomRspBO sscOperProjectExtAtomRspBO = this.sscOperProjectExtAtomService.operProjectExt(sscOperProjectExtAtomReqBO);
        if (!"0000".equals(sscOperProjectExtAtomRspBO.getRespCode())) {
            throw new BusinessException(sscOperProjectExtAtomRspBO.getRespCode(), sscOperProjectExtAtomRspBO.getRespDesc());
        }
    }

    private void operProjectAttach(Long projectId, Long planId, List<SscProjectAttachBO> projectAttachBOs, String projectObjectType, Long projectObjectId) {
        for (SscProjectAttachBO bo : projectAttachBOs) {
            bo.setProjectId(projectId);
            bo.setPlanId(planId);
            bo.setProjectObjectId(projectObjectId);
            bo.setProjectObjectType(projectObjectType);
        }
        SscOperProjectAttachAtomReqBO sscOperProjectAttachAtomReqBO = new SscOperProjectAttachAtomReqBO();
        sscOperProjectAttachAtomReqBO.setOperType("1");
        sscOperProjectAttachAtomReqBO.setProjectObjectId(projectObjectId);
        sscOperProjectAttachAtomReqBO.setProjectObjectType(projectObjectType);
        sscOperProjectAttachAtomReqBO.setSscProjectAttachBOs(projectAttachBOs);
        SscOperProjectAttachAtomRspBO sscOperProjectAttachAtomRspBO = this.sscOperProjectAttachAtomService.operProjectAttach(sscOperProjectAttachAtomReqBO);
        if (!"0000".equals(sscOperProjectAttachAtomRspBO.getRespCode())) {
            throw new BusinessException(sscOperProjectAttachAtomRspBO.getRespCode(), sscOperProjectAttachAtomRspBO.getRespDesc());
        }
    }
}

