/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectAndSupplierStageBO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQrySupplierStageListBusiService;
import com.tydic.ssc.service.busi.bo.SscQrySupplierStageListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQrySupplierStageListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQrySupplierStageListBusiServiceImpl
implements SscQrySupplierStageListBusiService {
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQrySupplierStageListBusiRspBO qrySupplierStageList(SscQrySupplierStageListBusiReqBO reqBO) {
        SscQrySupplierStageListBusiRspBO rspBO = new SscQrySupplierStageListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectAndSupplierStageBO> sscProjectAndSupplierStageBOS = this.sscSupplierStageDAO.getSupplierStageList(reqBO, (Page<SscProjectAndSupplierStageBO>)page);
        if (CollectionUtils.isEmpty(sscProjectAndSupplierStageBOS)) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u6807\u6bb5\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectIds = sscProjectAndSupplierStageBOS.stream().map(SscProjectAndSupplierStageBO::getProjectId).collect(Collectors.toList());
            List<Long> stageIds = sscProjectAndSupplierStageBOS.stream().map(SscProjectAndSupplierStageBO::getStageId).collect(Collectors.toList());
            List<Long> supplierStageIds = sscProjectAndSupplierStageBOS.stream().map(SscProjectAndSupplierStageBO::getSupplierStageId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            SscQryProjectExtAtomReqBO sscQryProjectStageExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectStageExtAtomReqBO.setProjectObjectType("2");
            sscQryProjectStageExtAtomReqBO.setProjectObjectIds(stageIds);
            SscQryProjectExtAtomRspBO sscQryProjectStageExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectStageExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectStageExtMap = sscQryProjectStageExtAtomRspBO.getSscProjectExtMap();
            SscQryProjectExtAtomReqBO sscQryProjectSupStageExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectSupStageExtAtomReqBO.setProjectObjectType("6");
            sscQryProjectSupStageExtAtomReqBO.setProjectObjectIds(supplierStageIds);
            SscQryProjectExtAtomRspBO sscQryProjectSupStageExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectSupStageExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectSupStageExtMap = sscQryProjectSupStageExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectSupStageExtMap) {
                for (SscProjectAndSupplierStageBO supplierStageBO : sscProjectAndSupplierStageBOS) {
                    supplierStageBO.setStageSupplierExtMap(sscProjectSupStageExtMap.get(supplierStageBO.getSupplierStageId()));
                }
            }
            if (null != sscProjectStageExtMap) {
                for (SscProjectAndSupplierStageBO supplierStageBO : sscProjectAndSupplierStageBOS) {
                    supplierStageBO.setProjectStageExtMap(sscProjectStageExtMap.get(supplierStageBO.getStageId()));
                }
            }
            if (null != sscProjectExtMap) {
                for (SscProjectAndSupplierStageBO supplierStageBO : sscProjectAndSupplierStageBOS) {
                    supplierStageBO.setSscProjectExtMap(sscProjectSupStageExtMap.get(supplierStageBO.getProjectId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscProjectAndSupplierStageBOS);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscProjectAndSupplierStageBOS);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u6807\u6bb5\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscProjectAndSupplierStageBO> supplierStageBOS) {
        for (SscProjectAndSupplierStageBO supplierStageBO : supplierStageBOS) {
            Map<String, String> purchaseCategoryMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_CATEGORY");
            Map<String, String> projectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_STATUS");
            Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
            Map<String, String> quotationModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUOTATION_MODE");
            Map<String, String> commonStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
            Map<String, String> supplierStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "CLEAR_STATUS");
            Map<String, String> stageMarginStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "STAGE_MARGIN_STATUS");
            if (StringUtils.isNotBlank((CharSequence)supplierStageBO.getPurchaseMode())) {
                supplierStageBO.setPurchaseModeStr(purchaseCategoryMap.get(supplierStageBO.getPurchaseMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierStageBO.getProjectStatus())) {
                supplierStageBO.setProjectStatusStr(projectStatusMap.get(supplierStageBO.getProjectStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierStageBO.getTenderMode())) {
                supplierStageBO.setTenderModeStr(tenderModeMap.get(supplierStageBO.getTenderMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierStageBO.getQuotationMode())) {
                supplierStageBO.setQuotationModeStr(quotationModeMap.get(supplierStageBO.getQuotationMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierStageBO.getIsNeedMargin())) {
                supplierStageBO.setIsNeedMarginStr(commonStatusMap.get(supplierStageBO.getIsNeedMargin()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierStageBO.getBudgetPublic())) {
                supplierStageBO.setBudgetPublicStr(commonStatusMap.get(supplierStageBO.getBudgetPublic()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierStageBO.getStageSupplierStatus())) {
                supplierStageBO.setStageSupplierStatusStr(supplierStatusMap.get(supplierStageBO.getStageSupplierStatus()));
            }
            if (!StringUtils.isNotBlank((CharSequence)supplierStageBO.getStageMarginStatus())) continue;
            supplierStageBO.setStageMarginStatusStr(stageMarginStatusMap.get(supplierStageBO.getStageMarginStatus()));
        }
    }
}

