/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscProfessorChngDAO;
import com.tydic.ssc.dao.SscProfessorDAO;
import com.tydic.ssc.dao.po.SscProfessorPO;
import com.tydic.ssc.service.busi.SscCirculationInfoAddBusiService;
import com.tydic.ssc.service.busi.SscProfessorUpdateStatusApprovalBusiService;
import com.tydic.ssc.service.busi.bo.SscCirculationInfoAddBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscCirculationInfoAddBusiRspBO;
import com.tydic.ssc.service.busi.bo.SscProfessorApprovalBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscProfessorApprovalBusiRspBO;
import com.tydic.ssc.service.busi.bo.SscUpdateProfessorBusiReqBO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscProfessorUpdateStatusApprovalBusiServiceImpl
implements SscProfessorUpdateStatusApprovalBusiService {
    @Autowired
    private SscProfessorDAO sscProfessorDAO;
    @Autowired
    private SscProfessorChngDAO sscProfessorChngDAO;
    @Autowired
    private SscCirculationInfoAddBusiService sscCirculationInfoAddBusiService;

    @Override
    public SscProfessorApprovalBusiRspBO professorUpdateStatusApproval(SscProfessorApprovalBusiReqBO reqBO) {
        SscProfessorApprovalBusiRspBO rspBO = new SscProfessorApprovalBusiRspBO();
        SscProfessorPO auditParam = new SscProfessorPO();
        auditParam.setProfessorIds(reqBO.getProfessorIds());
        if (reqBO.getAuditType().equals(2)) {
            auditParam.setObjType(SscCommConstant.AuditObjType.PROFESSOR_FREEZE_AUDIT);
        }
        if (reqBO.getAuditType().equals(3)) {
            auditParam.setObjType(SscCommConstant.AuditObjType.PROFESSOR_THAW_AUDIT);
        }
        List<SscProfessorPO> sscProfessorPOS = this.sscProfessorChngDAO.getListTask(auditParam);
        this.checkSscProfessorPOS(sscProfessorPOS, reqBO);
        this.updateProfessorInfo(sscProfessorPOS, reqBO);
        this.addCirculationInfo(sscProfessorPOS, reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4e13\u5bb6\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void checkSscProfessorPOS(List<SscProfessorPO> sscProfessorPOS, SscProfessorApprovalBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(sscProfessorPOS)) {
            throw new BusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        sscProfessorPOS.stream().forEach(po -> {
            if (reqBO.getAuditType().equals(2) && !po.getProfessorStatus().equals("6")) {
                throw new BusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u51bb\u7ed3\u5ba1\u6838\u4e2d\u624d\u80fd\u8fdb\u884c\u5ba1\u6838");
            }
            if (reqBO.getAuditType().equals(3) && !po.getProfessorStatus().equals("7")) {
                throw new BusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u89e3\u51bb\u5ba1\u6838\u4e2d\u624d\u80fd\u8fdb\u884c\u5ba1\u6838");
            }
        });
    }

    private void updateProfessorInfo(List<SscProfessorPO> sscProfessorPOS, SscProfessorApprovalBusiReqBO reqBO) {
        if (reqBO.getAuditType().equals(2)) {
            for (SscProfessorPO po : sscProfessorPOS) {
                int updateChngResult;
                SscUpdateProfessorBusiReqBO updateParam = new SscUpdateProfessorBusiReqBO();
                BeanUtils.copyProperties((Object)po, (Object)((Object)updateParam));
                updateParam.setUpdateId(reqBO.getMemIdIn());
                updateParam.setUpdateName(reqBO.getName());
                updateParam.setUpdateTime(new Date());
                if (reqBO.getAuditResult().equals(0)) {
                    updateParam.setProfessorStatus("5");
                }
                if (reqBO.getAuditResult().equals(1)) {
                    updateParam.setProfessorStatus("3");
                }
                if ((updateChngResult = this.sscProfessorChngDAO.updateByCondition(updateParam)) < 1) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e13\u5bb6\u4fe1\u606f\u4fee\u6539\u8868\u5931\u8d25");
                }
                int updateResult = this.sscProfessorDAO.updateByCondition(updateParam);
                if (updateResult >= 1) continue;
                throw new BusinessException("8888", "\u66f4\u65b0\u4e13\u5bb6\u4fe1\u606f\u8868\u5931\u8d25");
            }
        } else {
            for (SscProfessorPO po : sscProfessorPOS) {
                int updateChngResult;
                SscUpdateProfessorBusiReqBO updateParam = new SscUpdateProfessorBusiReqBO();
                BeanUtils.copyProperties((Object)po, (Object)((Object)updateParam));
                updateParam.setUpdateId(reqBO.getMemIdIn());
                updateParam.setUpdateName(reqBO.getName());
                updateParam.setUpdateTime(new Date());
                if (reqBO.getAuditResult().equals(0)) {
                    updateParam.setProfessorStatus("3");
                }
                if (reqBO.getAuditResult().equals(1)) {
                    updateParam.setProfessorStatus("5");
                }
                if ((updateChngResult = this.sscProfessorChngDAO.updateByCondition(updateParam)) < 1) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e13\u5bb6\u4fe1\u606f\u4fee\u6539\u8868\u5931\u8d25");
                }
                int updateResult = this.sscProfessorDAO.updateByCondition(updateParam);
                if (updateResult >= 1) continue;
                throw new BusinessException("8888", "\u66f4\u65b0\u4e13\u5bb6\u4fe1\u606f\u8868\u5931\u8d25");
            }
        }
    }

    private void addCirculationInfo(List<SscProfessorPO> sscProfessorPOS, SscProfessorApprovalBusiReqBO reqBO) {
        for (SscProfessorPO po : sscProfessorPOS) {
            SscCirculationInfoAddBusiReqBO circulationInfoAddBusiReqBO = new SscCirculationInfoAddBusiReqBO();
            circulationInfoAddBusiReqBO.setRelationType(2);
            circulationInfoAddBusiReqBO.setRelationId(po.getProfessorId());
            circulationInfoAddBusiReqBO.setOperLink("\u5ba1\u6838\u4e13\u5bb6\u4fe1\u606f");
            circulationInfoAddBusiReqBO.setOperAction("\u5ba1\u6838");
            circulationInfoAddBusiReqBO.setCreateNo(reqBO.getMemIdIn());
            circulationInfoAddBusiReqBO.setCreateTime(new Date());
            circulationInfoAddBusiReqBO.setAuditStatus(reqBO.getAuditResult());
            circulationInfoAddBusiReqBO.setIsDel(0);
            circulationInfoAddBusiReqBO.setUnitId(reqBO.getCompanyId());
            circulationInfoAddBusiReqBO.setUnitName(reqBO.getCompanyName());
            SscCirculationInfoAddBusiRspBO sscCirculationInfoAddBusiRspBO = this.sscCirculationInfoAddBusiService.addCirculationInfo(circulationInfoAddBusiReqBO);
            if (sscCirculationInfoAddBusiRspBO.getRespCode().equals("0000")) continue;
            throw new BusinessException("8888", "\u4e13\u5bb6\u4fe1\u606f\u5ba1\u6838\u6d41\u8f6c\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
    }
}

