/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.ssc.ability.SscTimingTaskAbilityService;
import com.tydic.ssc.ability.bidding.SscQryProjectSupplierQuotationScoreListAbilityService;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.base.bo.SscRspBaseBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectStageDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectStagePO;
import com.tydic.ssc.dao.po.SscSupplierQuotationPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST", serviceInterface=SscTimingTaskAbilityService.class)
public class SscTimingTaskAbilityServiceImpl
implements SscTimingTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SscTimingTaskAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SscTimingTaskAbilityServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscQryProjectSupplierQuotationScoreListAbilityService sscQryProjectSupplierQuotationScoreListAbilityService;
    @Autowired
    private SscSupplierQuotationDAO sscSupplierQuotationDAO;
    @Autowired
    private SscProjectStageDAO sscProjectStageDAO;

    public SscRspBaseBO initProjectDate(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("-1");
        this.sscProjectDAO.deleteByProjectStatus(qryParam);
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u670d\u52a1\u7ed3\u675f=================");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u6e05\u9664\u6210\u529f");
        return rspBaseBO;
    }

    public SscRspBaseBO registering(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("11");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (!CollectionUtils.isEmpty(qryResult)) {
            for (SscProjectPO po : qryResult) {
                int result = po.getBidOpenTime().compareTo(new Date());
                if (result != -1) continue;
                SscProjectPO updateParam = new SscProjectPO();
                updateParam.setProjectId(po.getProjectId());
                updateParam.setProjectStatus("5");
                this.sscProjectDAO.changeToBeOpened(updateParam);
            }
        } else if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u5f85\u5f00\u6807\u7684\u9879\u76ee=================");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(11->5)");
        return rspBaseBO;
    }

    public SscRspBaseBO bidOpening(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("5");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (!CollectionUtils.isEmpty(qryResult)) {
            for (SscProjectPO po : qryResult) {
                int result;
                if (po.getBidEndTime() == null || (result = po.getBidEndTime().compareTo(new Date())) != -1) continue;
                SscProjectPO updateParam = new SscProjectPO();
                updateParam.setProjectId(po.getProjectId());
                updateParam.setProjectStatus("11");
                this.sscProjectDAO.changeToBeOpened(updateParam);
                SscProjectStagePO qryStageList = new SscProjectStagePO();
                qryStageList.setProjectId(po.getProjectId());
                List<Long> keyBy = this.sscProjectStageDAO.getKeyBy(qryStageList);
                if (CollectionUtils.isEmpty(keyBy)) continue;
                for (Long stageId : keyBy) {
                    SscSupplierQuotationPO qrySupplier = new SscSupplierQuotationPO();
                    qrySupplier.setProjectId(po.getProjectId());
                    qrySupplier.setStageId(stageId);
                    List<SscSupplierQuotationPO> list = this.sscSupplierQuotationDAO.getList(qrySupplier);
                    if (CollectionUtils.isEmpty(list) || list.size() > 2) continue;
                    for (SscSupplierQuotationPO ssqpo : list) {
                        SscSupplierQuotationPO updateParam1 = new SscSupplierQuotationPO();
                        updateParam1.setWinBidStatus("2");
                        updateParam1.setQuotationId(ssqpo.getQuotationId());
                        this.sscSupplierQuotationDAO.updateByPrimaryKeySelective(updateParam1);
                    }
                }
            }
        } else if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u62a5\u540d\u4e2d\u7684\u9879\u76ee=================");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(5->11)");
        return rspBaseBO;
    }

    public SscRspBaseBO loseBid(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("11");
        qryParam.setPurchaseMode("1");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (!CollectionUtils.isEmpty(qryResult)) {
            for (SscProjectPO po : qryResult) {
                SscProjectStagePO qryStageList = new SscProjectStagePO();
                qryStageList.setProjectId(po.getProjectId());
                List<Long> keyBy = this.sscProjectStageDAO.getKeyBy(qryStageList);
                if (CollectionUtils.isEmpty(keyBy)) continue;
                for (Long stageId : keyBy) {
                    SscSupplierQuotationPO qrySupplier = new SscSupplierQuotationPO();
                    qrySupplier.setProjectId(po.getProjectId());
                    qrySupplier.setStageId(stageId);
                    List<SscSupplierQuotationPO> list = this.sscSupplierQuotationDAO.getList(qrySupplier);
                    if (CollectionUtils.isEmpty(list) || list.size() > 2) continue;
                    for (SscSupplierQuotationPO ssqpo : list) {
                        SscSupplierQuotationPO updateParam = new SscSupplierQuotationPO();
                        updateParam.setWinBidStatus("2");
                        updateParam.setQuotationId(ssqpo.getQuotationId());
                        this.sscSupplierQuotationDAO.updateByPrimaryKeySelective(updateParam);
                    }
                }
            }
        } else if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u5f85\u5f00\u6807\u7684\u9879\u76ee=================");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u62a5\u4ef7\u4e0d\u8db3\u4e09\u5bb6\u81ea\u52a8\u6d41\u6807\u6210\u529f");
        return rspBaseBO;
    }

    public SscRspBaseBO examine(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("6");
        qryParam.setPurchaseMode("1");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (!CollectionUtils.isEmpty(qryResult)) {
            for (SscProjectPO po : qryResult) {
                if (po.getBidPublicPeriod() != null) {
                    Integer bidPublicPeriod = po.getBidPublicPeriod();
                    log.debug("\u516c\u793a\u65f6\u957f{}", (Object)po.getBidPublicPeriod().toString());
                    Date auditEndTime = DateUtils.strToDateLong((String)po.getProjectExtField7());
                    if (auditEndTime == null) continue;
                    log.debug("\u5ba1\u6838\u7ed3\u675f\u65f6\u95f4{}", (Object)auditEndTime.toString());
                    Date showEndTime = DateUtils.getDate((Date)auditEndTime, (Integer)bidPublicPeriod);
                    log.debug("\u516c\u793a\u622a\u81f3\u65f6\u95f4{}", (Object)showEndTime.toString());
                    int result = showEndTime.compareTo(new Date());
                    if (result != -1) continue;
                    if (!StringUtils.isEmpty((Object)po.getProjectExtField6())) {
                        SscProjectPO updateParam;
                        if (po.getProjectExtField6().equals("1")) {
                            updateParam = new SscProjectPO();
                            updateParam.setProjectId(po.getProjectId());
                            updateParam.setProjectStatus("10");
                            this.sscProjectDAO.changeToBeOpened(updateParam);
                            log.debug("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(6->10)");
                            continue;
                        }
                        if (po.getProjectExtField6().equals("2")) {
                            updateParam = new SscProjectPO();
                            updateParam.setProjectId(po.getProjectId());
                            updateParam.setProjectStatus("16");
                            this.sscProjectDAO.changeToBeOpened(updateParam);
                            log.debug("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(6->16)");
                            continue;
                        }
                        throw new BusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e0d\u5408\u6cd5\uff01");
                    }
                    throw new BusinessException("8888", "\u5ba1\u6838\u7ed3\u679c\u4e3a\u7a7a");
                }
                throw new BusinessException("8888", "\u516c\u793a\u65f6\u957f\u4e3a\u7a7a\uff01");
            }
        } else if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u516c\u793a\u4e2d\u7684\u9879\u76ee=================");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f");
        return rspBaseBO;
    }

    public SscRspBaseBO pendingTender(String currentShardValue) {
        SscRspBaseBO rspBaseBO = new SscRspBaseBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectStatus("13");
        List<SscProjectPO> qryResult = this.sscProjectDAO.getList(qryParam);
        if (!CollectionUtils.isEmpty(qryResult)) {
            for (SscProjectPO po : qryResult) {
                SscSupplierQuotationPO qrySupplier = new SscSupplierQuotationPO();
                qrySupplier.setProjectId(po.getProjectId());
                qrySupplier.setScoreStatus("1");
                qrySupplier.setWinBidStatus("1");
                List<SscSupplierQuotationPO> list = this.sscSupplierQuotationDAO.getList(qrySupplier);
                if (!CollectionUtils.isEmpty(list)) continue;
                SscProjectPO updateParam = new SscProjectPO();
                updateParam.setProjectId(po.getProjectId());
                updateParam.setProjectStatus("15");
                this.sscProjectDAO.changeToBeOpened(updateParam);
            }
        } else if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u5f53\u524d\u6ca1\u6709\u5f85\u8bc4\u6807\u7684\u9879\u76ee=================");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f(13->15)");
        return rspBaseBO;
    }
}

