/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectExtBO;
import com.tydic.ssc.common.SscSupplierStageBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectStageDAO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectStagePO;
import com.tydic.ssc.dao.po.SscSupplierStagePO;
import com.tydic.ssc.service.atom.SscOperProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscDealProjectForStageInfoBusiService;
import com.tydic.ssc.service.busi.bo.SscDealProjectForStageInfoBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscDealProjectForStageInfoBusiRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscDealProjectForStageInfoBusiServiceImpl
implements SscDealProjectForStageInfoBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectStageDAO sscProjectStageDAO;
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscOperProjectExtAtomService sscOperProjectExtAtomService;

    @Override
    public SscDealProjectForStageInfoBusiRspBO dealProjectForStageInfo(SscDealProjectForStageInfoBusiReqBO busiReqBO) {
        SscDealProjectForStageInfoBusiRspBO rsp = new SscDealProjectForStageInfoBusiRspBO();
        SscProjectPO checkExeistPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        if (null == checkExeistPO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee[" + busiReqBO.getProjectId() + "]\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        SscProjectPO updateProjectPO = new SscProjectPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)updateProjectPO);
        updateProjectPO.setProjectUpdateTime(new Date());
        int isUpdate = this.sscProjectDAO.updateByPrimaryKeySelective(updateProjectPO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getDeleteSupplierStageBOs())) {
            for (SscSupplierStageBO bo : busiReqBO.getDeleteSupplierStageBOs()) {
                SscSupplierStagePO deleteSscSupplierStagePO = new SscSupplierStagePO();
                deleteSscSupplierStagePO.setProjectId(busiReqBO.getProjectId());
                deleteSscSupplierStagePO.setPlanId(busiReqBO.getPlanId());
                deleteSscSupplierStagePO.setStageId(bo.getStageId());
                deleteSscSupplierStagePO.setSupplierId(bo.getSupplierId());
                List<SscSupplierStagePO> deleteSscSupplierStagePOs = this.sscSupplierStageDAO.getList(deleteSscSupplierStagePO);
                if (CollectionUtils.isEmpty(deleteSscSupplierStagePOs)) continue;
                this.sscSupplierStageDAO.deleteBy(deleteSscSupplierStagePO);
                for (SscSupplierStagePO po : deleteSscSupplierStagePOs) {
                    this.operProjectExt("2", busiReqBO.getProjectId(), busiReqBO.getPlanId(), null, "6", po.getSupplierStageId());
                }
            }
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getAddSupplierStageBOs())) {
            SscProjectStagePO whereProjectStagePO = new SscProjectStagePO();
            whereProjectStagePO.setProjectId(busiReqBO.getProjectId());
            whereProjectStagePO.setPlanId(busiReqBO.getPlanId());
            List<Long> stageIds = this.sscProjectStageDAO.getKeyBy(whereProjectStagePO);
            for (SscSupplierStageBO bo : busiReqBO.getAddSupplierStageBOs()) {
                if (null == bo.getStageId()) {
                    if (CollectionUtils.isEmpty(stageIds)) continue;
                    this.insertSupplierStage(busiReqBO.getPlanId(), busiReqBO.getProjectId(), bo, stageIds, busiReqBO.getProjectUpdateId(), busiReqBO.getProjectUpdateName(), true);
                    continue;
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(bo.getStageId());
                this.insertSupplierStage(busiReqBO.getPlanId(), busiReqBO.getProjectId(), bo, ids, busiReqBO.getProjectUpdateId(), busiReqBO.getProjectUpdateName(), false);
            }
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectExtBOs())) {
            this.operProjectExt("2", busiReqBO.getProjectId(), busiReqBO.getPlanId(), busiReqBO.getSscProjectExtBOs(), "1", busiReqBO.getProjectId());
        }
        return rsp;
    }

    private void insertSupplierStage(Long planId, Long projectId, SscSupplierStageBO bo, List<Long> stageIds, Long operId, String operName, boolean addMainDataFlag) {
        int isInsert;
        ArrayList<SscSupplierStagePO> list = new ArrayList<SscSupplierStagePO>();
        for (Long stageId : stageIds) {
            SscSupplierStagePO sscSupplierStagePO = new SscSupplierStagePO();
            BeanUtils.copyProperties((Object)bo, (Object)sscSupplierStagePO);
            sscSupplierStagePO.setSupplierStageId(Sequence.getInstance().nextId());
            sscSupplierStagePO.setPlanId(planId);
            sscSupplierStagePO.setProjectId(projectId);
            sscSupplierStagePO.setStageId(stageId);
            sscSupplierStagePO.setSupplierId(bo.getSupplierId());
            sscSupplierStagePO.setSupplierName(bo.getSupplierName());
            sscSupplierStagePO.setStageInvitationId(operId);
            sscSupplierStagePO.setStageInvitationName(operName);
            sscSupplierStagePO.setStageInvitationTime(new Date());
            list.add(sscSupplierStagePO);
        }
        if (addMainDataFlag) {
            ((SscSupplierStagePO)list.get(0)).setMainDataFlag("1");
        }
        if ((isInsert = this.sscSupplierStageDAO.insertBatch(list)) != stageIds.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u6807\u6bb5\u8868\u5931\u8d25\uff01");
        }
    }

    private void operProjectExt(String projectOperType, Long projectId, Long planId, List<SscProjectExtBO> sscProjectExtBOs, String projectObjectType, Long projectObjectId) {
        if (!CollectionUtils.isEmpty(sscProjectExtBOs)) {
            for (SscProjectExtBO bo : sscProjectExtBOs) {
                bo.setProjectId(projectId);
                bo.setPlanId(planId);
                bo.setProjectObjectId(projectObjectId);
                bo.setProjectObjectType(projectObjectType);
            }
        }
        SscOperProjectExtAtomReqBO sscOperProjectExtAtomReqBO = new SscOperProjectExtAtomReqBO();
        sscOperProjectExtAtomReqBO.setOperType(projectOperType);
        sscOperProjectExtAtomReqBO.setProjectObjectId(projectObjectId);
        sscOperProjectExtAtomReqBO.setProjectObjectType(projectObjectType);
        sscOperProjectExtAtomReqBO.setSscProjectExtBOs(sscProjectExtBOs);
        SscOperProjectExtAtomRspBO sscOperProjectExtAtomRspBO = this.sscOperProjectExtAtomService.operProjectExt(sscOperProjectExtAtomReqBO);
        if (!"0000".equals(sscOperProjectExtAtomRspBO.getRespCode())) {
            throw new BusinessException(sscOperProjectExtAtomRspBO.getRespCode(), sscOperProjectExtAtomRspBO.getRespDesc());
        }
    }
}

