/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.common.SupScaleTotalBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryScaleTotalBusiService;
import com.tydic.ssc.service.busi.bo.SscQryScaleTotalBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryScaleTotalBusiRspBO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQryScaleTotalBusiServiceImpl
implements SscQryScaleTotalBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryScaleTotalBusiRspBO qryScaleTotal(SscQryScaleTotalBusiReqBO reqBO) {
        List<SupScaleTotalBO> list;
        SscQryScaleTotalBusiRspBO rspBO = this.sscProjectDAO.selectScaleTotal(reqBO);
        if (StringUtils.isNotBlank((CharSequence)rspBO.getTradeMode())) {
            Map<String, String> tradeModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TRADE_MODE");
            rspBO.setTradeModeStr(tradeModeMap.get(rspBO.getTradeMode()));
        }
        if (CollectionUtils.isNotEmpty(list = this.sscProjectSupplierDAO.selectScaleTotalMoney(reqBO))) {
            for (SupScaleTotalBO bo : list) {
                if (StringUtils.isNotBlank((CharSequence)bo.getTradeMode())) {
                    Map<String, String> tradeModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TRADE_MODE");
                    bo.setTradeModeStr(tradeModeMap.get(bo.getTradeMode()));
                }
                if (rspBO.getTempResultAmount() == null) {
                    rspBO.setTempResultAmount(new BigDecimal(0));
                    continue;
                }
                rspBO.setTempResultAmount(rspBO.getTempResultAmount().add(bo.getTempResultAmount()));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5b9a\u6807\u5408\u8ba1\u67e5\u8be2\u6210\u529f");
        rspBO.setSscSupScaleTotalBOs(list);
        return rspBO;
    }
}

