/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscSupplierQuotationDetailBO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailLogDAO;
import com.tydic.ssc.dao.SscSupplierQuotationLogDAO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailLogPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationLogPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationPO;
import com.tydic.ssc.service.busi.SscSubmitSupQuotationForBidBusiService;
import com.tydic.ssc.service.busi.bo.SscSubmitSupQuotationForBidBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscSubmitSupQuotationForBidBusiRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscSubmitSupQuotationForBidBusiServiceImpl
implements SscSubmitSupQuotationForBidBusiService {
    @Autowired
    private SscSupplierQuotationDAO sscSupplierQuotationDAO;
    @Autowired
    private SscSupplierQuotationDetailDAO sscSupplierQuotationDetailDAO;
    @Autowired
    private SscSupplierQuotationLogDAO sscSupplierQuotationLogDAO;
    @Autowired
    private SscSupplierQuotationDetailLogDAO sscSupplierQuotationDetailLogDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;

    @Override
    public SscSubmitSupQuotationForBidBusiRspBO dealSubmitSupQuotationForBid(SscSubmitSupQuotationForBidBusiReqBO busiReqBO) {
        SscSubmitSupQuotationForBidBusiRspBO rsp = new SscSubmitSupQuotationForBidBusiRspBO();
        List<SscSupplierQuotationDetailPO> oldDetailPOs = this.getSupplierQuotationDetailInData(busiReqBO);
        HashMap<Long, SscSupplierQuotationDetailPO> detailIdMap = new HashMap<Long, SscSupplierQuotationDetailPO>();
        if (!CollectionUtils.isEmpty(oldDetailPOs)) {
            for (SscSupplierQuotationDetailPO po : oldDetailPOs) {
                detailIdMap.put(po.getProjectDetailId(), po);
            }
        }
        ArrayList<SscSupplierQuotationDetailPO> sscSupplierQuotationDetailPOs = new ArrayList<SscSupplierQuotationDetailPO>();
        if (CollectionUtils.isEmpty(oldDetailPOs)) {
            Long qutationId = Sequence.getInstance().nextId();
            this.insertSupplierQuotation(busiReqBO, qutationId);
            for (SscSupplierQuotationDetailBO bo : busiReqBO.getSscSupplierQuotationDetailBOs()) {
                SscSupplierQuotationDetailPO sscSupplierQuotationDetailPO = new SscSupplierQuotationDetailPO();
                BeanUtils.copyProperties((Object)bo, (Object)sscSupplierQuotationDetailPO);
                sscSupplierQuotationDetailPO.setQuotationId(qutationId);
                sscSupplierQuotationDetailPO.setQuotationDetailId(Sequence.getInstance().nextId());
                sscSupplierQuotationDetailPO.setPlanId(busiReqBO.getPlanId());
                sscSupplierQuotationDetailPO.setProjectId(busiReqBO.getProjectId());
                sscSupplierQuotationDetailPO.setStageId(busiReqBO.getStageId());
                sscSupplierQuotationDetailPO.setSupplierId(busiReqBO.getSupplierId());
                sscSupplierQuotationDetailPO.setSupplierName(busiReqBO.getSupplierName());
                sscSupplierQuotationDetailPO.setQuotationRound(1);
                sscSupplierQuotationDetailPO.setOperId(busiReqBO.getQuotationOperateNo());
                sscSupplierQuotationDetailPO.setOperName(busiReqBO.getQuotationOperateName());
                sscSupplierQuotationDetailPO.setOperTime(new Date());
                sscSupplierQuotationDetailPOs.add(sscSupplierQuotationDetailPO);
            }
            this.intsertSupplierQuotationDetail(sscSupplierQuotationDetailPOs, null);
            this.insertSupplierQuotationDetailLog(sscSupplierQuotationDetailPOs);
        } else {
            ArrayList<Long> qutationDetailIds = new ArrayList<Long>();
            for (SscSupplierQuotationDetailBO bo : busiReqBO.getSscSupplierQuotationDetailBOs()) {
                SscSupplierQuotationDetailPO oldDetailPO = (SscSupplierQuotationDetailPO)detailIdMap.get(bo.getProjectDetailId());
                SscSupplierQuotationDetailPO sscSupplierQuotationDetailPO = new SscSupplierQuotationDetailPO();
                BeanUtils.copyProperties((Object)bo, (Object)sscSupplierQuotationDetailPO);
                sscSupplierQuotationDetailPO.setQuotationId(oldDetailPO.getQuotationId());
                sscSupplierQuotationDetailPO.setQuotationDetailId(oldDetailPO.getQuotationDetailId());
                sscSupplierQuotationDetailPO.setPlanId(busiReqBO.getPlanId());
                sscSupplierQuotationDetailPO.setProjectId(busiReqBO.getProjectId());
                sscSupplierQuotationDetailPO.setStageId(busiReqBO.getStageId());
                sscSupplierQuotationDetailPO.setSupplierId(busiReqBO.getSupplierId());
                sscSupplierQuotationDetailPO.setSupplierName(busiReqBO.getSupplierName());
                sscSupplierQuotationDetailPO.setQuotationRound(oldDetailPO.getQuotationRound() + 1);
                sscSupplierQuotationDetailPO.setOperId(busiReqBO.getQuotationOperateNo());
                sscSupplierQuotationDetailPO.setOperName(busiReqBO.getQuotationOperateName());
                sscSupplierQuotationDetailPO.setOperTime(new Date());
                sscSupplierQuotationDetailPOs.add(sscSupplierQuotationDetailPO);
                qutationDetailIds.add(oldDetailPO.getQuotationDetailId());
            }
            this.intsertSupplierQuotationDetail(sscSupplierQuotationDetailPOs, qutationDetailIds);
            this.insertSupplierQuotationDetailLog(sscSupplierQuotationDetailPOs);
        }
        this.updateLowPrice(sscSupplierQuotationDetailPOs);
        return rsp;
    }

    private void updateLowPrice(List<SscSupplierQuotationDetailPO> sscSupplierQuotationDetailPOs) {
        for (SscSupplierQuotationDetailPO po : sscSupplierQuotationDetailPOs) {
            SscProjectDetailPO updateProjectDetailPO = new SscProjectDetailPO();
            updateProjectDetailPO.setProjectDetailId(po.getProjectDetailId());
            updateProjectDetailPO.setProjectId(po.getProjectId());
            updateProjectDetailPO.setQuotationDetailId(po.getQuotationDetailId());
            updateProjectDetailPO.setTaxUnitPrice(po.getTaxUnitPrice());
            updateProjectDetailPO.setSupplierId(po.getSupplierId());
            int n = this.sscProjectDetailDAO.updateLowPrice(updateProjectDetailPO);
        }
    }

    private void insertSupplierQuotationDetailLog(List<SscSupplierQuotationDetailPO> oldDetailPOs) {
        ArrayList<SscSupplierQuotationDetailLogPO> sscSupplierQuotationDetailLogPOs = new ArrayList<SscSupplierQuotationDetailLogPO>();
        for (SscSupplierQuotationDetailPO po : oldDetailPOs) {
            SscSupplierQuotationDetailLogPO sscSupplierQuotationDetailLogPO = new SscSupplierQuotationDetailLogPO();
            BeanUtils.copyProperties((Object)po, (Object)sscSupplierQuotationDetailLogPO);
            sscSupplierQuotationDetailLogPOs.add(sscSupplierQuotationDetailLogPO);
        }
        int isInsert = this.sscSupplierQuotationDetailLogDAO.insertBatch(sscSupplierQuotationDetailLogPOs);
        if (isInsert != oldDetailPOs.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u4ef7\u660e\u7ec6\u5386\u53f2\u8868\u5931\u8d25\uff01");
        }
    }

    private void intsertSupplierQuotationDetail(List<SscSupplierQuotationDetailPO> newPOs, List<Long> qutationDetailIds) {
        int isInsert;
        if (!CollectionUtils.isEmpty(qutationDetailIds)) {
            SscSupplierQuotationDetailPO deletePO = new SscSupplierQuotationDetailPO();
            deletePO.setQuotationDetailIds(qutationDetailIds);
            int isDelete = this.sscSupplierQuotationDetailDAO.deleteBy(deletePO);
            if (isDelete != qutationDetailIds.size()) {
                throw new BusinessException("8888", "\u5220\u9664\u4f9b\u5e94\u5546\u62a5\u4ef7\u660e\u7ec6\u8868\u5931\u8d25\uff01");
            }
        }
        if ((isInsert = this.sscSupplierQuotationDetailDAO.insertBatch(newPOs)) != newPOs.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u4ef7\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
    }

    private void insertSupplierQuotation(SscSubmitSupQuotationForBidBusiReqBO busiReqBO, Long qutationId) {
        SscSupplierQuotationPO newPO = new SscSupplierQuotationPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)newPO);
        newPO.setQuotationRound(1);
        newPO.setQuotationId(qutationId);
        newPO.setQuotationStatus("1");
        newPO.setQuotationTime(new Date());
        int isInsert = this.sscSupplierQuotationDAO.insert(newPO);
        if (isInsert != 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u4ef7\u5931\u8d25\uff01");
        }
        SscSupplierQuotationLogPO sscSupplierQuotationLogPO = new SscSupplierQuotationLogPO();
        BeanUtils.copyProperties((Object)newPO, (Object)sscSupplierQuotationLogPO);
        int isInsert2 = this.sscSupplierQuotationLogDAO.insert(sscSupplierQuotationLogPO);
        if (isInsert2 < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u4ef7\u5386\u53f2\u8868\u5931\u8d25\uff01");
        }
    }

    private List<SscSupplierQuotationDetailPO> getSupplierQuotationDetailInData(SscSubmitSupQuotationForBidBusiReqBO busiReqBO) {
        SscSupplierQuotationDetailPO wherePO = new SscSupplierQuotationDetailPO();
        wherePO.setPlanId(busiReqBO.getPlanId());
        wherePO.setProjectId(busiReqBO.getProjectId());
        wherePO.setStageId(busiReqBO.getStageId());
        wherePO.setSupplierId(busiReqBO.getSupplierId());
        List<SscSupplierQuotationDetailPO> valuePOs = this.sscSupplierQuotationDetailDAO.getList(wherePO);
        return valuePOs;
    }
}

