/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectAttachBO;
import com.tydic.ssc.common.SscProjectStageBO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectBidRoundDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectStageDAO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.dao.po.SscProjectBidRoundPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectStagePO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.busi.SscSaveOrSubmitTenderProjectBusiService;
import com.tydic.ssc.service.busi.bo.SscSaveOrSubmitTenderProjectBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscSaveOrSubmitTenderProjectBusiRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SscSaveOrSubmitTenderProjectBusiServiceImpl
implements SscSaveOrSubmitTenderProjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscSaveOrSubmitTenderProjectBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectStageDAO sscProjectStageDAO;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;
    @Autowired
    private SscProjectBidRoundDAO sscProjectBidRoundDAO;
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;

    @Override
    public SscSaveOrSubmitTenderProjectBusiRspBO saveOrSubmitTenderProject(SscSaveOrSubmitTenderProjectBusiReqBO reqBO) {
        Object updateParam;
        Object insertParam;
        SscSaveOrSubmitTenderProjectBusiRspBO rspBO = new SscSaveOrSubmitTenderProjectBusiRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getSscProjectBO().getTenderMode())) {
            throw new BusinessException("0001", "\u5165\u53c2\u3010tenderMode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSscProjectBO() != null) {
            SscProjectPO qryResult = this.sscProjectDAO.selectByPrimaryKey(reqBO.getProjectId());
            if (null == qryResult) {
                throw new BusinessException("8888", "\u9879\u76ee\u67e5\u8be2\u5931\u8d25\uff0c\u9879\u76eeid\uff1a" + reqBO.getProjectId().toString());
            }
            SscProjectPO updateParam2 = new SscProjectPO();
            BeanUtils.copyProperties(qryResult, (Object)updateParam2);
            BeanUtils.copyProperties((Object)reqBO.getSscProjectBO(), (Object)updateParam2);
            updateParam2.setProjectId(reqBO.getProjectId());
            if (null == reqBO.getSubmitFlag()) {
                updateParam2.setProjectStatus("1");
            } else {
                updateParam2.setProjectStatus(reqBO.getSubmitFlag().equals(true) ? "4" : "1");
                updateParam2.setProjectStatus(reqBO.getAuditFlag().equals(true) ? "2" : updateParam2.getProjectStatus());
            }
            updateParam2.setProjectUpdateTime(new Date());
            int updateResult = this.sscProjectDAO.updateByPrimaryKeySelective(updateParam2);
            if (updateResult < 1) {
                throw new BusinessException("8888", "\u62db\u6807\u9879\u76ee\u66f4\u65b0\u5931\u8d25");
            }
            if (!StringUtils.isEmpty((Object)reqBO.getStatusChangeOperCode())) {
                SscDealStatusCirculationConfAtomReqBO atomReqBO = new SscDealStatusCirculationConfAtomReqBO();
                BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)atomReqBO));
                atomReqBO.setId(reqBO.getProjectId());
                atomReqBO.setStatusChangeOperCode(reqBO.getStatusChangeOperCode());
                SscDealStatusCirculationConfAtomRspBO atomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(atomReqBO);
                if (!"0000".equalsIgnoreCase(atomRspBO.getRespCode())) {
                    throw new BusinessException("8888", "\u8c03\u7528\u539f\u5b50\u670d\u52a1\u5931\u8d25");
                }
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getAddSscProjectStageBOs())) {
            for (SscProjectStageBO sscProjectStageBO : reqBO.getAddSscProjectStageBOs()) {
                if (StringUtils.isEmpty((Object)sscProjectStageBO.getStageId())) {
                    throw new BusinessException("0001", "\u5165\u53c2\u3010stageId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                SscProjectStagePO qryResult = this.sscProjectStageDAO.selectByPrimaryKey(sscProjectStageBO.getStageId());
                if (qryResult == null) {
                    insertParam = new SscProjectStagePO();
                    BeanUtils.copyProperties((Object)sscProjectStageBO, (Object)insertParam);
                    ((SscProjectStagePO)insertParam).setProjectId(reqBO.getProjectId());
                    int insertResult = this.sscProjectStageDAO.insert((SscProjectStagePO)insertParam);
                    if (insertResult >= 1) continue;
                    throw new BusinessException("8888", "\u6807\u6bb5\u65b0\u589e\u5931\u8d25");
                }
                updateParam = new SscProjectStagePO();
                BeanUtils.copyProperties((Object)sscProjectStageBO, (Object)updateParam);
                int updateResult = this.sscProjectStageDAO.updateByPrimaryKeySelective((SscProjectStagePO)updateParam);
                if (updateResult >= 1) continue;
                throw new BusinessException("8888", "\u6807\u6bb5\u4fee\u6539\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSscProjectBO().getSscProjectAttachBOs())) {
            for (SscProjectAttachBO sscProjectAttachBO : reqBO.getSscProjectBO().getSscProjectAttachBOs()) {
                SscProjectAttachPO qryResult = this.sscProjectAttachDAO.selectByPrimaryKey(sscProjectAttachBO.getProjectAttachId());
                if (qryResult == null) {
                    if (StringUtils.isEmpty((Object)sscProjectAttachBO.getProjectAttachAddress())) {
                        throw new BusinessException("0001", "\u5165\u53c2\u3010projectAttachAddress\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)sscProjectAttachBO.getProjectAttachType())) {
                        throw new BusinessException("0001", "\u5165\u53c2\u3010projectAttachType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    insertParam = new SscProjectAttachPO();
                    BeanUtils.copyProperties((Object)sscProjectAttachBO, (Object)insertParam);
                    ((SscProjectAttachPO)insertParam).setProjectId(reqBO.getProjectId());
                    ((SscProjectAttachPO)insertParam).setProjectAttachId(Sequence.getInstance().nextId());
                    int insertResult = this.sscProjectAttachDAO.insert((SscProjectAttachPO)insertParam);
                    if (insertResult >= 1) continue;
                    throw new BusinessException("8888", "\u9644\u4ef6\u65b0\u589e\u5931\u8d25");
                }
                updateParam = new SscProjectAttachPO();
                BeanUtils.copyProperties((Object)sscProjectAttachBO, (Object)updateParam);
                int updateResult = this.sscProjectAttachDAO.updateByPrimaryKeySelective((SscProjectAttachPO)updateParam);
                if (updateResult >= 1) continue;
                throw new BusinessException("8888", "\u9644\u4ef6\u4fee\u6539\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSscProjectBO().getDeleteProjectAttachTypes())) {
            List deleteProjectAttachTypes = reqBO.getSscProjectBO().getDeleteProjectAttachTypes();
            SscProjectAttachPO deleteParam = new SscProjectAttachPO();
            deleteParam.setProjectAttachTypes(deleteProjectAttachTypes);
            int deleteResult = this.sscProjectAttachDAO.deleteBy(deleteParam);
            if (deleteResult < 1) {
                throw new BusinessException("8888", "\u5220\u9664\u6307\u5b9a\u7c7b\u578b\u7684\u9644\u4ef6\u5931\u8d25");
            }
        }
        SscProjectBidRoundPO inertProjectBidRoundPO = new SscProjectBidRoundPO();
        inertProjectBidRoundPO.setBidRoundId(Sequence.getInstance().nextId());
        inertProjectBidRoundPO.setProjectId(reqBO.getProjectId());
        inertProjectBidRoundPO.setBidStatus("2");
        inertProjectBidRoundPO.setScoreRound(1);
        inertProjectBidRoundPO.setQuotationRound(1);
        inertProjectBidRoundPO.setOperNo(reqBO.getMemIdIn());
        inertProjectBidRoundPO.setOperName(reqBO.getName());
        inertProjectBidRoundPO.setOperTime(new Date());
        int isInsert = this.sscProjectBidRoundDAO.insert(inertProjectBidRoundPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u8bc4\u6807\u8f6e\u6b21\u8868\u5931\u8d25\uff01");
        }
        if (!reqBO.getSubmitFlag().equals(true) || !reqBO.getAuditFlag().equals(true) || reqBO.getSscProjectBO().getPurchaseMode().equals("1") || reqBO.getSscProjectBO().getPurchaseMode().equals("2")) {
            // empty if block
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62db\u6807\u9879\u76ee\u66f4\u65b0\u6210\u529f");
        return rspBO;
    }
}

