/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.atom.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscSupplierQuotationChangeDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailChangeDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailLogDAO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationChangePO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailChangePO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailLogPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailPO;
import com.tydic.ssc.service.atom.SscConfirmQuotationChangeAtomService;
import com.tydic.ssc.service.atom.bo.SscConfirmQuotationChangeAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscConfirmQuotationChangeAtomRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscConfirmQuotationChangeAtomServiceImpl
implements SscConfirmQuotationChangeAtomService {
    @Autowired
    private SscSupplierQuotationChangeDAO sscSupplierQuotationChangeDAO;
    @Autowired
    private SscSupplierQuotationDetailChangeDAO sscSupplierQuotationDetailChangeDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscSupplierQuotationDetailDAO sscSupplierQuotationDetailDAO;
    @Autowired
    private SscSupplierQuotationDetailLogDAO sscSupplierQuotationDetailLogDAO;

    @Override
    public SscConfirmQuotationChangeAtomRspBO dealConfirmQuotationChange(SscConfirmQuotationChangeAtomReqBO atomReqBO) {
        SscConfirmQuotationChangeAtomRspBO rsp = new SscConfirmQuotationChangeAtomRspBO();
        SscSupplierQuotationChangePO sscSupplierQuotationChangePO = this.sscSupplierQuotationChangeDAO.selectByPrimaryKey(atomReqBO.getQuotationChangeId());
        if (null == sscSupplierQuotationChangePO) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u4ef7\u53d8\u66f4\u8868\u4e3a\u7a7a\uff01");
        }
        if (!"1".equals(sscSupplierQuotationChangePO.getUpdateQuotationStatus())) {
            throw new BusinessException("8888", "\u8be5\u4f9b\u5e94\u5546\u62a5\u4ef7\u53d8\u66f4\u975e\u5f85\u786e\u8ba4\uff01");
        }
        if (2 == atomReqBO.getComfirmResult()) {
            this.dealNotAgree(atomReqBO);
        } else {
            this.dealAgree(atomReqBO, sscSupplierQuotationChangePO);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62a5\u4ef7\u53d8\u66f4\u786e\u8ba4\u6210\u529f\uff01");
        return rsp;
    }

    private void dealAgree(SscConfirmQuotationChangeAtomReqBO atomReqBO, SscSupplierQuotationChangePO sscSupplierQuotationChangePO) {
        this.updateSupplierQuotationChange(atomReqBO);
        if (StringUtils.isNotBlank((CharSequence)sscSupplierQuotationChangePO.getPayMode()) || StringUtils.isNotBlank((CharSequence)sscSupplierQuotationChangePO.getTradeMode())) {
            this.updateSupplierProject(sscSupplierQuotationChangePO);
        }
        this.updateSupplierQuotation(sscSupplierQuotationChangePO);
    }

    private void updateSupplierQuotation(SscSupplierQuotationChangePO sscSupplierQuotationChangePO) {
        Map<Long, SscSupplierQuotationDetailChangePO> quotationDetailChangeMap = this.getQuotationDetailChange(sscSupplierQuotationChangePO.getQuotationChangeId());
        this.updateQuotationDetail(sscSupplierQuotationChangePO, quotationDetailChangeMap);
        this.updateQuotationDetailLog(sscSupplierQuotationChangePO, quotationDetailChangeMap);
    }

    private void updateQuotationDetailLog(SscSupplierQuotationChangePO sscSupplierQuotationChangePO, Map<Long, SscSupplierQuotationDetailChangePO> quotationDetailChangeMap) {
        SscSupplierQuotationDetailLogPO wherePO = new SscSupplierQuotationDetailLogPO();
        wherePO.setProjectId(sscSupplierQuotationChangePO.getProjectId());
        wherePO.setSupplierId(sscSupplierQuotationChangePO.getSupplierId());
        wherePO.setQuotationRound(sscSupplierQuotationChangePO.getQuotationRound());
        List<SscSupplierQuotationDetailLogPO> sscSupplierQuotationDetailLogPOs = this.sscSupplierQuotationDetailLogDAO.getList(wherePO);
        if (CollectionUtils.isEmpty(sscSupplierQuotationDetailLogPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u62a5\u4ef7\u660e\u7ec6\u5386\u53f2\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        ArrayList<SscSupplierQuotationDetailLogPO> insertPOs = new ArrayList<SscSupplierQuotationDetailLogPO>();
        ArrayList<Long> supplierQuotationDetailLogIds = new ArrayList<Long>();
        for (SscSupplierQuotationDetailLogPO po : sscSupplierQuotationDetailLogPOs) {
            SscSupplierQuotationDetailChangePO changeDetailPO = quotationDetailChangeMap.get(po.getProjectDetailId());
            if (null == changeDetailPO) continue;
            SscSupplierQuotationDetailLogPO updatePO = new SscSupplierQuotationDetailLogPO();
            BeanUtils.copyProperties((Object)po, (Object)updatePO);
            if (null != changeDetailPO.getQuotationUnitPrice()) {
                updatePO.setQuotationUnitPrice(changeDetailPO.getQuotationUnitPrice());
            }
            if (null != changeDetailPO.getTotalQuotationPrice()) {
                updatePO.setTotalQuotationPrice(changeDetailPO.getTotalQuotationPrice());
            }
            if (null != changeDetailPO.getTaxUnitPrice()) {
                updatePO.setTaxUnitPrice(changeDetailPO.getTaxUnitPrice());
            }
            if (null != changeDetailPO.getTaxTotalPrice()) {
                updatePO.setTaxTotalPrice(changeDetailPO.getTaxTotalPrice());
            }
            if (null != changeDetailPO.getPromisedDeliveryDate()) {
                updatePO.setPromisedDeliveryDate(changeDetailPO.getPromisedDeliveryDate());
            }
            insertPOs.add(updatePO);
            supplierQuotationDetailLogIds.add(po.getSupplierQuotationDetailLogId());
        }
        SscSupplierQuotationDetailLogPO deletePO = new SscSupplierQuotationDetailLogPO();
        deletePO.setSupplierQuotationDetailLogIds(supplierQuotationDetailLogIds);
        int isDelete = this.sscSupplierQuotationDetailLogDAO.deleteBy(deletePO);
        if (isDelete != supplierQuotationDetailLogIds.size()) {
            throw new BusinessException("8888", "\u5220\u9664\u62a5\u4ef7\u660e\u7ec6\u5386\u53f2\u8868\u5931\u8d25\uff01");
        }
        int isInsert = this.sscSupplierQuotationDetailLogDAO.insertBatch(insertPOs);
        if (isInsert != insertPOs.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u62a5\u4ef7\u660e\u7ec6\u5386\u53f2\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateQuotationDetail(SscSupplierQuotationChangePO sscSupplierQuotationChangePO, Map<Long, SscSupplierQuotationDetailChangePO> quotationDetailChangeMap) {
        SscSupplierQuotationDetailPO wherePO = new SscSupplierQuotationDetailPO();
        wherePO.setProjectId(sscSupplierQuotationChangePO.getProjectId());
        wherePO.setSupplierId(sscSupplierQuotationChangePO.getSupplierId());
        wherePO.setQuotationRound(sscSupplierQuotationChangePO.getQuotationRound());
        List<SscSupplierQuotationDetailPO> sscSupplierQuotationDetailPOs = this.sscSupplierQuotationDetailDAO.getList(wherePO);
        if (CollectionUtils.isEmpty(sscSupplierQuotationDetailPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u62a5\u4ef7\u660e\u7ec6\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        ArrayList<SscSupplierQuotationDetailPO> insertPOs = new ArrayList<SscSupplierQuotationDetailPO>();
        ArrayList<Long> quotationDetailIds = new ArrayList<Long>();
        for (SscSupplierQuotationDetailPO po : sscSupplierQuotationDetailPOs) {
            SscSupplierQuotationDetailChangePO changeDetailPO = quotationDetailChangeMap.get(po.getProjectDetailId());
            if (null == changeDetailPO) continue;
            SscSupplierQuotationDetailPO updatePO = new SscSupplierQuotationDetailPO();
            BeanUtils.copyProperties((Object)po, (Object)updatePO);
            if (null != changeDetailPO.getQuotationUnitPrice()) {
                updatePO.setQuotationUnitPrice(changeDetailPO.getQuotationUnitPrice());
            }
            if (null != changeDetailPO.getTotalQuotationPrice()) {
                updatePO.setTotalQuotationPrice(changeDetailPO.getTotalQuotationPrice());
            }
            if (null != changeDetailPO.getTaxUnitPrice()) {
                updatePO.setTaxUnitPrice(changeDetailPO.getTaxUnitPrice());
            }
            if (null != changeDetailPO.getTaxTotalPrice()) {
                updatePO.setTaxTotalPrice(changeDetailPO.getTaxTotalPrice());
            }
            if (null != changeDetailPO.getPromisedDeliveryDate()) {
                updatePO.setPromisedDeliveryDate(changeDetailPO.getPromisedDeliveryDate());
            }
            insertPOs.add(updatePO);
            quotationDetailIds.add(po.getQuotationDetailId());
        }
        SscSupplierQuotationDetailPO deletePO = new SscSupplierQuotationDetailPO();
        deletePO.setQuotationDetailIds(quotationDetailIds);
        int isDelete = this.sscSupplierQuotationDetailDAO.deleteBy(deletePO);
        if (isDelete != quotationDetailIds.size()) {
            throw new BusinessException("8888", "\u5220\u9664\u62a5\u4ef7\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        int isInsert = this.sscSupplierQuotationDetailDAO.insertBatch(insertPOs);
        if (isInsert != insertPOs.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u62a5\u4ef7\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
    }

    private Map<Long, SscSupplierQuotationDetailChangePO> getQuotationDetailChange(Long quotationChangeId) {
        HashMap<Long, SscSupplierQuotationDetailChangePO> quotationDetailChangeMap = new HashMap<Long, SscSupplierQuotationDetailChangePO>();
        SscSupplierQuotationDetailChangePO wherePO = new SscSupplierQuotationDetailChangePO();
        wherePO.setQuotationChangeId(quotationChangeId);
        List<SscSupplierQuotationDetailChangePO> sscSupplierQuotationDetailChangePOs = this.sscSupplierQuotationDetailChangeDAO.getList(wherePO);
        if (CollectionUtils.isEmpty(sscSupplierQuotationDetailChangePOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u62a5\u4ef7\u53d8\u66f4\u660e\u7ec6\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        for (SscSupplierQuotationDetailChangePO po : sscSupplierQuotationDetailChangePOs) {
            quotationDetailChangeMap.put(po.getProjectDetailId(), po);
        }
        return quotationDetailChangeMap;
    }

    private void updateSupplierProject(SscSupplierQuotationChangePO sscSupplierQuotationChangePO) {
        int isUpdate;
        SscProjectSupplierPO updatePO = new SscProjectSupplierPO();
        updatePO.setProjectId(sscSupplierQuotationChangePO.getProjectId());
        updatePO.setSupplierId(sscSupplierQuotationChangePO.getSupplierId());
        if (StringUtils.isNotBlank((CharSequence)sscSupplierQuotationChangePO.getPayMode())) {
            updatePO.setPayMode(sscSupplierQuotationChangePO.getPayMode());
            updatePO.setPayModeShow(sscSupplierQuotationChangePO.getPayModeShow());
        }
        if (StringUtils.isNotBlank((CharSequence)sscSupplierQuotationChangePO.getTradeMode())) {
            updatePO.setTradeMode(sscSupplierQuotationChangePO.getTradeMode());
            updatePO.setTradeModeShow(sscSupplierQuotationChangePO.getTradeModeShow());
            updatePO.setExpecSettleMethod(sscSupplierQuotationChangePO.getExpecSettleMethod());
            updatePO.setExpecSettleDay(sscSupplierQuotationChangePO.getExpecSettleDay());
            updatePO.setPrePay(sscSupplierQuotationChangePO.getPrePay());
            updatePO.setPilPay(sscSupplierQuotationChangePO.getPilPay());
            updatePO.setVerPay(sscSupplierQuotationChangePO.getVerPay());
            updatePO.setQualityMoney(sscSupplierQuotationChangePO.getQualityMoney());
            updatePO.setQualityPeriod(sscSupplierQuotationChangePO.getQualityPeriod());
        }
        if ((isUpdate = this.sscProjectSupplierDAO.updateByCondition(updatePO)) < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
        }
    }

    private void dealNotAgree(SscConfirmQuotationChangeAtomReqBO atomReqBO) {
        this.updateSupplierQuotationChange(atomReqBO);
    }

    private void updateSupplierQuotationChange(SscConfirmQuotationChangeAtomReqBO atomReqBO) {
        SscSupplierQuotationChangePO updatePO = new SscSupplierQuotationChangePO();
        updatePO.setQuotationChangeId(atomReqBO.getQuotationChangeId());
        updatePO.setProjectId(atomReqBO.getProjectId());
        updatePO.setUpdateQuotationStatus("2");
        updatePO.setComfirmResult(atomReqBO.getComfirmResult());
        updatePO.setComfirmOpinion(atomReqBO.getComfirmOpinion());
        int isUpdate = this.sscSupplierQuotationChangeDAO.updateByPrimaryKeySelective(updatePO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u4f9b\u5e94\u5546\u62a5\u4ef7\u53d8\u66f4\u8868\u5931\u8d25\uff01");
        }
    }
}

