/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscProjectTempAttachDAO;
import com.tydic.ssc.dao.SscStatusCirculationConfDAO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscProjectTempAttachPO;
import com.tydic.ssc.dao.po.SscStatusCirculationConfPO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.SscSelectSupplierApprovalAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.atom.bo.SscSelectSupplierApprovalAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscSelectSupplierApprovalAtomRspBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscSelectSupplierApprovalAtomServiceImpl
implements SscSelectSupplierApprovalAtomService {
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProjectTempAttachDAO sscProjectTempAttachDAO;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;
    @Autowired
    private SscStatusCirculationConfDAO sscStatusCirculationConfDAO;

    @Override
    public SscSelectSupplierApprovalAtomRspBO dealSelectSupplierApproval(SscSelectSupplierApprovalAtomReqBO atomReqBO) {
        SscSelectSupplierApprovalAtomRspBO rsp = new SscSelectSupplierApprovalAtomRspBO();
        SscDealStatusCirculationConfAtomReqBO sscDealStatusCirculationConfAtomReqBO = new SscDealStatusCirculationConfAtomReqBO();
        sscDealStatusCirculationConfAtomReqBO.setProjectId(atomReqBO.getProjectId());
        sscDealStatusCirculationConfAtomReqBO.setId(atomReqBO.getProjectId());
        sscDealStatusCirculationConfAtomReqBO.setStatusChangeOperCode(atomReqBO.getStatusChangeOperCode());
        SscDealStatusCirculationConfAtomRspBO sscDealStatusCirculationConfAtomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(sscDealStatusCirculationConfAtomReqBO);
        if (!"0000".equals(sscDealStatusCirculationConfAtomRspBO.getRespCode())) {
            throw new BusinessException(sscDealStatusCirculationConfAtomRspBO.getRespCode(), sscDealStatusCirculationConfAtomRspBO.getRespDesc());
        }
        if (0 == atomReqBO.getAuditResult()) {
            this.updateProjectSupplierStatus(atomReqBO.getProjectId());
        }
        if (0 == atomReqBO.getAuditResult()) {
            this.updateAttachToProject(atomReqBO.getProjectId());
        } else {
            this.deleteProjectTempAttach(atomReqBO.getProjectId());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5165\u56f4\u4f9b\u5e94\u5546\u5ba1\u6279\u6210\u529f\uff01");
        return rsp;
    }

    private void deleteProjectTempAttach(Long projectId) {
        SscProjectTempAttachPO deletePO = new SscProjectTempAttachPO();
        deletePO.setProjectId(projectId);
        deletePO.setTacheCode("1");
        deletePO.setProjectObjectType("1");
        deletePO.setProjectObjectId(projectId);
        this.sscProjectTempAttachDAO.deleteBy(deletePO);
    }

    private void updateAttachToProject(Long projectId) {
        SscProjectAttachPO deletePO = new SscProjectAttachPO();
        deletePO.setProjectId(projectId);
        deletePO.setProjectObjectId(projectId);
        deletePO.setProjectObjectType("1");
        deletePO.setProjectAttachType("3");
        this.sscProjectAttachDAO.deleteBy(deletePO);
        SscProjectTempAttachPO wherePO = new SscProjectTempAttachPO();
        wherePO.setProjectId(projectId);
        wherePO.setTacheCode("1");
        wherePO.setProjectObjectType("1");
        wherePO.setProjectObjectId(projectId);
        List<SscProjectTempAttachPO> sscProjectTempAttachPOs = this.sscProjectTempAttachDAO.getList(wherePO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(sscProjectTempAttachPOs)) {
            ArrayList<SscProjectAttachPO> insertPOs = new ArrayList<SscProjectAttachPO>();
            for (SscProjectTempAttachPO po : sscProjectTempAttachPOs) {
                SscProjectAttachPO sscProjectAttachPO = new SscProjectAttachPO();
                sscProjectAttachPO.setProjectAttachId(Sequence.getInstance().nextId());
                sscProjectAttachPO.setProjectId(projectId);
                sscProjectAttachPO.setProjectAttachAddress(po.getProjectAttachAddress());
                sscProjectAttachPO.setProjectAttachName(po.getProjectAttachName());
                sscProjectAttachPO.setProjectAttachType("3");
                sscProjectAttachPO.setSupplierVisitFlag(po.getSupplierVisitFlag());
                sscProjectAttachPO.setProjectObjectType("1");
                sscProjectAttachPO.setProjectObjectId(projectId);
                insertPOs.add(sscProjectAttachPO);
            }
            int isInsert = this.sscProjectAttachDAO.insertBatch(insertPOs);
            if (isInsert != insertPOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u9644\u4ef6\u8868\u5931\u8d25\uff01");
            }
        }
        this.sscProjectTempAttachDAO.deleteBy(wherePO);
    }

    private void updateProjectSupplierStatus(Long projectId) {
        SscProjectPO sscProjectPO = this.sscProjectDAO.selectByPrimaryKey(projectId);
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode("select_supplier_submit_supplier");
        whereStatusCirculationConfPO.setPurchaseMode(sscProjectPO.getPurchaseMode());
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            SscProjectSupplierPO wherePO = new SscProjectSupplierPO();
            wherePO.setProjectId(projectId);
            wherePO.setSupplierStatus(po.getOldStatus());
            wherePO.setSelectStatus(po.getOtherParam());
            SscProjectSupplierPO setPO = new SscProjectSupplierPO();
            setPO.setSupplierStatus(po.getNewStatus());
            int n = this.sscProjectSupplierDAO.updateBy(setPO, wherePO);
        }
    }
}

