/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectClearBO;
import com.tydic.ssc.dao.SscProjectClearDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryProjectClearListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProjectClearListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProjectClearListBusiRspBO;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQryProjectClearListBusiServiceImpl
implements SscQryProjectClearListBusiService {
    @Autowired
    private SscProjectClearDAO sscProjectClearDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryProjectClearListBusiRspBO qryProjectClearList(SscQryProjectClearListBusiReqBO busiReqBO) {
        Page page;
        List<SscProjectClearBO> rows;
        SscQryProjectClearListBusiRspBO rsp = new SscQryProjectClearListBusiRspBO();
        if (!busiReqBO.getQueryPageFlag().booleanValue()) {
            busiReqBO.setPageNo(-1);
            busiReqBO.setPageSize(-1);
        }
        if (CollectionUtils.isEmpty(rows = this.sscProjectClearDAO.getListPageWithProject(busiReqBO, (Page<SscProjectClearBO>)(page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue()))))) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (busiReqBO.getTranslateFlag().booleanValue()) {
            Map<String, String> yesOrNoMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
            Map<String, String> clearLaunchSourceMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "CLEAR_LAUNCH_SOURCE");
            Map<String, String> clearStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "CLEAR_STATUS");
            for (SscProjectClearBO bo : rows) {
                if (StringUtils.isNotBlank((CharSequence)bo.getClearIsPublic())) {
                    bo.setClearIsPublicStr(yesOrNoMap.get(bo.getClearIsPublic()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getClearLaunchSource())) {
                    bo.setClearLaunchSourceStr(clearLaunchSourceMap.get(bo.getClearLaunchSource()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getClearStatus())) {
                    bo.setClearStatusStr(clearStatusMap.get(bo.getClearStatus()));
                }
                if (!StringUtils.isNotBlank((CharSequence)bo.getResponseIsPublic())) continue;
                bo.setResponseIsPublicStr(yesOrNoMap.get(bo.getResponseIsPublic()));
            }
        }
        rsp.setPageNo(page.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9879\u76ee\u6f84\u6e05\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }
}

