/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscSupplierProjectInfoBO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.busi.SscQrySupplierProjectListBusiService;
import com.tydic.ssc.service.busi.bo.SscQrySupplierProjectListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQrySupplierProjectListBusiRspBO;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQrySupplierProjectListBusiServiceImpl
implements SscQrySupplierProjectListBusiService {
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQrySupplierProjectListBusiRspBO qrySupplierProjectList(SscQrySupplierProjectListBusiReqBO reqBO) {
        List<SscSupplierProjectInfoBO> sscSupplierProjectInfoBOS;
        SscQrySupplierProjectListBusiRspBO rspBO = new SscQrySupplierProjectListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        String toSignUp = reqBO.getToSignUp();
        if (StringUtils.isNotBlank((CharSequence)toSignUp)) {
            reqBO.setToSignUp(toSignUp);
        }
        if (CollectionUtils.isEmpty(sscSupplierProjectInfoBOS = this.sscProjectSupplierDAO.getSupplierProjectList(reqBO, (Page<SscSupplierProjectInfoBO>)page))) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u9879\u76ee\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscSupplierProjectInfoBOS);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscSupplierProjectInfoBOS);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u9879\u76ee\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscSupplierProjectInfoBO> supplierProjectInfoBOS) {
        Map<String, String> projectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_STATUS");
        Map<String, String> purchaseModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
        Map<String, String> quotationModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUOTATION_MODE");
        Map<String, String> commonMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
        Map<String, String> supplierStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "SUPPLIER_STATUS");
        Map<String, String> xbjProjectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "XBJ_PROJECT_STATUS");
        Map<String, String> xbjSupplierStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "XBJ_SUPPLIER_STATUS");
        for (SscSupplierProjectInfoBO supplierProjectInfoBO : supplierProjectInfoBOS) {
            if (StringUtils.isNotBlank((CharSequence)supplierProjectInfoBO.getProjectStatus())) {
                if ("1".equals(supplierProjectInfoBO.getPurchaseMode())) {
                    supplierProjectInfoBO.setProjectStatusStr(projectStatusMap.get(supplierProjectInfoBO.getProjectStatus()));
                } else if ("2".equals(supplierProjectInfoBO.getPurchaseMode())) {
                    supplierProjectInfoBO.setProjectStatusStr(xbjProjectStatusMap.get(supplierProjectInfoBO.getProjectStatus()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)supplierProjectInfoBO.getPurchaseMode())) {
                supplierProjectInfoBO.setPurchaseModeStr(purchaseModeMap.get(supplierProjectInfoBO.getPurchaseMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierProjectInfoBO.getTenderMode())) {
                supplierProjectInfoBO.setTenderModeStr(tenderModeMap.get(supplierProjectInfoBO.getTenderMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)supplierProjectInfoBO.getQuotationMode())) {
                supplierProjectInfoBO.setQuotationModeStr(quotationModeMap.get(supplierProjectInfoBO.getQuotationMode()));
            }
            if (StringUtils.isBlank((CharSequence)supplierProjectInfoBO.getSupplierStatus())) {
                supplierProjectInfoBO.setSupplierStatus("1");
            }
            if (!StringUtils.isNotBlank((CharSequence)supplierProjectInfoBO.getSupplierStatus())) continue;
            if ("1".equals(supplierProjectInfoBO.getPurchaseMode())) {
                supplierProjectInfoBO.setSupplierStatusStr(supplierStatusMap.get(supplierProjectInfoBO.getSupplierStatus()));
                continue;
            }
            if (!"2".equals(supplierProjectInfoBO.getPurchaseMode())) continue;
            supplierProjectInfoBO.setSupplierStatusStr(xbjSupplierStatusMap.get(supplierProjectInfoBO.getSupplierStatus()));
        }
    }
}

