/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscAuditBO;
import com.tydic.ssc.common.SscSupplierAdviceNoteBO;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscAuditDAO;
import com.tydic.ssc.dao.SscProjectApprovalDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscProjectTempResultDAO;
import com.tydic.ssc.dao.SscProjectTempResultDetailDAO;
import com.tydic.ssc.dao.SscProjectTempResultSupplierDAO;
import com.tydic.ssc.dao.SscStatusCirculationConfDAO;
import com.tydic.ssc.dao.SscSupplierAdviceNoteDAO;
import com.tydic.ssc.dao.po.SscAuditPO;
import com.tydic.ssc.dao.po.SscProjectApprovalPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscProjectTempResultDetailPO;
import com.tydic.ssc.dao.po.SscProjectTempResultPO;
import com.tydic.ssc.dao.po.SscStatusCirculationConfPO;
import com.tydic.ssc.dao.po.SscSupplierAdviceNotePO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.busi.SscTempResultApprovalBusiService;
import com.tydic.ssc.service.busi.bo.SscTempResultApprovalBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscTempResultApprovalBusiRspBO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscTempResultApprovalBusiServiceImpl
implements SscTempResultApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscTempResultApprovalBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectApprovalDAO sscProjectApprovalDAO;
    @Autowired
    private SscProjectTempResultDAO sscProjectTempResultDAO;
    @Autowired
    private SscAuditDAO sscAuditDAO;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;
    private SscSupplierAdviceNoteDAO sscSupplierAdviceNoteDAO;
    @Autowired
    private SscProjectTempResultDetailDAO sscProjectTempResultDetailDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;
    @Autowired
    private SscProjectTempResultSupplierDAO sscProjectTempResultSupplierDAO;
    @Autowired
    private SscStatusCirculationConfDAO sscStatusCirculationConfDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;

    @Override
    public SscTempResultApprovalBusiRspBO dealTempResultApproval(SscTempResultApprovalBusiReqBO busiReqBO) {
        SscTempResultApprovalBusiRspBO rsp = new SscTempResultApprovalBusiRspBO();
        Map<Long, Long> auditProjectMap = this.getToAudiId(busiReqBO.getProjectIds());
        Map<String, Set<Long>> stepProjectIdMap = this.validProjectInfo(busiReqBO, auditProjectMap.keySet());
        for (String stepId : stepProjectIdMap.keySet()) {
            busiReqBO.setToApprovalIds(new ArrayList<Long>((Collection)stepProjectIdMap.get(stepId)));
            Boolean processEndFlag = this.invokeProcess(busiReqBO, stepId);
            if (!processEndFlag.booleanValue()) continue;
            for (Long toApprovalId : busiReqBO.getToApprovalIds()) {
                this.updateTempResultStatus(auditProjectMap.get(toApprovalId), busiReqBO.getAuditResult());
                SscDealStatusCirculationConfAtomReqBO sscDealStatusCirculationConfAtomReqBO = new SscDealStatusCirculationConfAtomReqBO();
                sscDealStatusCirculationConfAtomReqBO.setProjectId(auditProjectMap.get(toApprovalId));
                sscDealStatusCirculationConfAtomReqBO.setId(auditProjectMap.get(toApprovalId));
                sscDealStatusCirculationConfAtomReqBO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
                SscDealStatusCirculationConfAtomRspBO sscDealStatusCirculationConfAtomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(sscDealStatusCirculationConfAtomReqBO);
                if (!"0000".equals(sscDealStatusCirculationConfAtomRspBO.getRespCode())) {
                    throw new BusinessException(sscDealStatusCirculationConfAtomRspBO.getRespCode(), sscDealStatusCirculationConfAtomRspBO.getRespDesc());
                }
                if (0 == busiReqBO.getAuditResult()) {
                    List<SscSupplierAdviceNotePO> insertPOs = this.insertSupplierAdviceNote(auditProjectMap.get(toApprovalId), busiReqBO);
                    HashMap<Long, SscSupplierAdviceNoteBO> sscSupplierAdviceNoteBOMap = new HashMap<Long, SscSupplierAdviceNoteBO>();
                    if (!CollectionUtils.isEmpty(insertPOs)) {
                        for (SscSupplierAdviceNotePO po : insertPOs) {
                            SscSupplierAdviceNoteBO sscSupplierAdviceNoteBO = new SscSupplierAdviceNoteBO();
                            BeanUtils.copyProperties((Object)po, (Object)sscSupplierAdviceNoteBO);
                            sscSupplierAdviceNoteBOMap.put(po.getSupplierId(), sscSupplierAdviceNoteBO);
                        }
                    }
                    rsp.setSscSupplierAdviceNoteBOMap(sscSupplierAdviceNoteBOMap);
                    this.updateSupplierStatusForYes(auditProjectMap.get(toApprovalId));
                    continue;
                }
                this.updateSupplierStatusForNo(auditProjectMap.get(toApprovalId));
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62df\u5b9a\u7ed3\u679c\u5ba1\u6279\u6210\u529f\uff01");
        return rsp;
    }

    private void updateSupplierStatusForNo(Long projectId) {
        SscProjectPO sscProjectPO = this.sscProjectDAO.selectByPrimaryKey(projectId);
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode("temp_result_approval_no_for_supplier");
        whereStatusCirculationConfPO.setPurchaseMode(sscProjectPO.getPurchaseMode());
        SscStatusCirculationConfPO sscStatusCirculationConfPO = this.sscStatusCirculationConfDAO.getModelBy(whereStatusCirculationConfPO);
        if (null == sscStatusCirculationConfPO) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        List<String> oldStatussForNo = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)sscStatusCirculationConfPO.getOldStatus())) {
            if (sscStatusCirculationConfPO.getOldStatus().contains(",")) {
                oldStatussForNo = Arrays.asList(sscStatusCirculationConfPO.getOldStatus().split(","));
            } else {
                oldStatussForNo.add(sscStatusCirculationConfPO.getOldStatus());
            }
        }
        SscProjectSupplierPO whwereProjectSupplierPOForNo = new SscProjectSupplierPO();
        whwereProjectSupplierPOForNo.setProjectId(projectId);
        whwereProjectSupplierPOForNo.setOldSupplierStatuss(oldStatussForNo);
        whwereProjectSupplierPOForNo.setSupplierStatus(sscStatusCirculationConfPO.getNewStatus());
        int isUpdate2 = this.sscProjectSupplierDAO.updateByCondition(whwereProjectSupplierPOForNo);
    }

    private void updateSupplierStatusForYes(Long projectId) {
        SscProjectPO sscProjectPO = this.sscProjectDAO.selectByPrimaryKey(projectId);
        List<Long> supplierIds = this.sscProjectTempResultSupplierDAO.getSupplierIdByProjectId(projectId);
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode("temp_result_approval_yes_for_supplier");
        whereStatusCirculationConfPO.setPurchaseMode(sscProjectPO.getPurchaseMode());
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        HashMap<Integer, SscStatusCirculationConfPO> sscStatusCirculationConfPOMap = new HashMap<Integer, SscStatusCirculationConfPO>();
        for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            sscStatusCirculationConfPOMap.put(Integer.valueOf(po.getOtherParam()), po);
        }
        SscStatusCirculationConfPO SscStatusCirculationConfPOForYes = (SscStatusCirculationConfPO)sscStatusCirculationConfPOMap.get(0);
        ArrayList<String> oldStatussForYes = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)SscStatusCirculationConfPOForYes.getOldStatus())) {
            if (SscStatusCirculationConfPOForYes.getOldStatus().contains(",")) {
                oldStatussForYes = Arrays.asList(SscStatusCirculationConfPOForYes.getOldStatus().split(","));
            } else {
                oldStatussForYes.add(SscStatusCirculationConfPOForYes.getOldStatus());
            }
        }
        SscProjectSupplierPO whwereProjectSupplierPOForYes = new SscProjectSupplierPO();
        whwereProjectSupplierPOForYes.setProjectId(projectId);
        whwereProjectSupplierPOForYes.setSupplierIds(supplierIds);
        whwereProjectSupplierPOForYes.setOldSupplierStatuss(oldStatussForYes);
        whwereProjectSupplierPOForYes.setSupplierStatus(SscStatusCirculationConfPOForYes.getNewStatus());
        int isUpdate = this.sscProjectSupplierDAO.updateByCondition(whwereProjectSupplierPOForYes);
        if (isUpdate != supplierIds.size()) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
        }
        SscStatusCirculationConfPO SscStatusCirculationConfPOForNo = (SscStatusCirculationConfPO)sscStatusCirculationConfPOMap.get(1);
        List<String> oldStatussForNo = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)SscStatusCirculationConfPOForNo.getOldStatus())) {
            if (SscStatusCirculationConfPOForNo.getOldStatus().contains(",")) {
                oldStatussForNo = Arrays.asList(SscStatusCirculationConfPOForNo.getOldStatus().split(","));
            } else {
                oldStatussForNo.add(SscStatusCirculationConfPOForNo.getOldStatus());
            }
        }
        SscProjectSupplierPO whwereProjectSupplierPOForNo = new SscProjectSupplierPO();
        whwereProjectSupplierPOForNo.setProjectId(projectId);
        whwereProjectSupplierPOForNo.setOldSupplierStatuss(oldStatussForNo);
        whwereProjectSupplierPOForNo.setSupplierStatus(SscStatusCirculationConfPOForNo.getNewStatus());
        int isUpdate2 = this.sscProjectSupplierDAO.updateByCondition(whwereProjectSupplierPOForNo);
    }

    private List<SscSupplierAdviceNotePO> insertSupplierAdviceNote(Long projectId, SscTempResultApprovalBusiReqBO busiReqBO) {
        ArrayList<SscSupplierAdviceNotePO> insertPOs = new ArrayList<SscSupplierAdviceNotePO>();
        SscProjectTempResultDetailPO wherePO = new SscProjectTempResultDetailPO();
        wherePO.setProjectId(projectId);
        List<SscProjectTempResultDetailPO> sscProjectTempResultDetailPOs = this.sscProjectTempResultDetailDAO.getList(wherePO);
        if (!CollectionUtils.isEmpty(sscProjectTempResultDetailPOs)) {
            HashMap<Long, String> supplierMap = new HashMap<Long, String>();
            for (SscProjectTempResultDetailPO sscProjectTempResultDetailPO : sscProjectTempResultDetailPOs) {
                supplierMap.put(sscProjectTempResultDetailPO.getSupplierId(), sscProjectTempResultDetailPO.getSupplierName());
            }
            Map<String, String> adviceNoteTemplateCodeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "ADVICE_NOTE_TEMPLATE_CODE");
            for (Long supplierId : supplierMap.keySet()) {
                SscSupplierAdviceNotePO sscSupplierAdviceNotePO = new SscSupplierAdviceNotePO();
                sscSupplierAdviceNotePO.setSupplierAdviceNoteId(Sequence.getInstance().nextId());
                sscSupplierAdviceNotePO.setProjectId(projectId);
                sscSupplierAdviceNotePO.setAdviceNoteTitle("\u4e2d\u6807\u901a\u77e5\u4e66");
                sscSupplierAdviceNotePO.setAdviceNoteType("1");
                sscSupplierAdviceNotePO.setAdviceNoteTemplateCode(adviceNoteTemplateCodeMap.get("1"));
                sscSupplierAdviceNotePO.setOperNo(busiReqBO.getOperId());
                sscSupplierAdviceNotePO.setOperName(busiReqBO.getOperName());
                sscSupplierAdviceNotePO.setOperTime(new Date());
                sscSupplierAdviceNotePO.setSupplierId(supplierId);
                sscSupplierAdviceNotePO.setSupplierName((String)supplierMap.get(supplierId));
                insertPOs.add(sscSupplierAdviceNotePO);
            }
            int n = this.sscSupplierAdviceNoteDAO.insertBatch(insertPOs);
            if (n != supplierMap.keySet().size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u4f9b\u5e94\u5546\u901a\u77e5\u4e66\u8868\u5931\u8d25\uff01");
            }
        }
        return insertPOs;
    }

    private void updateTempResultStatus(Long projectId, Integer auditResult) {
        SscProjectTempResultPO wherePO = new SscProjectTempResultPO();
        wherePO.setProjectId(projectId);
        SscProjectTempResultPO sscProjectTempResultPO = this.sscProjectTempResultDAO.getModeyBy(wherePO);
        if (null == sscProjectTempResultPO) {
            throw new BusinessException("8888", "\u62df\u5b9a\u7ed3\u679c\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (!"0".equals(sscProjectTempResultPO.getTempResultStatus())) {
            throw new BusinessException("8888", "\u5f53\u524d\u9879\u76ee\u62df\u5b9a\u7ed3\u679c\u4e0d\u662f\u5f85\u5ba1\u6279\u72b6\u6001\uff01");
        }
        SscProjectTempResultPO updatePO = new SscProjectTempResultPO();
        updatePO.setTempResultId(sscProjectTempResultPO.getTempResultId());
        if (0 == auditResult) {
            updatePO.setTempResultStatus("1");
        } else if (1 == auditResult) {
            updatePO.setTempResultStatus("2");
        }
        int isUpdate = this.sscProjectTempResultDAO.updateByPrimaryKeySelective(updatePO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u62df\u5b9a\u7ed3\u679c\u8868\u5931\u8d25\uff01");
        }
    }

    private Boolean invokeProcess(SscTempResultApprovalBusiReqBO busiReqBO, String stepId) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setObjId(busiReqBO.getToApprovalIds());
        uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(busiReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(busiReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setOperId(busiReqBO.getOperId().toString());
        uacNoTaskAuditOrderAuditReqBO.setUsername(busiReqBO.getOperName());
        uacNoTaskAuditOrderAuditReqBO.setOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditOrderAuditReqBO.setObjType(SscCommConstant.AuditObjType.PROJECT_TEMP_RESULT_AUDIT);
        uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }

    private Map<String, Set<Long>> validProjectInfo(SscTempResultApprovalBusiReqBO busiReqBO, Set<Long> toApprovalIds) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        SscProjectPO whereProjectPO = new SscProjectPO();
        whereProjectPO.setProjectIds(busiReqBO.getProjectIds());
        List<SscProjectPO> sscProjectPOs = this.sscProjectDAO.getList(whereProjectPO);
        if (CollectionUtils.isEmpty(sscProjectPOs)) {
            throw new BusinessException("8888", "\u9879\u76ee\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        HashSet<Long> statusErrors = new HashSet<Long>();
        HashSet<Long> projectIds = new HashSet<Long>();
        for (SscProjectPO po : sscProjectPOs) {
            if (!"15".equals(po.getProjectStatus())) {
                statusErrors.add(po.getProjectId());
            }
            projectIds.add(po.getProjectId());
        }
        if (statusErrors.size() > 0) {
            throw new BusinessException("8888", "\u9879\u76ee\u3010" + ((Object)statusErrors).toString() + "\u3011\u72b6\u6001\u4e0d\u662f\u5ba1\u6838\u4e2d");
        }
        if (projectIds.size() < busiReqBO.getProjectIds().size()) {
            busiReqBO.getProjectIds().removeAll(projectIds);
            throw new BusinessException("8888", "\u9879\u76ee\u3010" + busiReqBO.getProjectIds() + "\u3011\u4e0d\u5b58\u5728");
        }
        SscAuditPO sscAuditPO = new SscAuditPO();
        sscAuditPO.setObjType(SscCommConstant.AuditObjType.PROJECT_TEMP_RESULT_AUDIT);
        sscAuditPO.setObjIds(toApprovalIds);
        sscAuditPO.setTabValue(1);
        sscAuditPO.setStationCodes(busiReqBO.getStationCodes());
        List<SscAuditBO> sscAuditBOs = this.sscAuditDAO.getAuditInfoByObjIds(sscAuditPO);
        if (CollectionUtils.isEmpty(sscAuditBOs)) {
            throw new BusinessException("8888", "\u9879\u76ee\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        HashSet stepIds = new HashSet();
        HashSet<Long> auditSize = new HashSet<Long>();
        Object stepId = null;
        for (SscAuditBO bo : sscAuditBOs) {
            HashSet<Long> projectIdSet = (HashSet<Long>)result.get(bo.getStepId());
            if (null == projectIdSet) {
                projectIdSet = new HashSet<Long>();
            }
            projectIdSet.add(bo.getObjId());
            result.put(bo.getStepId(), projectIdSet);
            auditSize.add(bo.getObjId());
        }
        if (auditSize.size() < busiReqBO.getProjectIds().size()) {
            busiReqBO.getProjectIds().removeAll(auditSize);
            throw new BusinessException("8888", "\u9879\u76ee\u3010" + busiReqBO.getProjectIds() + "\u3011\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        return result;
    }

    private Map<Long, Long> getToAudiId(List<Long> projectIds) {
        HashMap<Long, Long> auditProjectMap = new HashMap<Long, Long>();
        SscProjectApprovalPO wherePO = new SscProjectApprovalPO();
        wherePO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_TEMP_RESULT_AUDIT);
        wherePO.setProjectIds(projectIds);
        List<SscProjectApprovalPO> toApprovalIds = this.sscProjectApprovalDAO.getToApprovalIds(wherePO);
        if (toApprovalIds.size() != projectIds.size()) {
            throw new BusinessException("8888", "\u5b58\u5728\u9879\u76eeId\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5ba1\u6279\u5355\u5173\u8054Id!");
        }
        for (SscProjectApprovalPO po : toApprovalIds) {
            auditProjectMap.put(po.getToApprovalId(), po.getProjectId());
        }
        return auditProjectMap;
    }
}

