/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.common.SscProjectNoticeBO;
import com.tydic.ssc.dao.SscProjectNoticeExtDAO;
import com.tydic.ssc.dao.po.SscProjectNoticeExtPO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryNoticeDetailBusiService;
import com.tydic.ssc.service.busi.bo.SscQryNoticeDetailBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryNoticeDetailBusiRspBO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQryNoticeDetailBusiServiceImpl
implements SscQryNoticeDetailBusiService {
    @Autowired
    private SscProjectNoticeExtDAO sscProjectNoticeExtDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryNoticeDetailBusiRspBO qryNoticeDetail(SscQryNoticeDetailBusiReqBO reqBO) {
        SscProjectNoticeBO noticeBO = this.sscProjectNoticeExtDAO.selectNotice(reqBO);
        List<SscProjectNoticeExtPO> noticeExtPOS = this.sscProjectNoticeExtDAO.selectNoticeExt(reqBO);
        SscQryNoticeDetailBusiRspBO rspBO = new SscQryNoticeDetailBusiRspBO();
        if (noticeBO == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u516c\u544a\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isNotEmpty(noticeExtPOS)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (SscProjectNoticeExtPO extPO : noticeExtPOS) {
                map.put(extPO.getExtCode(), extPO.getExtValue());
            }
            noticeBO.setNoticeExtMap(map);
        }
        Map<String, String> noticeTypeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "NOTICE_TYPE");
        Map<String, String> tenderMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
        Map<String, String> purchaseMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> isAuditMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "ISAUDIT");
        Map<String, String> isPublicBidMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "ISPUBLICBIDNET");
        Map<String, String> isPublicMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "ISPUBLIC");
        if (StringUtils.isNotBlank((CharSequence)noticeBO.getIsAudit())) {
            noticeBO.setIsAuditStr(isAuditMap.get(noticeBO.getIsAudit()));
        }
        if (StringUtils.isNotBlank((CharSequence)noticeBO.getIsPublic())) {
            noticeBO.setIsPublicStr(isPublicMap.get(noticeBO.getIsPublic()));
        }
        if (StringUtils.isNotBlank((CharSequence)noticeBO.getIsPublicBidNet())) {
            noticeBO.setIsPublicBidNetStr(isPublicBidMap.get(noticeBO.getIsPublicBidNet()));
        }
        if (StringUtils.isNotBlank((CharSequence)noticeBO.getNoticeType())) {
            noticeBO.setNoticeTypeStr(noticeTypeMap.get(noticeBO.getNoticeType()));
        }
        if (StringUtils.isNotBlank((CharSequence)noticeBO.getTenderMode())) {
            noticeBO.setTenderModeStr(tenderMap.get(noticeBO.getTenderMode()));
        }
        if (StringUtils.isNotBlank((CharSequence)noticeBO.getPurchaseMode())) {
            noticeBO.setPurchaseModeStr(purchaseMap.get(noticeBO.getPurchaseMode()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u516c\u544a\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        rspBO.setSscProjectNoticeBO(noticeBO);
        return rspBO;
    }
}

