/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectNoticeInfoBO;
import com.tydic.ssc.common.SscQryProjectNoticeBO;
import com.tydic.ssc.dao.SscProjectNoticeDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryProjectNoticeListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryNoticeListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProjectNoticeListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProjectNoticeListBusiRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscQryProjectNoticeListBusiServiceImpl
implements SscQryProjectNoticeListBusiService {
    @Autowired
    private SscProjectNoticeDAO sscProjectNoticeDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryProjectNoticeListBusiRspBO qryProjectNoticeList(SscQryProjectNoticeListBusiReqBO reqBO) {
        List<SscProjectNoticeInfoBO> noticeList;
        SscQryProjectNoticeListBusiRspBO rspBO = new SscQryProjectNoticeListBusiRspBO();
        ArrayList<SscQryProjectNoticeBO> rows = new ArrayList<SscQryProjectNoticeBO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SscQryNoticeListBusiReqBO qryParam = new SscQryNoticeListBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)qryParam));
        if (StringUtils.isEmpty((Object)reqBO.getPurchaseMode())) {
            qryParam.setPurchaseMode("1");
        }
        if (CollectionUtils.isEmpty(noticeList = this.sscProjectNoticeDAO.getNoticeList(qryParam, (Page<SscProjectNoticeInfoBO>)page))) {
            rspBO.setPageNo(0);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u9879\u76ee\u516c\u544a\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        Map<String, String> projectNoticeTypeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_NOTICE_TYPE");
        Map<String, String> purchaserModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
        for (SscProjectNoticeInfoBO bo : noticeList) {
            SscQryProjectNoticeBO noticeBO = new SscQryProjectNoticeBO();
            BeanUtils.copyProperties((Object)bo, (Object)noticeBO);
            if (!StringUtils.isEmpty((Object)bo.getNoticeType())) {
                noticeBO.setNoticeTypeStr(projectNoticeTypeMap.get(bo.getNoticeType()));
            }
            if (!StringUtils.isEmpty((Object)bo.getPurchaseMode())) {
                noticeBO.setPurchaseModeStr(purchaserModeMap.get(bo.getPurchaseMode()));
            }
            if (!StringUtils.isEmpty((Object)bo.getTenderMode())) {
                noticeBO.setTenderModeStr(tenderModeMap.get(bo.getTenderMode()));
            }
            rows.add(noticeBO);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u516c\u544a\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

