/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscCirculationInfoDAO;
import com.tydic.ssc.dao.SscProfessorChngDAO;
import com.tydic.ssc.dao.SscProfessorDAO;
import com.tydic.ssc.dao.SscProfessorResumeChngDAO;
import com.tydic.ssc.dao.SscProfessorResumeDAO;
import com.tydic.ssc.dao.po.SscCirculationInfoPO;
import com.tydic.ssc.dao.po.SscProfessorPO;
import com.tydic.ssc.dao.po.SscProfessorResumePO;
import com.tydic.ssc.service.busi.SscCirculationInfoAddBusiService;
import com.tydic.ssc.service.busi.SscProfessorApprovalBusiService;
import com.tydic.ssc.service.busi.bo.SscCirculationInfoAddBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscCirculationInfoAddBusiRspBO;
import com.tydic.ssc.service.busi.bo.SscProfessorApprovalBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscProfessorApprovalBusiRspBO;
import com.tydic.ssc.service.busi.bo.SscUpdateProfessorBusiReqBO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscProfessorApprovalBusiServiceImpl
implements SscProfessorApprovalBusiService {
    @Autowired
    private SscProfessorDAO sscProfessorDAO;
    @Autowired
    private SscProfessorChngDAO sscProfessorChngDAO;
    @Autowired
    private SscProfessorResumeDAO sscProfessorResumeDAO;
    @Autowired
    private SscProfessorResumeChngDAO sscProfessorResumeChngDAO;
    @Autowired
    private SscCirculationInfoDAO sscCirculationInfoDAO;
    @Autowired
    private SscCirculationInfoAddBusiService sscCirculationInfoAddBusiService;

    @Override
    public SscProfessorApprovalBusiRspBO dealProfessorApproval(SscProfessorApprovalBusiReqBO reqBO) {
        SscProfessorApprovalBusiRspBO rspBO = new SscProfessorApprovalBusiRspBO();
        SscProfessorPO auditParam = new SscProfessorPO();
        auditParam.setProfessorIds(reqBO.getProfessorIds());
        auditParam.setObjType(SscCommConstant.AuditObjType.PROFESSOR_AUDIT);
        List<SscProfessorPO> sscProfessorPOS = this.sscProfessorChngDAO.getListTask(auditParam);
        this.checkSscProfessorPOS(sscProfessorPOS);
        this.updateProfessorInfo(sscProfessorPOS, reqBO);
        this.addCirculationInfo(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4e13\u5bb6\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void checkSscProfessorPOS(List<SscProfessorPO> sscProfessorPOS) {
        if (CollectionUtils.isEmpty(sscProfessorPOS)) {
            throw new BusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        sscProfessorPOS.stream().forEach(po -> {
            if (!po.getProfessorStatus().equals("1")) {
                throw new BusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u5ba1\u6838\u4e2d\u624d\u80fd\u8fdb\u884c\u5ba1\u6838");
            }
        });
    }

    private void updateProfessorInfo(List<SscProfessorPO> sscProfessorPOS, SscProfessorApprovalBusiReqBO reqBO) {
        for (SscProfessorPO po : sscProfessorPOS) {
            int updateChngResult;
            SscUpdateProfessorBusiReqBO updateParam = new SscUpdateProfessorBusiReqBO();
            BeanUtils.copyProperties((Object)po, (Object)((Object)updateParam));
            updateParam.setUpdateId(reqBO.getMemIdIn());
            updateParam.setUpdateName(reqBO.getName());
            updateParam.setUpdateTime(new Date());
            if (reqBO.getAuditResult().equals(0)) {
                updateParam.setProfessorStatus("3");
            }
            if (reqBO.getAuditResult().equals(1)) {
                updateParam.setProfessorStatus("2");
            }
            if ((updateChngResult = this.sscProfessorChngDAO.updateByCondition(updateParam)) < 1) {
                throw new BusinessException("8888", "\u66f4\u65b0\u4e13\u5bb6\u4fe1\u606f\u4fee\u6539\u8868\u5931\u8d25");
            }
            if (reqBO.getAuditResult().equals(0)) {
                int updateResult = this.sscProfessorDAO.updateByCondition(updateParam);
                if (updateResult < 1) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e13\u5bb6\u4fe1\u606f\u8868\u5931\u8d25");
                }
                SscProfessorResumePO qryResume = new SscProfessorResumePO();
                qryResume.setProfessorId(po.getProfessorId());
                List<SscProfessorResumePO> qryResult = this.sscProfessorResumeChngDAO.getList(qryResume);
                if (!CollectionUtils.isEmpty(qryResult)) {
                    SscProfessorResumePO sscProfessorResumePO = new SscProfessorResumePO();
                    sscProfessorResumePO.setProfessorId(po.getProfessorId());
                    this.sscProfessorResumeDAO.deleteBy(sscProfessorResumePO);
                    this.sscProfessorResumeDAO.insertBatch(qryResult);
                }
            }
            if (!reqBO.getAuditResult().equals(1)) continue;
            SscProfessorResumePO sscProfessorResumePO = new SscProfessorResumePO();
            sscProfessorResumePO.setProfessorId(po.getProfessorId());
            this.sscProfessorResumeDAO.deleteBy(sscProfessorResumePO);
        }
    }

    private void addCirculationInfo(SscProfessorApprovalBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getProfessorIds())) {
            List<Long> professorIds = reqBO.getProfessorIds();
            for (Long professorId : professorIds) {
                SscCirculationInfoPO qryCirculationInfo = new SscCirculationInfoPO();
                qryCirculationInfo.setRelationId(professorId);
                SscCirculationInfoPO qryResult = this.sscCirculationInfoDAO.getNewByRelationId(qryCirculationInfo);
                SscCirculationInfoAddBusiReqBO circulationInfoAddBusiReqBO = new SscCirculationInfoAddBusiReqBO();
                circulationInfoAddBusiReqBO.setRelationType(2);
                circulationInfoAddBusiReqBO.setRelationId(professorId);
                circulationInfoAddBusiReqBO.setOperLink("\u5ba1\u6838\u4e13\u5bb6\u4fe1\u606f");
                circulationInfoAddBusiReqBO.setOperAction("\u5ba1\u6838");
                circulationInfoAddBusiReqBO.setCreateNo(reqBO.getMemIdIn());
                circulationInfoAddBusiReqBO.setCreateTime(qryResult.getUpdateTime());
                circulationInfoAddBusiReqBO.setUpdateNo(reqBO.getMemIdIn());
                circulationInfoAddBusiReqBO.setUpdateTime(new Date());
                circulationInfoAddBusiReqBO.setAuditStatus(reqBO.getAuditResult());
                circulationInfoAddBusiReqBO.setIsDel(0);
                circulationInfoAddBusiReqBO.setRemark(reqBO.getAuditAdvice());
                circulationInfoAddBusiReqBO.setUnitId(reqBO.getCompanyId());
                circulationInfoAddBusiReqBO.setUnitName(reqBO.getCompanyName());
                SscCirculationInfoAddBusiRspBO sscCirculationInfoAddBusiRspBO = this.sscCirculationInfoAddBusiService.addCirculationInfo(circulationInfoAddBusiReqBO);
                if (sscCirculationInfoAddBusiRspBO.getRespCode().equals("0000")) continue;
                throw new BusinessException("8888", "\u4e13\u5bb6\u4fe1\u606f\u5ba1\u6838\u6d41\u8f6c\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
    }
}

