/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscContractPayTypeBO;
import com.tydic.ssc.common.SscContractWaitAddInfoBO;
import com.tydic.ssc.common.SscContractWaitAddItemSyncBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscProjectTempResultDetailDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscProjectTempResultDetailPO;
import com.tydic.ssc.service.busi.SscQryContractWaitAddInfoBusiService;
import com.tydic.ssc.service.busi.bo.SscQryContractWaitAddInfoBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryContractWaitAddInfoBusiRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQryContractWaitAddInfoBusiServiceImpl
implements SscQryContractWaitAddInfoBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectTempResultDetailDAO sscProjectTempResultDetailDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;

    @Override
    public SscQryContractWaitAddInfoBusiRspBO qryContractWaitAddInfo(SscQryContractWaitAddInfoBusiReqBO busiReqBO) {
        SscQryContractWaitAddInfoBusiRspBO rsp = new SscQryContractWaitAddInfoBusiRspBO();
        SscProjectPO projectPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        if (null == projectPO) {
            throw new BusinessException("8888", "\u67e5\u8be2\u9879\u76ee\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (!"16".equals(projectPO.getProjectStatus())) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee\u4e0d\u662f\u5df2\u5b9a\u6807\u72b6\u6001\uff01\uff01");
        }
        List<SscContractWaitAddItemSyncBO> sscContractWaitAddItemSyncBOS = this.getContractWaitAddItem(busiReqBO.getProjectId());
        HashSet<Long> supplierSet = new HashSet<Long>();
        for (SscContractWaitAddItemSyncBO bo : sscContractWaitAddItemSyncBOS) {
            supplierSet.add(bo.getSupplierId());
            bo.setBugetUnitPrice(this.moneyChange(bo.getBugetUnitPriceLong()));
            bo.setHistoryUnitPrice(this.moneyChange(bo.getHistoryUnitPriceLong()));
            bo.setTaxUnitPrice(this.moneyChange(bo.getTaxUnitPriceLong()));
            bo.setQuotationUnitPrice(this.moneyChange(bo.getQuotationUnitPriceLong()));
            bo.setBidTaxAmount(this.moneyChange(bo.getBidTaxAmountLong()));
            bo.setBidNoTaxAmount(this.moneyChange(bo.getBidNoTaxAmountLong()));
        }
        Map<String, List<SscContractWaitAddItemSyncBO>> supPlanItemMap = this.dealItems(sscContractWaitAddItemSyncBOS);
        List<SscContractWaitAddInfoBO> waitAddInfoList = this.assembleData(supPlanItemMap, projectPO, supplierSet);
        rsp.setWaitAddInfoList(waitAddInfoList);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5f85\u65b0\u589e\u5408\u540c\u63a8\u9001\u4fe1\u606f\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private List<SscContractWaitAddInfoBO> assembleData(Map<String, List<SscContractWaitAddItemSyncBO>> supPlanItemMap, SscProjectPO projectPO, Set<Long> supplierSet) {
        ArrayList<SscContractWaitAddInfoBO> waitAddInfoList = new ArrayList<SscContractWaitAddInfoBO>();
        Map<Long, SscProjectSupplierPO> supplierPorjectMap = this.getProjectSupplierInfo(projectPO.getProjectId(), supplierSet);
        for (String key : supPlanItemMap.keySet()) {
            List<SscContractWaitAddItemSyncBO> sscContractWaitAddItemSyncBOS = supPlanItemMap.get(key);
            String planCode = sscContractWaitAddItemSyncBOS.get(0).getPlanProjectNo();
            Long supplierId = sscContractWaitAddItemSyncBOS.get(0).getSupplierId();
            String supplierName = sscContractWaitAddItemSyncBOS.get(0).getSupplierName();
            SscProjectSupplierPO sscProjectSupplierPO = supplierPorjectMap.get(supplierId);
            Long amount = 0L;
            for (SscContractWaitAddItemSyncBO bo : sscContractWaitAddItemSyncBOS) {
                amount = amount + bo.getBidTaxAmountLong();
            }
            List payModes = JSON.parseArray((String)sscProjectSupplierPO.getPayMode(), String.class);
            List<String> payModeShows = Arrays.asList(sscProjectSupplierPO.getPayModeShow().split(";"));
            SscContractWaitAddInfoBO sscContractWaitAddInfoBO = new SscContractWaitAddInfoBO();
            sscContractWaitAddInfoBO.setSource(Integer.valueOf(projectPO.getPurchaseMode()));
            sscContractWaitAddInfoBO.setProjectCode(projectPO.getProjectNo());
            sscContractWaitAddInfoBO.setProjectName(projectPO.getProjectName());
            sscContractWaitAddInfoBO.setPlanCode(planCode);
            sscContractWaitAddInfoBO.setNeedArriveTime(null);
            sscContractWaitAddInfoBO.setSupplierId(supplierId);
            sscContractWaitAddInfoBO.setSupplierName(supplierName);
            sscContractWaitAddInfoBO.setSupplierContactName(sscProjectSupplierPO.getSupplierLinkMan());
            sscContractWaitAddInfoBO.setSupplierContactPhone(sscProjectSupplierPO.getSupplierLinkPhone());
            sscContractWaitAddInfoBO.setPurchaserId(projectPO.getPurchaseUnitId());
            sscContractWaitAddInfoBO.setPurchaserName(projectPO.getPurchaseUnitName());
            sscContractWaitAddInfoBO.setPurchaserContact(null);
            sscContractWaitAddInfoBO.setPurchaserContactPhone(null);
            sscContractWaitAddInfoBO.setAmount(amount);
            sscContractWaitAddInfoBO.setAmountMoney(this.moneyChange(amount));
            sscContractWaitAddInfoBO.setPayRatioCode(sscProjectSupplierPO.getTradeMode());
            sscContractWaitAddInfoBO.setPayRatioStr(sscProjectSupplierPO.getTradeModeShow());
            sscContractWaitAddInfoBO.setExpectSettleCode(sscProjectSupplierPO.getExpecSettleMethod());
            sscContractWaitAddInfoBO.setExpectSettleStr(null);
            if (null != sscProjectSupplierPO.getExpecSettleDay()) {
                sscContractWaitAddInfoBO.setSettleDay(sscProjectSupplierPO.getExpecSettleDay().toString());
            }
            if (null != sscProjectSupplierPO.getPrePay()) {
                sscContractWaitAddInfoBO.setPrePay(Long.valueOf(sscProjectSupplierPO.getPrePay().longValue()));
            }
            if (null != sscProjectSupplierPO.getPilPay()) {
                sscContractWaitAddInfoBO.setDeliveryPay(Long.valueOf(sscProjectSupplierPO.getPilPay().longValue()));
            }
            if (null != sscProjectSupplierPO.getVerPay()) {
                sscContractWaitAddInfoBO.setInvoicePay(Long.valueOf(sscProjectSupplierPO.getVerPay().longValue()));
            }
            sscContractWaitAddInfoBO.setQuaAmountType(Integer.valueOf(1));
            if (null != sscProjectSupplierPO.getQualityMoney()) {
                sscContractWaitAddInfoBO.setQuaAmount(Long.valueOf(sscProjectSupplierPO.getQualityMoney().longValue()));
            }
            sscContractWaitAddInfoBO.setGuaranteePeriod(sscProjectSupplierPO.getQualityPeriod());
            ArrayList<SscContractPayTypeBO> payTypes = new ArrayList<SscContractPayTypeBO>();
            for (int i = 0; i < payModes.size(); ++i) {
                SscContractPayTypeBO sscContractPayTypeBO = new SscContractPayTypeBO();
                sscContractPayTypeBO.setPayType((String)payModes.get(i));
                sscContractPayTypeBO.setPayTypeStr(payModeShows.get(i));
                payTypes.add(sscContractPayTypeBO);
            }
            sscContractWaitAddInfoBO.setPayTypes(payTypes);
            sscContractWaitAddInfoBO.setItemList(sscContractWaitAddItemSyncBOS);
            sscContractWaitAddInfoBO.setProjectId(projectPO.getProjectId());
            waitAddInfoList.add(sscContractWaitAddInfoBO);
        }
        return waitAddInfoList;
    }

    private BigDecimal moneyChange(Long amount) {
        try {
            BigDecimal money = MoneyUtils.Long2BigDecimal((Long)amount);
            return money;
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff01");
        }
    }

    private Map<Long, SscProjectSupplierPO> getProjectSupplierInfo(Long projectId, Set<Long> supplierSet) {
        HashMap<Long, SscProjectSupplierPO> supplierPorjectMap = new HashMap<Long, SscProjectSupplierPO>();
        SscProjectSupplierPO wherePO = new SscProjectSupplierPO();
        wherePO.setProjectId(projectId);
        wherePO.setSupplierIds(new ArrayList<Long>(supplierSet));
        List<SscProjectSupplierPO> sscProjectSupplierPOs = this.sscProjectSupplierDAO.getList(wherePO);
        if (CollectionUtils.isEmpty(sscProjectSupplierPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u9879\u76ee\u4f9b\u5e94\u5546\u8868\u4e3a\u7a7a");
        }
        for (SscProjectSupplierPO po : sscProjectSupplierPOs) {
            supplierPorjectMap.put(po.getSupplierId(), po);
        }
        return supplierPorjectMap;
    }

    private Map<String, List<SscContractWaitAddItemSyncBO>> dealItems(List<SscContractWaitAddItemSyncBO> sscContractWaitAddItemSyncBOS) {
        HashMap<String, List<SscContractWaitAddItemSyncBO>> supPlanItemMap = new HashMap<String, List<SscContractWaitAddItemSyncBO>>();
        for (SscContractWaitAddItemSyncBO bo : sscContractWaitAddItemSyncBOS) {
            String key;
            ArrayList<SscContractWaitAddItemSyncBO> oldItems;
            if (StringUtils.isBlank((CharSequence)bo.getPlanProjectNo())) {
                bo.setPlanProjectNo("default");
            }
            if (CollectionUtils.isEmpty((Collection)(oldItems = (ArrayList<SscContractWaitAddItemSyncBO>)supPlanItemMap.get(key = bo.getSupplierId() + "_" + bo.getPlanProjectNo())))) {
                oldItems = new ArrayList<SscContractWaitAddItemSyncBO>();
            }
            oldItems.add(bo);
            supPlanItemMap.put(key, oldItems);
        }
        return supPlanItemMap;
    }

    private List<SscContractWaitAddItemSyncBO> getContractWaitAddItem(Long projectId) {
        SscProjectTempResultDetailPO wherePO = new SscProjectTempResultDetailPO();
        wherePO.setProjectId(projectId);
        List<SscContractWaitAddItemSyncBO> sscContractWaitAddItemSyncBOS = this.sscProjectTempResultDetailDAO.getListWithProjectAndQuotationDetail(wherePO);
        if (CollectionUtils.isEmpty(sscContractWaitAddItemSyncBOS)) {
            throw new BusinessException("8888", "\u62df\u5b9a\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        return sscContractWaitAddItemSyncBOS;
    }
}

