/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProfessorStageDAO;
import com.tydic.ssc.dao.SscProjectBidRoundDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscStatusCirculationConfDAO;
import com.tydic.ssc.dao.po.SscProjectBidRoundPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscStatusCirculationConfPO;
import com.tydic.ssc.service.busi.SscUpdateProjectStatusTimeBusiService;
import com.tydic.ssc.service.busi.bo.SscUpdateProjectStatusTimeBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscUpdateProjectStatusTimeBusiRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscUpdateProjectStatusTimeBusiServiceImpl
implements SscUpdateProjectStatusTimeBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscStatusCirculationConfDAO sscStatusCirculationConfDAO;
    @Autowired
    private SscProjectBidRoundDAO sscProjectBidRoundDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProfessorStageDAO sscProfessorStageDAO;

    @Override
    public SscUpdateProjectStatusTimeBusiRspBO updateProjectStatus(SscUpdateProjectStatusTimeBusiReqBO busiReqBO) {
        SscUpdateProjectStatusTimeBusiRspBO rsp = new SscUpdateProjectStatusTimeBusiRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9879\u76ee\u72b6\u6001\u6d41\u8f6c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff01");
        switch (busiReqBO.getCirculationType()) {
            case "1": {
                this.updateProjectStatusForApplyEnd(busiReqBO);
                break;
            }
            case "2": {
                this.updateProjectStatusForBidEnd(busiReqBO);
                break;
            }
            case "3": {
                this.updateProjectBidRoundStatus(busiReqBO);
                break;
            }
            case "4": {
                this.updateProjectStatusForBidStart(busiReqBO);
                break;
            }
        }
        return rsp;
    }

    private void updateProjectStatusForBidStart(SscUpdateProjectStatusTimeBusiReqBO busiReqBO) {
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
        whereStatusCirculationConfPO.setChangeTable("1");
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            SscProjectPO whereProjectPO = new SscProjectPO();
            whereProjectPO.setProjectStatus(po.getOldStatus());
            whereProjectPO.setBidStartTime(busiReqBO.getQryTime());
            whereProjectPO.setPurchaseMode(po.getPurchaseMode());
            List<Long> projectIds = this.sscProjectDAO.getListForTime(whereProjectPO);
            if (CollectionUtils.isEmpty(projectIds)) continue;
            SscProjectPO updateProjectPO = new SscProjectPO();
            updateProjectPO.setProjectIds(projectIds);
            updateProjectPO.setProjectStatus(po.getNewStatus());
            int isUpdate = this.sscProjectDAO.updateByPrimaryKeySelective(updateProjectPO);
            if (isUpdate != projectIds.size()) {
                throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
            }
            SscStatusCirculationConfPO whereStatusCirculationConfPOForSupplier = new SscStatusCirculationConfPO();
            whereStatusCirculationConfPOForSupplier.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
            whereStatusCirculationConfPOForSupplier.setChangeTable("3");
            whereStatusCirculationConfPOForSupplier.setPurchaseMode(po.getPurchaseMode());
            SscStatusCirculationConfPO sscStatusCirculationConfPOForSupplier = this.sscStatusCirculationConfDAO.getModelBy(whereStatusCirculationConfPOForSupplier);
            if (null == sscStatusCirculationConfPOForSupplier) {
                throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            List<String> oldSupplierStatuss = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)sscStatusCirculationConfPOForSupplier.getOldStatus())) {
                if (sscStatusCirculationConfPOForSupplier.getOldStatus().contains(",")) {
                    oldSupplierStatuss = Arrays.asList(sscStatusCirculationConfPOForSupplier.getOldStatus().split(","));
                } else {
                    oldSupplierStatuss.add(sscStatusCirculationConfPOForSupplier.getOldStatus());
                }
            }
            SscProjectSupplierPO updateSupplierPO = new SscProjectSupplierPO();
            updateSupplierPO.setProjectIds(projectIds);
            updateSupplierPO.setOldSupplierStatuss(oldSupplierStatuss);
            updateSupplierPO.setSupplierStatus(sscStatusCirculationConfPOForSupplier.getNewStatus());
            int n = this.sscProjectSupplierDAO.updateByCondition(updateSupplierPO);
        }
    }

    private void updateProjectStatusForBidEnd(SscUpdateProjectStatusTimeBusiReqBO busiReqBO) {
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
        whereStatusCirculationConfPO.setChangeTable("1");
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            SscProjectPO whereProjectPO = new SscProjectPO();
            whereProjectPO.setProjectStatus(po.getOldStatus());
            whereProjectPO.setBidEndTime(busiReqBO.getQryTime());
            whereProjectPO.setPurchaseMode(po.getPurchaseMode());
            List<Long> projectIds = this.sscProjectDAO.getListForTime(whereProjectPO);
            if (CollectionUtils.isEmpty(projectIds)) continue;
            SscProjectPO updateProjectPO = new SscProjectPO();
            updateProjectPO.setProjectIds(projectIds);
            updateProjectPO.setProjectStatus(po.getNewStatus());
            int isUpdate = this.sscProjectDAO.updateByPrimaryKeySelective(updateProjectPO);
            if (isUpdate != projectIds.size()) {
                throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
            }
            SscStatusCirculationConfPO whereStatusCirculationConfPOForSupplier = new SscStatusCirculationConfPO();
            whereStatusCirculationConfPOForSupplier.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
            whereStatusCirculationConfPOForSupplier.setChangeTable("3");
            whereStatusCirculationConfPOForSupplier.setPurchaseMode(po.getPurchaseMode());
            List<SscStatusCirculationConfPO> sscStatusCirculationConfPOForSuppliers = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPOForSupplier);
            if (CollectionUtils.isEmpty(sscStatusCirculationConfPOForSuppliers)) {
                throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            for (SscStatusCirculationConfPO po1 : sscStatusCirculationConfPOForSuppliers) {
                List<String> oldSupplierStatuss = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)po1.getOldStatus())) {
                    if (po1.getOldStatus().contains(",")) {
                        oldSupplierStatuss = Arrays.asList(po1.getOldStatus().split(","));
                    } else {
                        oldSupplierStatuss.add(po1.getOldStatus());
                    }
                }
                SscProjectSupplierPO updateSupplierPO = new SscProjectSupplierPO();
                updateSupplierPO.setProjectIds(projectIds);
                updateSupplierPO.setOldSupplierStatuss(oldSupplierStatuss);
                updateSupplierPO.setSupplierStatus(po1.getNewStatus());
                int n = this.sscProjectSupplierDAO.updateByCondition(updateSupplierPO);
            }
        }
    }

    private void updateProjectStatusForApplyEnd(SscUpdateProjectStatusTimeBusiReqBO busiReqBO) {
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
        whereStatusCirculationConfPO.setChangeTable("1");
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            SscProjectPO whereProjectPO = new SscProjectPO();
            whereProjectPO.setProjectStatus(po.getOldStatus());
            whereProjectPO.setApplyEndTime(busiReqBO.getQryTime());
            whereProjectPO.setPurchaseMode(po.getPurchaseMode());
            List<Long> projectIds = this.sscProjectDAO.getListForTime(whereProjectPO);
            if (CollectionUtils.isEmpty(projectIds)) continue;
            SscProjectPO updateProjectPO = new SscProjectPO();
            updateProjectPO.setProjectIds(projectIds);
            updateProjectPO.setProjectStatus(po.getNewStatus());
            int isUpdate = this.sscProjectDAO.updateByPrimaryKeySelective(updateProjectPO);
            if (isUpdate != projectIds.size()) {
                throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
            }
            SscStatusCirculationConfPO whereStatusCirculationConfPOForSupplier = new SscStatusCirculationConfPO();
            whereStatusCirculationConfPOForSupplier.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
            whereStatusCirculationConfPOForSupplier.setChangeTable("3");
            whereStatusCirculationConfPOForSupplier.setPurchaseMode(po.getPurchaseMode());
            SscStatusCirculationConfPO sscStatusCirculationConfPOForSupplier = this.sscStatusCirculationConfDAO.getModelBy(whereStatusCirculationConfPOForSupplier);
            if (null == sscStatusCirculationConfPOForSupplier) {
                throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            List<String> oldStatuss = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)sscStatusCirculationConfPOForSupplier.getOldStatus())) {
                if (sscStatusCirculationConfPOForSupplier.getOldStatus().contains(",")) {
                    oldStatuss = Arrays.asList(sscStatusCirculationConfPOForSupplier.getOldStatus().split(","));
                } else {
                    oldStatuss.add(sscStatusCirculationConfPOForSupplier.getOldStatus());
                }
            }
            SscProjectSupplierPO updateSupplierPO = new SscProjectSupplierPO();
            updateSupplierPO.setProjectIds(projectIds);
            updateSupplierPO.setOldSupplierStatuss(oldStatuss);
            updateSupplierPO.setSupplierStatus(sscStatusCirculationConfPOForSupplier.getNewStatus());
            int n = this.sscProjectSupplierDAO.updateByCondition(updateSupplierPO);
        }
    }

    private void updateProjectBidRoundStatus(SscUpdateProjectStatusTimeBusiReqBO busiReqBO) {
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
        whereStatusCirculationConfPO.setChangeTable("2");
        SscStatusCirculationConfPO sscStatusCirculationConfPO = this.sscStatusCirculationConfDAO.getModelBy(whereStatusCirculationConfPO);
        if (null == sscStatusCirculationConfPO) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        SscProjectBidRoundPO wherePO = new SscProjectBidRoundPO();
        wherePO.setQuotationLimitTime(busiReqBO.getQryTime());
        wherePO.setBidStatus(sscStatusCirculationConfPO.getOldStatus());
        List<SscProjectBidRoundPO> bidRoundPOs = this.sscProjectBidRoundDAO.getListForTime(wherePO);
        if (CollectionUtils.isEmpty(bidRoundPOs)) {
            return;
        }
        ArrayList<Long> bidRoundIds = new ArrayList<Long>();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (SscProjectBidRoundPO po : bidRoundPOs) {
            bidRoundIds.add(po.getBidRoundId());
            projectIds.add(po.getProjectId());
        }
        SscProjectBidRoundPO updatePO = new SscProjectBidRoundPO();
        updatePO.setBidRoundIds(bidRoundIds);
        updatePO.setBidStatus(sscStatusCirculationConfPO.getNewStatus());
        int isUpdate = this.sscProjectBidRoundDAO.updateByCondition(updatePO);
        if (isUpdate != bidRoundIds.size()) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8bc4\u6807\u8f6e\u6b21\u8868\u5931\u8d25\uff01");
        }
        SscStatusCirculationConfPO whereStatusCirculationConfForProjectPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfForProjectPO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
        whereStatusCirculationConfForProjectPO.setChangeTable("1");
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfForProjectPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            return;
        }
        for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            SscProjectPO updateProjectPO = new SscProjectPO();
            updateProjectPO.setProjectIds(projectIds);
            updateProjectPO.setProjectStatus(po.getNewStatus());
            int isUpdate2 = this.sscProjectDAO.updateByPrimaryKeySelective(updateProjectPO);
            if (isUpdate2 != projectIds.size()) {
                throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
            }
            SscStatusCirculationConfPO whereStatusCirculationConfPOForSupplier = new SscStatusCirculationConfPO();
            whereStatusCirculationConfPOForSupplier.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
            whereStatusCirculationConfPOForSupplier.setChangeTable("3");
            whereStatusCirculationConfPOForSupplier.setPurchaseMode(po.getPurchaseMode());
            SscStatusCirculationConfPO sscStatusCirculationConfPOForSupplier = this.sscStatusCirculationConfDAO.getModelBy(whereStatusCirculationConfPOForSupplier);
            if (null == sscStatusCirculationConfPOForSupplier) {
                throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            List<String> oldStatuss = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)sscStatusCirculationConfPOForSupplier.getOldStatus())) {
                if (sscStatusCirculationConfPOForSupplier.getOldStatus().contains(",")) {
                    oldStatuss = Arrays.asList(sscStatusCirculationConfPOForSupplier.getOldStatus().split(","));
                } else {
                    oldStatuss.add(sscStatusCirculationConfPOForSupplier.getOldStatus());
                }
            }
            SscProjectSupplierPO updateSupplierPO = new SscProjectSupplierPO();
            updateSupplierPO.setProjectIds(projectIds);
            updateSupplierPO.setOldSupplierStatuss(oldStatuss);
            updateSupplierPO.setSupplierStatus(sscStatusCirculationConfPOForSupplier.getNewStatus());
            int n = this.sscProjectSupplierDAO.updateByCondition(updateSupplierPO);
        }
    }
}

