/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.sscext.bo.SscExtCheckPrayBillListPurchasedNumAbilityReqBO;
import com.tydic.sscext.bo.SscExtCheckPrayBillListPurchasedNumAbilityRspBO;
import com.tydic.sscext.bo.common.SscExtSyncPrayBillListPurchasedNumBO;
import com.tydic.sscext.dao.ErpPrayBillListMapper;
import com.tydic.sscext.dao.po.ErpPrayBillListPO;
import com.tydic.sscext.serivce.SscExtCheckPrayBillListPurchasedNumAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="SSC_GROUP_PROD", serviceInterface=SscExtCheckPrayBillListPurchasedNumAbilityService.class)
public class SscExtCheckPrayBillListPurchasedNumAbilityServiceImpl
implements SscExtCheckPrayBillListPurchasedNumAbilityService {
    @Autowired
    private ErpPrayBillListMapper erpPrayBillListMapper;

    public SscExtCheckPrayBillListPurchasedNumAbilityRspBO checkPrayBillListPurchasedNum(SscExtCheckPrayBillListPurchasedNumAbilityReqBO reqBo) {
        SscExtCheckPrayBillListPurchasedNumAbilityRspBO rspBo = new SscExtCheckPrayBillListPurchasedNumAbilityRspBO();
        if (null == reqBo || !StringUtils.hasText((String)reqBo.getPrayBillId()) || CollectionUtils.isEmpty((Collection)reqBo.getPraylist())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u8bf7\u8d2d\u5355ID\u3001\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        for (SscExtSyncPrayBillListPurchasedNumBO bo : reqBo.getPraylist()) {
            if (null != bo.getPurchasedNum() && StringUtils.hasText((String)bo.getPrayBillCode()) && StringUtils.hasText((String)bo.getMaterialCode())) continue;
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e2d\u8bf7\u8d2d\u5355\u660e\u7ec6ID\u3001\u7269\u6599\u7f16\u7801\u3001\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        this.mergeListBySumPurchasedNum(reqBo);
        ErpPrayBillListPO erpPrayBillListPo = new ErpPrayBillListPO();
        erpPrayBillListPo.setPrayBillId(reqBo.getPrayBillId());
        erpPrayBillListPo.setMaterialCodeList(reqBo.getPraylist().stream().map(SscExtSyncPrayBillListPurchasedNumBO::getMaterialCode).distinct().collect(Collectors.toList()));
        List<ErpPrayBillListPO> list = this.erpPrayBillListMapper.getList(erpPrayBillListPo);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, List<ErpPrayBillListPO>> collectByPrayBillCode = list.stream().collect(Collectors.groupingBy(ErpPrayBillListPO::getPrayBillCode));
            StringBuilder sb = new StringBuilder();
            for (SscExtSyncPrayBillListPurchasedNumBO purchasedNumBo : reqBo.getPraylist()) {
                List<ErpPrayBillListPO> prayBillListPoList = collectByPrayBillCode.get(purchasedNumBo.getPrayBillCode());
                if (!CollectionUtils.isEmpty(prayBillListPoList)) {
                    ErpPrayBillListPO prayBillListPo = prayBillListPoList.get(0);
                    if (!StringUtils.hasText((String)prayBillListPo.getNastNum()) || BigDecimal.ZERO.compareTo(new BigDecimal(prayBillListPo.getNastNum())) >= 0) {
                        sb.append("\u7269\u6599\u7f16\u7801\uff1a[").append(prayBillListPo.getMaterialCode()).append("],\u7269\u6599\u540d\u79f0:[").append(prayBillListPo.getMaterialName()).append("]\u8d2d\u4e70\u7684\u603b\u6570\u91cf\u8d85\u8fc7\u4e86\u5269\u4f59\u8bf7\u8d2d\u6570\u91cf:0;");
                        continue;
                    }
                    BigDecimal purchasableNum = new BigDecimal(prayBillListPo.getNastNum()).subtract(null == prayBillListPo.getPurchasedNum() ? BigDecimal.ZERO : prayBillListPo.getPurchasedNum());
                    if (BigDecimal.ZERO.compareTo(purchasableNum) >= 0) {
                        sb.append("\u7269\u6599\u7f16\u7801\uff1a[").append(prayBillListPo.getMaterialCode()).append("],\u7269\u6599\u540d\u79f0:[").append(prayBillListPo.getMaterialName()).append("]\u8d2d\u4e70\u7684\u603b\u6570\u91cf\u8d85\u8fc7\u4e86\u5269\u4f59\u8bf7\u8d2d\u6570\u91cf:0;");
                        continue;
                    }
                    if (purchasableNum.compareTo(purchasedNumBo.getPurchasedNum()) >= 0) continue;
                    sb.append("\u7269\u6599\u7f16\u7801\uff1a[").append(prayBillListPo.getMaterialCode()).append("],\u7269\u6599\u540d\u79f0:[").append(prayBillListPo.getMaterialName()).append("]\u8d2d\u4e70\u7684\u603b\u6570\u91cf\u8d85\u8fc7\u4e86\u5269\u4f59\u8bf7\u8d2d\u6570\u91cf:").append(purchasableNum.toPlainString()).append(";");
                    continue;
                }
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u7269\u6599\u7f16\u7801:[" + purchasedNumBo.getMaterialCode() + "]\u4e0d\u5728\u5f53\u524d\u8bf7\u8d2d\u5355\u4e0b");
                return rspBo;
            }
            if (!sb.toString().isEmpty()) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(sb.toString());
                return rspBo;
            }
        } else {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8bf7\u8d2d\u7269\u6599\u76f8\u5173\u4fe1\u606f");
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void mergeListBySumPurchasedNum(SscExtCheckPrayBillListPurchasedNumAbilityReqBO reqBo) {
        ArrayList praylist = new ArrayList();
        Map<String, List<SscExtSyncPrayBillListPurchasedNumBO>> collectByPrayBillCode = reqBo.getPraylist().stream().collect(Collectors.groupingBy(SscExtSyncPrayBillListPurchasedNumBO::getPrayBillCode));
        collectByPrayBillCode.values().forEach(valueList -> {
            SscExtSyncPrayBillListPurchasedNumBO initalBo = new SscExtSyncPrayBillListPurchasedNumBO();
            initalBo.setPrayBillCode(((SscExtSyncPrayBillListPurchasedNumBO)valueList.get(0)).getPrayBillCode());
            initalBo.setMaterialCode(((SscExtSyncPrayBillListPurchasedNumBO)valueList.get(0)).getMaterialCode());
            initalBo.setPurchasedNum(BigDecimal.ZERO);
            praylist.add(valueList.stream().reduce(initalBo, this::addPurchasedNum));
        });
        reqBo.setPraylist(praylist);
    }

    private SscExtSyncPrayBillListPurchasedNumBO addPurchasedNum(SscExtSyncPrayBillListPurchasedNumBO a, SscExtSyncPrayBillListPurchasedNumBO b) {
        a.setPurchasedNum(a.getPurchasedNum().add(b.getPurchasedNum()));
        return a;
    }
}

