/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.ability.impl.centralizedPurchasing;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.bo.centralizedPurchasing.SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityReqBO;
import com.tydic.sscext.bo.centralizedPurchasing.SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityRspBO;
import com.tydic.sscext.bo.common.SscExtCentralizedPurchasingProjectDetailInfoBO;
import com.tydic.sscext.busi.centralizedPurchasing.SscExtBatchImportCentralizedPurchasingProjectDetailListBusiService;
import com.tydic.sscext.serivce.centralizedPurchasing.SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityService;
import com.tydic.sscext.utils.ExcelUtils;
import com.tydic.sscext.utils.SscExtStringUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="SSC_GROUP_PROD", serviceInterface=SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityService.class)
public class SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityServiceImpl
implements SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityService {
    @Value(value="${oss.accessUrl:}")
    private String ossAccessUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private SscExtBatchImportCentralizedPurchasingProjectDetailListBusiService sscExtBatchImportCentralizedPurchasingProjectDetailListBusiService;

    public SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityRspBO dealBatchImportCentralizedPurchasingProjectDetailList(SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityReqBO reqBo) {
        SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityRspBO rspBo = new SscExtBatchImportCentralizedPurchasingProjectDetailListAbilityRspBO();
        rspBo.setRespCode("0001");
        if (null == reqBo || !StringUtils.hasText((String)reqBo.getExcelFileUrl()) || null == reqBo.getProjectId()) {
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u6587\u4ef6URL\u3001\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        int maxSize = 500;
        ArrayList<SscExtCentralizedPurchasingProjectDetailInfoBO> detailInfoList = new ArrayList<SscExtCentralizedPurchasingProjectDetailInfoBO>();
        InputStream inputStream = this.downloadFile(reqBo.getExcelFileUrl());
        List<Row> rows = this.getRowsFromFile(inputStream, reqBo.getExcelFileUrl());
        for (Row row : rows) {
            SscExtCentralizedPurchasingProjectDetailInfoBO detailInfoBo = new SscExtCentralizedPurchasingProjectDetailInfoBO();
            int colNum = 0;
            String materialCode = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setMaterialCode(SscExtStringUtil.strLengthSub(materialCode, null));
            String materialName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setMaterialName(SscExtStringUtil.strLengthSub(materialName, null));
            String spec = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setSpec(SscExtStringUtil.strLengthSub(spec, null));
            String model = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setModel(SscExtStringUtil.strLengthSub(model, null));
            String measureName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setMeasureName(SscExtStringUtil.strLengthSub(measureName, null));
            String purchaseNumber = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setPurchaseNumber(StringUtils.hasText((String)purchaseNumber) ? new BigDecimal(purchaseNumber).setScale(6, 4) : null);
            String bugetUnitPrice = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setBugetUnitPrice(StringUtils.hasText((String)bugetUnitPrice) ? new BigDecimal(bugetUnitPrice).setScale(2, 4) : null);
            if (null != detailInfoBo.getPurchaseNumber() && null != detailInfoBo.getBugetUnitPrice()) {
                detailInfoBo.setBugetTotalPrice(detailInfoBo.getPurchaseNumber().multiply(detailInfoBo.getBugetUnitPrice()).setScale(2, 4));
            }
            String deliveryAddress = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setDeliveryAddress(SscExtStringUtil.strLengthSub(deliveryAddress, null));
            String deliveryDay = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setDeliveryDay(SscExtStringUtil.strLengthSub(deliveryDay, null));
            String demandDepartCode = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setDemandDepartCode(SscExtStringUtil.strLengthSub(demandDepartCode, null));
            String demandDepartName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setDemandDepartName(SscExtStringUtil.strLengthSub(demandDepartName, null));
            String employeeCode = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setEmployeeCode(SscExtStringUtil.strLengthSub(employeeCode, null));
            String employee = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setEmployee(SscExtStringUtil.strLengthSub(employee, null));
            String inspectorCode = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setInspectorCode(SscExtStringUtil.strLengthSub(inspectorCode, null));
            String inspector = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setInspector(SscExtStringUtil.strLengthSub(inspector, null));
            String inspectorPhone = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setInspectorPhone(SscExtStringUtil.strLengthSub(inspectorPhone, null));
            String brandOrManufacturer = ExcelUtils.cellToString(row.getCell(colNum++), false);
            detailInfoBo.setBrandOrManufacturer(SscExtStringUtil.strLengthSub(brandOrManufacturer, null));
            detailInfoList.add(detailInfoBo);
            if (detailInfoList.size() < 500) continue;
            break;
        }
        reqBo.setDetailInfoList(detailInfoList);
        return this.sscExtBatchImportCentralizedPurchasingProjectDetailListBusiService.dealBatchImportCentralizedPurchasingProjectDetailList(reqBo);
    }

    private InputStream downloadFile(String filePath) {
        InputStream inputStream;
        filePath = filePath.replace(this.ossAccessUrl, "").replace(this.ossFileUrl, "").replace("https://", "").replace("http://", "");
        try {
            inputStream = this.fileClient.downLoadToInputStream(filePath);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        if (inputStream == null) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        return inputStream;
    }

    private List<Row> getRowsFromFile(InputStream inputStream, String fileUrl) {
        ArrayList<HSSFRow> rows;
        String suffix = ExcelUtils.getSuffix(fileUrl);
        if (!StringUtils.isEmpty((Object)suffix)) {
            suffix = suffix.toLowerCase();
        }
        if ("xls".equals(suffix)) {
            List<HSSFRow> hssfRows = ExcelUtils.readXls(inputStream, 0, 1, 1);
            rows = new ArrayList<HSSFRow>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List<XSSFRow> xssfRows = ExcelUtils.readXlsx(inputStream, 0, 1, 1);
            rows = new ArrayList<XSSFRow>(xssfRows);
        } else {
            throw new BusinessException("8888", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9,\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f\uff01");
        }
        if (CollectionUtils.isEmpty(rows)) {
            throw new BusinessException("8888", "\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        return rows;
    }
}

