/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.utils.http;

import com.tydic.sscext.utils.http.HsnObjectPoolBean;
import com.tydic.sscext.utils.http.HttpClientPoolableObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;

public class HSNHttpPoolHelper {
    private static final Log log = LogFactory.getLog(HSNHttpPoolHelper.class);
    public static final HsnObjectPoolBean hsnHttpObjectPoolBean;
    public static final HsnObjectPoolBean hsnHttpsObjectPoolBean;
    private static IdleConnectionEvictor idleConnEvictor;
    private static final long minIdleTime = 60000L;
    private static final int maxConn = 1000;
    private static final int maxActive = 1000;

    public static void shutdownTask() {
        try {
            idleConnEvictor.interrupt();
        }
        catch (Exception e) {
            log.error((Object)("\u5173\u95edidleConnEvictor\u65f6\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        try {
            hsnHttpsObjectPoolBean.shutDownConnManager();
            hsnHttpObjectPoolBean.shutDownConnManager();
        }
        catch (Exception e) {
            log.error((Object)("\u5173\u95edClientConnectionManager\u65f6\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public static void setMaxConnPerRoute(int maxConnPerRoute) {
        hsnHttpObjectPoolBean.setMaxConnPerRoute(maxConnPerRoute);
    }

    public static void reConfigHttpClientConnManager() {
        hsnHttpsObjectPoolBean.reConfigHttpClientConnManager();
        hsnHttpObjectPoolBean.reConfigHttpClientConnManager();
    }

    public static long getHttpClientPoolNumActive() {
        return hsnHttpObjectPoolBean.getHttpClientPool().getNumActive();
    }

    public static long getHttpClientPoolMaxNum() {
        return 1000L;
    }

    private static GenericObjectPool.Config getObjectPoolConfig() {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = 1000;
        config.maxIdle = -1;
        config.minIdle = 100;
        config.testOnBorrow = false;
        config.testOnReturn = false;
        config.testWhileIdle = false;
        config.whenExhaustedAction = (byte)2;
        config.minEvictableIdleTimeMillis = 60000L;
        config.timeBetweenEvictionRunsMillis = 60000L;
        config.numTestsPerEvictionRun = 10;
        return config;
    }

    static {
        idleConnEvictor = null;
        GenericObjectPool.Config config = HSNHttpPoolHelper.getObjectPoolConfig();
        HttpClientPoolableObjectFactory httpClientPoolableObjectFactory = new HttpClientPoolableObjectFactory(false);
        GenericObjectPool httpClientPool = (GenericObjectPool)new GenericObjectPoolFactory((PoolableObjectFactory)httpClientPoolableObjectFactory, config).createPool();
        hsnHttpObjectPoolBean = new HsnObjectPoolBean((ObjectPool)httpClientPool, httpClientPoolableObjectFactory.getConnMng(), false);
        HttpClientPoolableObjectFactory httpsClientPoolableObjectFactory = new HttpClientPoolableObjectFactory(true);
        GenericObjectPool httpsClientPool = (GenericObjectPool)new GenericObjectPoolFactory((PoolableObjectFactory)httpsClientPoolableObjectFactory, config).createPool();
        hsnHttpsObjectPoolBean = new HsnObjectPoolBean((ObjectPool)httpsClientPool, httpsClientPoolableObjectFactory.getConnMng(), true);
        idleConnEvictor = new IdleConnectionEvictor();
        idleConnEvictor.start();
    }

    public static class IdleConnectionEvictor
    extends Thread {
        private static final int INTERVAL = 5000;

        public IdleConnectionEvictor() {
            super("HttpClient_IdleConnectionEvictor");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    IdleConnectionEvictor.sleep(5000L);
                    hsnHttpsObjectPoolBean.closeExpiredAndIdleConnections(60000L);
                    hsnHttpObjectPoolBean.closeExpiredAndIdleConnections(60000L);
                }
                catch (InterruptedException e) {
                    log.info((Object)"IdleConnectionEvictor\u4efb\u52a1\u7ed3\u675f\uff01");
                    break;
                }
                catch (Throwable ex) {
                    log.error((Object)"\u5b9a\u65f6\u5173\u95edhttp\u8fde\u63a5\u51fa\u9519\uff01", ex);
                }
            }
        }
    }
}

