/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.ability.impl.prayBill;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.bo.common.SscExtSyncPrayBillListPurchasedNumBO;
import com.tydic.sscext.bo.prayBill.SscExtCheckPrayBillListPurchasedNumAbilityReqBO;
import com.tydic.sscext.bo.prayBill.SscExtCheckPrayBillListPurchasedNumAbilityRspBO;
import com.tydic.sscext.dao.ErpPrayBillListMapper;
import com.tydic.sscext.dao.po.ErpPrayBillListPO;
import com.tydic.sscext.serivce.praybill.SscExtCheckPrayBillListPurchasedNumAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="SSC_GROUP_PROD", serviceInterface=SscExtCheckPrayBillListPurchasedNumAbilityService.class)
public class SscExtCheckPrayBillListPurchasedNumAbilityServiceImpl
implements SscExtCheckPrayBillListPurchasedNumAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SscExtCheckPrayBillListPurchasedNumAbilityServiceImpl.class);
    @Autowired
    private ErpPrayBillListMapper erpPrayBillListMapper;

    public SscExtCheckPrayBillListPurchasedNumAbilityRspBO checkPrayBillListPurchasedNum(SscExtCheckPrayBillListPurchasedNumAbilityReqBO reqBo) {
        SscExtCheckPrayBillListPurchasedNumAbilityRspBO rspBo = new SscExtCheckPrayBillListPurchasedNumAbilityRspBO();
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getPraylist())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        for (SscExtSyncPrayBillListPurchasedNumBO bo : reqBo.getPraylist()) {
            if (null != bo.getPurchasedNum() && StringUtils.hasText((String)bo.getPrayBillCode()) && StringUtils.hasText((String)bo.getMaterialCode()) && StringUtils.hasText((String)bo.getPrayBillId())) continue;
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e2d\u8bf7\u8d2d\u5355ID\u3001\u8bf7\u8d2d\u5355\u660e\u7ec6ID\u3001\u7269\u6599\u7f16\u7801\u3001\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        this.mergeListBySumPurchasedNum(reqBo);
        LOGGER.info("\u8bf7\u8d2d\u5355\u8868\u4f53\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo.getPraylist()));
        for (SscExtSyncPrayBillListPurchasedNumBO bo : reqBo.getPraylist()) {
            ErpPrayBillListPO erpPrayBillListPo = new ErpPrayBillListPO();
            erpPrayBillListPo.setPrayBillId(bo.getPrayBillId());
            erpPrayBillListPo.setMaterialCode(bo.getMaterialCode());
            LOGGER.info("\u8bf7\u8d2d\u5355\u8868\u4f53\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)erpPrayBillListPo));
            List<ErpPrayBillListPO> list = this.erpPrayBillListMapper.getList(erpPrayBillListPo);
            if (!CollectionUtils.isEmpty(list)) {
                for (ErpPrayBillListPO po : list) {
                    if (!StringUtils.hasText((String)po.getNastNum()) || BigDecimal.ZERO.compareTo(new BigDecimal(po.getNastNum())) >= 0) {
                        throw new BusinessException("8888", "\u8bf7\u8d2d\u5355\uff1a[" + po.getPrayBillId() + "],\u7269\u6599\u7f16\u7801:[" + po.getMaterialCode() + "]\u8d2d\u4e70\u7684\u603b\u6570\u91cf\u8d85\u8fc7\u4e86\u5269\u4f59\u8bf7\u8d2d\u6570\u91cf:0;");
                    }
                    BigDecimal purchasableNum = new BigDecimal(po.getNastNum()).subtract(null == po.getPurchasedNum() ? BigDecimal.ZERO : po.getPurchasedNum());
                    if (BigDecimal.ZERO.compareTo(purchasableNum) < 0) continue;
                    throw new BusinessException("8888", "\u8bf7\u8d2d\u5355\uff1a[" + po.getPrayBillId() + "],\u7269\u6599\u7f16\u7801:[" + po.getMaterialCode() + "]\u8d2d\u4e70\u7684\u603b\u6570\u91cf\u8d85\u8fc7\u4e86\u5269\u4f59\u8bf7\u8d2d\u6570\u91cf:0;");
                }
                continue;
            }
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8bf7\u8d2d\u7269\u6599\u76f8\u5173\u4fe1\u606f");
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void mergeListBySumPurchasedNum(SscExtCheckPrayBillListPurchasedNumAbilityReqBO reqBo) {
        ArrayList praylist = new ArrayList();
        Map<String, List<SscExtSyncPrayBillListPurchasedNumBO>> collectByPrayBillCode = reqBo.getPraylist().stream().collect(Collectors.groupingBy(SscExtSyncPrayBillListPurchasedNumBO::getPrayBillCode));
        collectByPrayBillCode.values().forEach(valueList -> {
            SscExtSyncPrayBillListPurchasedNumBO initalBo = new SscExtSyncPrayBillListPurchasedNumBO();
            initalBo.setPrayBillCode(((SscExtSyncPrayBillListPurchasedNumBO)valueList.get(0)).getPrayBillCode());
            initalBo.setMaterialCode(((SscExtSyncPrayBillListPurchasedNumBO)valueList.get(0)).getMaterialCode());
            initalBo.setPrayBillId(((SscExtSyncPrayBillListPurchasedNumBO)valueList.get(0)).getPrayBillId());
            initalBo.setPurchasedNum(BigDecimal.ZERO);
            praylist.add(valueList.stream().reduce(initalBo, this::addPurchasedNum));
        });
        reqBo.setPraylist(praylist);
    }

    private SscExtSyncPrayBillListPurchasedNumBO addPurchasedNum(SscExtSyncPrayBillListPurchasedNumBO a, SscExtSyncPrayBillListPurchasedNumBO b) {
        a.setPurchasedNum(a.getPurchasedNum().add(b.getPurchasedNum()));
        return a;
    }
}

