/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.busi.bidding.SscExportApproveCardBusiService;
import com.tydic.sscext.dao.SscProjectProMapper;
import com.tydic.sscext.dao.SscSupplierQuotationProMapper;
import com.tydic.sscext.dao.po.SscProjectProPO;
import com.tydic.sscext.dao.po.SscSupplierQuotationProPO;
import com.tydic.sscext.serivce.bidding.bo.SscExportApproveCardReqBO;
import com.tydic.sscext.serivce.bidding.bo.SscExportApproveCardRspBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationStageBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationSupplierBaseStageBO;
import com.tydic.sscext.serivce.bidding.bo.SscProWinBidFirstSecondBO;
import com.tydic.sscext.utils.PropertiesUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SscExportApproveCardBusiServiceImpl
implements SscExportApproveCardBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscExportApproveCardBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private SscProjectProMapper sscProjectProMapper;
    @Autowired
    private SscSupplierQuotationProMapper sscSupplierQuotationProMapper;

    @Override
    public SscExportApproveCardRspBO exportApproveCard(SscExportApproveCardReqBO reqBO) {
        SscProjectProPO projectInfo = this.projectInfo(reqBO);
        List<SscProQuotationStageBO> quotationStagInfoList = this.qryWinBiddingSupplierBaseStageList(reqBO);
        Map<String, List<SscProWinBidFirstSecondBO>> winBidFirstSecondMap = this.qryWinBidFirstSecond(reqBO);
        Map<String, Object> stageSupplierInfoMap = this.processExcel(projectInfo, quotationStagInfoList, winBidFirstSecondMap);
        SscExportApproveCardRspBO rspBO = this.doWordAndUpload(stageSupplierInfoMap);
        return rspBO;
    }

    private Map<String, List<SscProWinBidFirstSecondBO>> qryWinBidFirstSecond(SscExportApproveCardReqBO reqBO) {
        HashMap<String, List<SscProWinBidFirstSecondBO>> winBidFirstSecondMap = new HashMap<String, List<SscProWinBidFirstSecondBO>>();
        SscSupplierQuotationProPO firstPO = new SscSupplierQuotationProPO();
        firstPO.setProjectId(reqBO.getProjectId());
        firstPO.setDelStatus("0");
        firstPO.setWinBidStatus("2");
        firstPO.setOrderBy("q.stage_ext_field1");
        List<SscProWinBidFirstSecondBO> firstBOList = this.sscSupplierQuotationProMapper.getWinBidFirstSecond(firstPO);
        winBidFirstSecondMap.put("first", firstBOList);
        SscSupplierQuotationProPO secondPO = new SscSupplierQuotationProPO();
        secondPO.setProjectId(reqBO.getProjectId());
        secondPO.setDelStatus("0");
        secondPO.setWinBidStatus("3");
        secondPO.setOrderBy("q.stage_ext_field1");
        List<SscProWinBidFirstSecondBO> secondBOList = this.sscSupplierQuotationProMapper.getWinBidFirstSecond(secondPO);
        winBidFirstSecondMap.put("second", secondBOList);
        return winBidFirstSecondMap;
    }

    private SscProjectProPO projectInfo(SscExportApproveCardReqBO reqBO) {
        SscProjectProPO projectProQryParam = new SscProjectProPO();
        projectProQryParam.setProjectId(reqBO.getProjectId());
        SscProjectProPO projectProQryResult = this.sscProjectProMapper.getModelBy(projectProQryParam);
        return projectProQryResult;
    }

    private List<SscProQuotationStageBO> qryWinBiddingSupplierBaseStageList(SscExportApproveCardReqBO reqBO) {
        SscSupplierQuotationProPO qryStagequotationProPO = new SscSupplierQuotationProPO();
        qryStagequotationProPO.setProjectId(reqBO.getProjectId());
        qryStagequotationProPO.setDelStatus("0");
        qryStagequotationProPO.setOrderBy("q.stage_ext_field1");
        List<SscProQuotationStageBO> sscProQuotationStageBOList = this.sscSupplierQuotationProMapper.getStageList(qryStagequotationProPO);
        if (CollectionUtils.isEmpty(sscProQuotationStageBOList)) {
            throw new BusinessException("8888", "\u4e2d\u6807\u8be6\u60c5\u6807\u6bb5\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        for (SscProQuotationStageBO quotationStageBO : sscProQuotationStageBOList) {
            SscSupplierQuotationProPO qryQuotationProPO = new SscSupplierQuotationProPO();
            qryQuotationProPO.setProjectId(reqBO.getProjectId());
            qryQuotationProPO.setStageId(quotationStageBO.getStageId());
            List<SscProQuotationSupplierBaseStageBO> sscProQuotationSupplierBaseStageBOList = this.sscSupplierQuotationProMapper.getQuotationBaseStageList(qryQuotationProPO);
            if (!CollectionUtils.isEmpty(sscProQuotationSupplierBaseStageBOList)) {
                for (SscProQuotationSupplierBaseStageBO quotationSupplierBaseStageBO : sscProQuotationSupplierBaseStageBOList) {
                    quotationSupplierBaseStageBO.setInitialTotalPrice(quotationSupplierBaseStageBO.getInitialTotalPrice().divide(new BigDecimal("10000")));
                    quotationSupplierBaseStageBO.setEndTotalPrice(quotationSupplierBaseStageBO.getEndTotalPrice().divide(new BigDecimal("10000")));
                }
            }
            quotationStageBO.setSscProQuotationSupplierBaseStageBOList(sscProQuotationSupplierBaseStageBOList);
        }
        return sscProQuotationStageBOList;
    }

    private Map<String, Object> processExcel(SscProjectProPO projectInfo, List<SscProQuotationStageBO> quotationStagInfoList, Map<String, List<SscProWinBidFirstSecondBO>> winBidFirstSecondMap) {
        HashMap<String, Object> itemMap;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("company", projectInfo.getPurchaseUnitName());
        dataMap.put("projectName", projectInfo.getProjectName());
        dataMap.put("year", DateUtils.dateToStr((Date)projectInfo.getProjectProducerTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
        if (StringUtils.hasText((String)projectInfo.getProjectProducerName())) {
            dataMap.put("recordMan", projectInfo.getProjectProducerName());
        } else {
            dataMap.put("recordMan", "");
        }
        if (StringUtils.hasText((String)projectInfo.getBidOpenAddr())) {
            dataMap.put("address", projectInfo.getBidOpenAddr());
        } else {
            dataMap.put("address", "");
        }
        ArrayList stageList = new ArrayList();
        for (SscProQuotationStageBO stageBO : quotationStagInfoList) {
            ArrayList itemList = new ArrayList();
            HashMap<String, Object> stageMap = new HashMap<String, Object>();
            for (int i = 0; i < stageBO.getSscProQuotationSupplierBaseStageBOList().size(); ++i) {
                SscProQuotationSupplierBaseStageBO supplierBaseStageBO = (SscProQuotationSupplierBaseStageBO)stageBO.getSscProQuotationSupplierBaseStageBOList().get(i);
                itemMap = new HashMap<String, Object>();
                if (i == 0) {
                    if (StringUtils.hasText((String)stageBO.getStageName())) {
                        itemMap.put("stage", stageBO.getStageName());
                    } else {
                        itemMap.put("stage", "-");
                    }
                    itemMap.put("start", "<w:vMerge w:val='restart'/>");
                    itemMap.put("end", "-");
                } else {
                    itemMap.put("stage", "-");
                    itemMap.put("start", "-");
                    itemMap.put("end", "<w:vMerge/>");
                }
                if (StringUtils.hasText((String)supplierBaseStageBO.getSupplierName())) {
                    itemMap.put("companyName", supplierBaseStageBO.getSupplierName());
                } else {
                    itemMap.put("companyName", "-");
                }
                if (StringUtils.hasText((String)supplierBaseStageBO.getRegistAmount())) {
                    itemMap.put("money", supplierBaseStageBO.getRegistAmount());
                } else {
                    itemMap.put("money", "-");
                }
                if (StringUtils.hasText((String)supplierBaseStageBO.getBusiLinkMan())) {
                    itemMap.put("linkMan", supplierBaseStageBO.getBusiLinkMan());
                } else {
                    itemMap.put("linkMan", "-");
                }
                if (StringUtils.hasText((String)supplierBaseStageBO.getBusiLinkWay())) {
                    itemMap.put("linkTel", supplierBaseStageBO.getBusiLinkWay());
                } else {
                    itemMap.put("linkTel", "-");
                }
                if (supplierBaseStageBO.getInitialTotalPrice() != null && supplierBaseStageBO.getInitialTotalPrice().compareTo(BigDecimal.ZERO) > 0) {
                    itemMap.put("fMoney", supplierBaseStageBO.getInitialTotalPrice());
                } else {
                    itemMap.put("fMoney", "-");
                }
                if (supplierBaseStageBO.getEndTotalPrice() != null && supplierBaseStageBO.getEndTotalPrice().compareTo(BigDecimal.ZERO) > 0) {
                    itemMap.put("eMoney", supplierBaseStageBO.getEndTotalPrice());
                } else {
                    itemMap.put("eMoney", "-");
                }
                if (StringUtils.hasText((String)supplierBaseStageBO.getPaymentType())) {
                    itemMap.put("payType", supplierBaseStageBO.getPaymentType());
                } else {
                    itemMap.put("payType", "-");
                }
                if (StringUtils.hasText((String)supplierBaseStageBO.getDeliveryDate())) {
                    itemMap.put("delDate", supplierBaseStageBO.getDeliveryDate());
                } else {
                    itemMap.put("delDate", "-");
                }
                if (StringUtils.hasText((String)supplierBaseStageBO.getReviewRemark())) {
                    itemMap.put("remark", supplierBaseStageBO.getReviewRemark());
                } else {
                    itemMap.put("remark", "-");
                }
                itemList.add(itemMap);
            }
            stageMap.put("itemList", itemList);
            stageList.add(stageMap);
        }
        ArrayList firstItemList = new ArrayList();
        List<SscProWinBidFirstSecondBO> firstList = winBidFirstSecondMap.get("first");
        if (!CollectionUtils.isEmpty(firstList)) {
            for (SscProWinBidFirstSecondBO firstSecondBO : firstList) {
                HashMap<String, String> itemMap2 = new HashMap<String, String>();
                itemMap2.put("firstStage", firstSecondBO.getStageName());
                itemMap2.put("firstSupplier", firstSecondBO.getSupplierName());
                firstItemList.add(itemMap2);
            }
        }
        ArrayList secondItemList = new ArrayList();
        List<SscProWinBidFirstSecondBO> secondList = winBidFirstSecondMap.get("second");
        if (!CollectionUtils.isEmpty(secondList)) {
            for (SscProWinBidFirstSecondBO firstSecondBO : secondList) {
                itemMap = new HashMap();
                itemMap.put("secondStage", firstSecondBO.getStageName());
                itemMap.put("secondSupplier", firstSecondBO.getSupplierName());
                secondItemList.add(itemMap);
            }
        }
        dataMap.put("firstList", firstItemList);
        dataMap.put("secondList", secondItemList);
        dataMap.put("stageList", stageList);
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SscExportApproveCardRspBO doWordAndUpload(Map<String, Object> dataMap) {
        SscExportApproveCardRspBO rspInfoBO = new SscExportApproveCardRspBO();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Configuration config = new Configuration();
        config.setDefaultEncoding("UTF-8");
        try {
            String templateFilePath = PropertiesUtil.getProperty("ZTB_EXPORT_APPORVE_TEMPLATE_URL");
            String ftlFileName = templateFilePath.substring(templateFilePath.lastIndexOf("/") + 1);
            File file = this.fileClient.downloadToFile(PropertiesUtil.getProperty("OSS_UPLOAD_FILE") + "/" + ftlFileName);
            String ftlPath = file.getPath().substring(0, file.getPath().lastIndexOf("/"));
            log.debug("\u6a21\u677f\u540d:" + file.getName() + "\u6a21\u677f\u5730\u5740:" + file.getAbsolutePath());
            config.setDirectoryForTemplateLoading(new File(ftlPath));
            Template t = config.getTemplate(file.getName(), "UTF-8");
            log.debug("\u6a21\u677f\u5730\u5740\uff1a" + ftlPath);
            log.debug("\u6a21\u677f\u540d\uff1a" + file.getName());
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream));
            t.process(dataMap, (Writer)out);
            String fileByInputStream = this.fileClient.uploadFileByInputStream(PropertiesUtil.getProperty("OSS_UPLOAD_FILE"), Sequence.getInstance().nextId() + ".doc", (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            rspInfoBO.setExportUrl(PropertiesUtil.getProperty("OSS_URL") + fileByInputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u6210\u529f");
        log.info("\u62db\u6295\u6807\u5bfc\u51fa\u5ba1\u6279\u4fe1\u606fword\u6210\u529f\uff01" + rspInfoBO.toString());
        return rspInfoBO;
    }
}

