/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscExternalOutBaseRspBO;
import com.tydic.ssc.service.utils.HttpUtil;
import com.tydic.sscext.bo.common.SscExtSyncPrayBillListPurchasedNumBO;
import com.tydic.sscext.bo.prayBill.SscExtSyncPrayBillListPurchasedNumAbilityReqBO;
import com.tydic.sscext.bo.prayBill.SscExtSyncPrayBillListPurchasedNumAbilityRspBO;
import com.tydic.sscext.busi.bidding.SscProChangeProjectStatusBusiService;
import com.tydic.sscext.busi.bo.bidding.SscProChangeProjectStatusBusiReqBO;
import com.tydic.sscext.busi.bo.bidding.SscProChangeProjectStatusBusiRspBO;
import com.tydic.sscext.constant.SscExtConstant;
import com.tydic.sscext.dao.SscProjectDetailProMapper;
import com.tydic.sscext.dao.SscProjectNoticeProMapper;
import com.tydic.sscext.dao.SscProjectProMapper;
import com.tydic.sscext.dao.SscProjectStageProMapper;
import com.tydic.sscext.dao.SscProjectSupplierProMapper;
import com.tydic.sscext.dao.po.SscProjectDetailProPO;
import com.tydic.sscext.dao.po.SscProjectNoticeProPO;
import com.tydic.sscext.dao.po.SscProjectProPO;
import com.tydic.sscext.dao.po.SscProjectStageProPO;
import com.tydic.sscext.dao.po.SscProjectSupplierProPO;
import com.tydic.sscext.serivce.bidding.bo.SscErpProjectDeleteBO;
import com.tydic.sscext.serivce.praybill.SscExtSyncPrayBillListPurchasedNumAbilityService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="sscProChangeProjectStatusBusiService")
public class SscProChangeProjectStatusBusiServiceImpl
implements SscProChangeProjectStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscProChangeProjectStatusBusiServiceImpl.class);
    @Autowired
    private SscProjectProMapper sscProjectProMapper;
    @Autowired
    private SscProjectStageProMapper sscProjectStageProMapper;
    @Autowired
    private SscProjectDetailProMapper sscProjectDetailProMapper;
    @Autowired
    private SscProjectSupplierProMapper sscProjectSupplierProMapper;
    @Autowired
    private SscProjectNoticeProMapper sscProjectNoticeProMapper;
    @Autowired
    private SscExtSyncPrayBillListPurchasedNumAbilityService sscExtSyncPrayBillListPurchasedNumAbilityService;
    @Value(value="${ERP_PROJECT_DELETE_URL}")
    private String abilityUri;

    @Override
    public SscProChangeProjectStatusBusiRspBO changeProjectStatus(SscProChangeProjectStatusBusiReqBO reqBO) {
        SscProChangeProjectStatusBusiRspBO rspBO = new SscProChangeProjectStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        switch (reqBO.getOperType()) {
            case "loss": {
                SscProjectProPO sscProjectProPO = new SscProjectProPO();
                sscProjectProPO.setProjectId(reqBO.getProjectId());
                sscProjectProPO.setProjectStatus("14");
                sscProjectProPO.setProjectUpdateId(reqBO.getMemIdIn().toString());
                sscProjectProPO.setProjectUpdateName(reqBO.getName());
                sscProjectProPO.setProjectUpdateTime(new Date());
                sscProjectProPO.setBidFailureId(reqBO.getMemIdIn().toString());
                sscProjectProPO.setBidFailureName(reqBO.getName());
                sscProjectProPO.setBidFailureTime(new Date());
                int update = this.sscProjectProMapper.updateById(sscProjectProPO);
                if (update < 1) {
                    throw new BusinessException("8888", "\u4fee\u6539\u9879\u76ee\u8868\u5931\u8d25\uff01");
                }
                SscProjectStageProPO sscProjectStageProPO = new SscProjectStageProPO();
                sscProjectStageProPO.setProjectId(reqBO.getProjectId());
                List<SscProjectStageProPO> sscProjectStageProPOS = this.sscProjectStageProMapper.getList(sscProjectStageProPO);
                for (SscProjectStageProPO projectStageProPO : sscProjectStageProPOS) {
                    SscProjectStageProPO where = new SscProjectStageProPO();
                    where.setStageId(projectStageProPO.getStageId());
                    SscProjectStageProPO set = new SscProjectStageProPO();
                    BeanUtils.copyProperties((Object)projectStageProPO, (Object)set);
                    set.setStageStatus("3");
                    update = this.sscProjectStageProMapper.updateBy(set, where);
                    if (update >= 1) continue;
                    throw new BusinessException("8888", "\u4fee\u6539\u6807\u6bb5\u8868\u5931\u8d25\uff01");
                }
                SscProjectSupplierProPO sscProjectSupplierProPO = new SscProjectSupplierProPO();
                sscProjectSupplierProPO.setProjectId(reqBO.getProjectId());
                List<SscProjectSupplierProPO> sscProjectSupplierProPOS = this.sscProjectSupplierProMapper.getList(sscProjectSupplierProPO);
                for (SscProjectSupplierProPO projectSupplierProPO : sscProjectSupplierProPOS) {
                    SscProjectSupplierProPO set = new SscProjectSupplierProPO();
                    BeanUtils.copyProperties((Object)projectSupplierProPO, (Object)set);
                    set.setProjectSupplierStatus("11");
                    SscProjectSupplierProPO where = new SscProjectSupplierProPO();
                    where.setProjectSupplierId(projectSupplierProPO.getProjectSupplierId());
                    update = this.sscProjectSupplierProMapper.updateBy(set, where);
                    if (update >= 1) continue;
                    throw new BusinessException("8888", "\u4fee\u6539\u9879\u76ee\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
                }
                this.returnPrayBillNum(reqBO.getProjectId());
                break;
            }
            case "delete": {
                SscProjectProPO deletePO = new SscProjectProPO();
                deletePO.setProjectId(reqBO.getProjectId());
                deletePO.setDelStatus("1");
                try {
                    int update = this.sscProjectProMapper.updateById(deletePO);
                    if (update < 1) {
                        throw new BusinessException("8888", "\u5220\u9664\u9879\u76ee\u5931\u8d25\uff01");
                    }
                    break;
                }
                catch (Exception e) {
                    log.error("\u5220\u9664\u9879\u76ee\u5931\u8d25:" + e);
                    throw new BusinessException("8888", "\u5220\u9664\u9879\u76ee\u5931\u8d25\uff01");
                }
            }
            case "return": {
                SscProjectProPO returnPO = new SscProjectProPO();
                returnPO.setProjectId(reqBO.getProjectId());
                SscProjectProPO qryResult = this.sscProjectProMapper.getModelBy(returnPO);
                qryResult.setProjectStatus("1");
                SscProjectNoticeProPO projectNoticeProPO = new SscProjectNoticeProPO();
                projectNoticeProPO.setProjectId(reqBO.getProjectId());
                SscProjectNoticeProPO noticeProPO = this.sscProjectNoticeProMapper.getModelBy(projectNoticeProPO);
                noticeProPO.setDelStatus("1");
                try {
                    int updateById = this.sscProjectNoticeProMapper.updateById(noticeProPO);
                    if (updateById < 1) {
                        throw new BusinessException("8888", "\u5220\u9664\u516c\u544a\u5931\u8d25\uff01");
                    }
                    int update = this.sscProjectProMapper.updateById(qryResult);
                    if (update < 1) {
                        throw new BusinessException("8888", "\u64a4\u56de\u9879\u76ee\u5931\u8d25\uff01");
                    }
                    if (StringUtils.isEmpty((Object)this.abilityUri)) {
                        log.debug("\u62db\u6295\u6807\u9879\u76ee\u63d0\u4ea4erp\u9879\u76ee\u5220\u9664\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u8c03\u7528erp\u63a5\u53e3!");
                    } else {
                        log.debug("\u62db\u6295\u6807\u9879\u76ee\u63d0\u4ea4erp\u9879\u76ee\u5220\u9664\u5730\u5740\u4e3a:" + JSON.toJSONString((Object)this.abilityUri));
                        SscErpProjectDeleteBO sscErpProjectDeleteBO = new SscErpProjectDeleteBO();
                        sscErpProjectDeleteBO.setTendercode(reqBO.getProjectId().toString());
                        sscErpProjectDeleteBO.setBillmaker(reqBO.getUsername());
                        String s = JSON.toJSONString((Object)sscErpProjectDeleteBO);
                        log.debug("\u62db\u6295\u6807\u9879\u76ee\u63d0\u4ea4erp\u9879\u76ee\u5220\u9664\u53c2\u6570\uff1a:" + s);
                        String outStr = HttpUtil.httpClient((String)this.abilityUri, (String)s);
                        log.debug("\u62db\u6295\u6807\u9879\u76ee\u63d0\u4ea4erp\u9879\u76ee\u5220\u9664\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)outStr));
                        SscExternalOutBaseRspBO erpRspBO = (SscExternalOutBaseRspBO)JSON.parseObject((String)outStr, SscExternalOutBaseRspBO.class);
                        String RSP_CODE_SUCCESS = "0";
                        if (Objects.isNull(erpRspBO) || !"0".equals(erpRspBO.getCode())) {
                            throw new BusinessException("8888", "\u62db\u6295\u6807\u9879\u76ee\u63d0\u4ea4erp\u9879\u76ee\u5220\u9664\u5931\u8d25 : " + erpRspBO.getMsg());
                        }
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u64a4\u56de\u9879\u76ee\u5931\u8d25 : " + e.getMessage());
                }
                this.returnPrayBillNum(reqBO.getProjectId());
                break;
            }
            default: {
                return rspBO;
            }
        }
        return rspBO;
    }

    private void returnPrayBillNum(Long projectId) {
        SscProjectDetailProPO sscProjectDetailProPO = new SscProjectDetailProPO();
        sscProjectDetailProPO.setProjectId(projectId);
        List<SscProjectDetailProPO> detailProPOS = this.sscProjectDetailProMapper.getList(sscProjectDetailProPO);
        ArrayList<SscExtSyncPrayBillListPurchasedNumBO> purchasedList = new ArrayList<SscExtSyncPrayBillListPurchasedNumBO>();
        if (!CollectionUtils.isEmpty(detailProPOS)) {
            for (SscProjectDetailProPO po : detailProPOS) {
                if (!StringUtils.hasText((String)po.getPrayBillId()) || !StringUtils.hasText((String)po.getPrayBillCode())) continue;
                SscExtSyncPrayBillListPurchasedNumBO sscExtSyncPrayBillListPurchasedSumNumBO = new SscExtSyncPrayBillListPurchasedNumBO();
                sscExtSyncPrayBillListPurchasedSumNumBO.setPurchasedNum(po.getPurchaseNumber());
                sscExtSyncPrayBillListPurchasedSumNumBO.setPrayBillCode(po.getBillCode());
                sscExtSyncPrayBillListPurchasedSumNumBO.setMaterialCode(po.getMaterailCode());
                sscExtSyncPrayBillListPurchasedSumNumBO.setPrayBillId(po.getPrayBillId());
                sscExtSyncPrayBillListPurchasedSumNumBO.setPrayBillCode(po.getPrayBillCode());
                purchasedList.add(sscExtSyncPrayBillListPurchasedSumNumBO);
            }
            if (!CollectionUtils.isEmpty(purchasedList)) {
                SscExtSyncPrayBillListPurchasedNumAbilityReqBO syncPrayBillListPurchasedNumReqBO = new SscExtSyncPrayBillListPurchasedNumAbilityReqBO();
                syncPrayBillListPurchasedNumReqBO.setOperType(SscExtConstant.SyncPrayBillListPurchaesNumOperType.AFTER_SALE);
                syncPrayBillListPurchasedNumReqBO.setChangeType(SscExtConstant.SscExtChangeType.SSC);
                syncPrayBillListPurchasedNumReqBO.setSourceId(projectId);
                syncPrayBillListPurchasedNumReqBO.setPraylist(purchasedList);
                SscExtSyncPrayBillListPurchasedNumAbilityRspBO syncPrayBillListPurchasedNumRspBo = this.sscExtSyncPrayBillListPurchasedNumAbilityService.syncPrayBillListPurchasedNum(syncPrayBillListPurchasedNumReqBO);
                if (!"0000".equals(syncPrayBillListPurchasedNumRspBo.getRespCode())) {
                    throw new ZTBusinessException("\u8fd4\u8fd8\u6d41\u6807\u7269\u6599\u6570\u91cf\u5230\u8bf7\u8d2d\u5355\u5931\u8d25\uff01" + syncPrayBillListPurchasedNumRspBo.getRespDesc());
                }
            }
        }
    }
}

