/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.service.busi.SscCreateProjectNoBusiService;
import com.tydic.ssc.service.busi.bo.SscCreateProjectNoBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscCreateProjectNoBusiRspBO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscCreateProjectNoBusiServiceImpl
implements SscCreateProjectNoBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscCreateProjectNoBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    private static ThreadLocal<Integer> threadLocal = new ThreadLocal(){

        protected Integer initialValue() {
            return 0;
        }
    };

    @Override
    public SscCreateProjectNoBusiRspBO createProjectNo(SscCreateProjectNoBusiReqBO reqBO) {
        SscProjectPO sscProjectPO;
        SscCreateProjectNoBusiRspBO rspBO;
        block7: {
            rspBO = new SscCreateProjectNoBusiRspBO();
            String projectNo = this.sscProjectDAO.getMaxProjectNo();
            String maxProjectNo = "";
            if (StringUtils.isEmpty((Object)projectNo)) {
                maxProjectNo = "001";
            } else if (projectNo.startsWith("ZTB") && projectNo.length() == 18) {
                String currentNo = projectNo.substring(projectNo.length() - 3);
                Integer intNO = Integer.valueOf(currentNo);
                maxProjectNo = (intNO = Integer.valueOf(intNO + 1)) < 999 ? (intNO < 10 ? "00" + intNO : (intNO < 100 ? "0" + intNO : "" + intNO)) : "001";
            } else {
                maxProjectNo = "001";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("YYYYMMddHHmm");
            String dateStr = dateFormat.format(new Date());
            dateStr = "ZTB" + dateStr + maxProjectNo;
            sscProjectPO = new SscProjectPO();
            sscProjectPO.setProjectProducerId(reqBO.getMemIdIn());
            sscProjectPO.setProjectProducerName(reqBO.getName());
            sscProjectPO.setProjectProducerTime(new Date());
            sscProjectPO.setProjectProducerUnitId(reqBO.getCompanyId());
            sscProjectPO.setProjectProducerUnitName(reqBO.getCompanyName());
            sscProjectPO.setProjectProducerDepartmentId(reqBO.getOrgId());
            sscProjectPO.setProjectProducerDepartmentName(reqBO.getOrgName());
            sscProjectPO.setProjectNo(dateStr);
            sscProjectPO.setProjectId(Sequence.getInstance().nextId());
            try {
                this.sscProjectDAO.insertSelective(sscProjectPO);
            }
            catch (Exception e) {
                Integer retryNum = threadLocal.get();
                if (retryNum < 50) {
                    retryNum = retryNum + 1;
                    threadLocal.set(retryNum);
                    this.createProjectNo(reqBO);
                }
                if (threadLocal.get() != 50) break block7;
                rspBO.setRespDesc("\u9879\u76ee\u7f16\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                rspBO.setRespCode("8888");
                return rspBO;
            }
        }
        rspBO.setProjectId(sscProjectPO.getProjectId());
        rspBO.setProjectNo(sscProjectPO.getProjectNo());
        rspBO.setRespDesc("\u9879\u76ee\u7f16\u53f7\u751f\u6210\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

