/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectBO;
import com.tydic.ssc.common.SscProjectStageBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectStageDAO;
import com.tydic.ssc.dao.po.SscProjectStagePO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryProjectListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProjectListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProjectListBusiRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQryProjectListBusiServiceImpl
implements SscQryProjectListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscQryProjectListBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;
    @Autowired
    private SscProjectStageDAO sscProjectStageDAO;

    @Override
    public SscQryProjectListBusiRspBO qrySscProjectList(SscQryProjectListBusiReqBO busiReqBO) {
        List sscProjectStageBOS;
        SscQryProjectListBusiRspBO rsp = new SscQryProjectListBusiRspBO();
        if (!busiReqBO.getQueryPageFlag().booleanValue()) {
            busiReqBO.setPageNo(-1);
            busiReqBO.setPageSize(-1);
        }
        if ("0".equals(busiReqBO.getIsProfessionalOrgExt())) {
            busiReqBO.setCompanyId(null);
            busiReqBO.setOrgId(null);
        }
        log.debug("\u67e5\u8be2\u9879\u76ee\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)busiReqBO)));
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        List<SscProjectBO> rows = this.sscProjectDAO.getListPage(busiReqBO, (Page<SscProjectBO>)page);
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        Map<Object, Object> stageMap = new HashMap(16);
        if (null != busiReqBO.getQueryStageFlag() && busiReqBO.getQueryStageFlag().booleanValue()) {
            SscProjectStagePO whereProjectStagePO = new SscProjectStagePO();
            whereProjectStagePO.setProjectIds(busiReqBO.getProjectIds());
            List<SscProjectStagePO> sscProjectStagePOs = this.sscProjectStageDAO.getList(whereProjectStagePO);
            if (!CollectionUtils.isEmpty(sscProjectStagePOs)) {
                String jsonString = JSON.toJSONString(sscProjectStagePOs, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                sscProjectStageBOS = JSON.parseArray((String)jsonString, SscProjectStageBO.class);
                stageMap = sscProjectStageBOS.stream().collect(Collectors.groupingBy(SscProjectStageBO::getProjectId));
            }
        }
        if (null != stageMap) {
            for (SscProjectBO sscProjectBO : rows) {
                Long projectId = sscProjectBO.getProjectId();
                sscProjectStageBOS = (List)stageMap.get(projectId);
                sscProjectBO.setProjectStageBOs(sscProjectStageBOS);
            }
        }
        Map<Object, Object> sscProjectExtMap = new HashMap();
        if (busiReqBO.getQueryExtInfo().booleanValue()) {
            ArrayList<Long> projectIds = new ArrayList<Long>();
            if (busiReqBO.getQueryExtInfo().booleanValue()) {
                for (SscProjectBO bo : rows) {
                    projectIds.add(bo.getProjectId());
                }
            }
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null == sscProjectExtMap) {
                sscProjectExtMap = new HashMap();
            }
        }
        if (busiReqBO.getQueryExtInfo().booleanValue() || busiReqBO.getTranslateFlag().booleanValue()) {
            Map<String, String> projectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_STATUS");
            Map<String, String> purchaseModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
            Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
            Map<String, String> yesOrNoMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
            Map<String, String> quotationModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUOTATION_MODE");
            Map<String, String> budgetCurrencyMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "BUDGET_CURRENCY");
            Map<String, String> evaBidRuleMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "EVA_BID_RULE");
            Map<String, String> xbjProjectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "XBJ_PROJECT_STATUS");
            Map<String, String> inquireWayMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "INQUIRE_WAY");
            Map<String, String> purchaserScopeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASER_PRODUCT_SCOPE");
            for (SscProjectBO bo : rows) {
                if (busiReqBO.getQueryExtInfo().booleanValue()) {
                    bo.setSscProjectExtMap((Map)sscProjectExtMap.get(bo.getProjectId()));
                }
                if (!busiReqBO.getTranslateFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)bo.getProjectStatus())) {
                    if ("1".equals(bo.getPurchaseMode())) {
                        bo.setProjectStatusStr(projectStatusMap.get(bo.getProjectStatus()));
                    } else if ("2".equals(bo.getPurchaseMode())) {
                        bo.setProjectStatusStr(xbjProjectStatusMap.get(bo.getProjectStatus()));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getPurchaseMode())) {
                    bo.setPurchaseModeStr(purchaseModeMap.get(bo.getPurchaseMode()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getTenderMode())) {
                    String purchaseMode = bo.getPurchaseMode();
                    if ("1".equals(purchaseMode)) {
                        bo.setTenderModeStr(tenderModeMap.get(bo.getTenderMode()));
                    } else if ("2".equals(purchaseMode)) {
                        bo.setTenderModeStr(inquireWayMap.get(bo.getTenderMode()));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getIsAudit())) {
                    bo.setIsAuditStr(yesOrNoMap.get(bo.getIsAudit()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getQuotationMode())) {
                    bo.setQuotationModeStr(quotationModeMap.get(bo.getQuotationMode()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getIsNeedMargin())) {
                    bo.setIsNeedMarginStr(yesOrNoMap.get(bo.getIsNeedMargin()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getBudgetCurrency())) {
                    bo.setBudgetCurrencyStr(budgetCurrencyMap.get(bo.getBudgetCurrency()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getBudgetPublic())) {
                    bo.setBudgetPublicStr(yesOrNoMap.get(bo.getBudgetPublic()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getEvaBidRule())) {
                    bo.setEvaBidRuleStr(evaBidRuleMap.get(bo.getEvaBidRule()));
                }
                if (!StringUtils.isNotBlank((CharSequence)bo.getProjectExtField2())) continue;
                bo.setProjectExtField2Str(purchaserScopeMap.get(bo.getProjectExtField2()));
            }
        }
        rsp.setPageNo(page.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62db\u6807\u9879\u76ee\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }
}

