/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.ssc.ability.SscAddSupplierAttachAbilityService;
import com.tydic.ssc.ability.bo.SscAddSupplierAttachAbilityReqBO;
import com.tydic.ssc.ability.bo.SscAddSupplierAttachAbilityRspBO;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectSupplierAttachBO;
import com.tydic.ssc.service.busi.SscAddSupplierAttachBusiService;
import com.tydic.ssc.service.busi.bo.SscAddSupplierAttachBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscAddSupplierAttachBusiRspBO;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="SSC_GROUP_DEV", serviceInterface=SscAddSupplierAttachAbilityService.class)
public class SscAddSupplierAttachAbilityServiceImpl
implements SscAddSupplierAttachAbilityService {
    @Autowired
    private SscAddSupplierAttachBusiService sscAddSupplierAttachBusiService;

    public SscAddSupplierAttachAbilityRspBO addSupplierAttach(SscAddSupplierAttachAbilityReqBO reqBO) {
        this.validateParams(reqBO);
        SscAddSupplierAttachBusiReqBO sscAddSupplierAttachBusiReqBO = new SscAddSupplierAttachBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)sscAddSupplierAttachBusiReqBO);
        SscAddSupplierAttachBusiRspBO busiRspBO = this.sscAddSupplierAttachBusiService.addSupplierAttach(sscAddSupplierAttachBusiReqBO);
        SscAddSupplierAttachAbilityRspBO rspBO = new SscAddSupplierAttachAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)reqBO);
        return rspBO;
    }

    private void validateParams(SscAddSupplierAttachAbilityReqBO reqBO) {
        if (reqBO.getProjectId() == null) {
            throw new BusinessException("0001", "\u4f9b\u5e94\u5546\u9644\u4ef6\u5217\u8868\u65b0\u589eAPI \u3010projectId\u3011 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new BusinessException("0001", "\u4f9b\u5e94\u5546\u9644\u4ef6\u5217\u8868\u65b0\u589eAPI \u3010supplierId\u3011 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSupplierAttachType())) {
            throw new BusinessException("0001", "\u4f9b\u5e94\u5546\u9644\u4ef6\u5217\u8868\u65b0\u589eAPI \u3010supplierAttachType\u3011 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSscSupplierAttachBOs())) {
            throw new BusinessException("0001", "\u4f9b\u5e94\u5546\u9644\u4ef6\u5217\u8868\u65b0\u589eAPI \u3010sscSupplierAttachBOs\u3011 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SscProjectSupplierAttachBO bo : reqBO.getSscSupplierAttachBOs()) {
            if (!StringUtils.isBlank((CharSequence)bo.getSupplierAttachAddress())) continue;
            throw new BusinessException("0001", "\u4f9b\u5e94\u5546\u9644\u4ef6\u5217\u8868\u65b0\u589eAPI \u3010supplierAttachAddress\u3011 \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

