/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.common.SscSupplierIpExceptionBO;
import com.tydic.ssc.common.SscSupplierQuotationBO;
import com.tydic.ssc.dao.SscSupplierQuotationDAO;
import com.tydic.ssc.dao.po.SscSupplierQuotationPO;
import com.tydic.ssc.service.busi.SscSupplierIpVerifyBusiService;
import com.tydic.ssc.service.busi.bo.SscSupplierIpVerifyBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscSupplierIpVerifyBusiRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscSupplierIpVerifyBusiServiceImpl
implements SscSupplierIpVerifyBusiService {
    @Autowired
    private SscSupplierQuotationDAO sscSupplierQuotationDAO;
    @Value(value="${supplier.quotation.min.count}")
    private int supplierQuotationMinCount;

    @Override
    public SscSupplierIpVerifyBusiRspBO dealSupplierIpVerify(SscSupplierIpVerifyBusiReqBO reqBO) {
        List threeSameIpList;
        List fourSameIpList;
        SscSupplierIpVerifyBusiRspBO rspBO = new SscSupplierIpVerifyBusiRspBO();
        SscSupplierQuotationPO supplierQuotationPO = new SscSupplierQuotationPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)supplierQuotationPO);
        supplierQuotationPO.setQuotationStatus("1");
        List<SscSupplierQuotationPO> supplierQuotationPOS = this.sscSupplierQuotationDAO.getList(supplierQuotationPO);
        if (supplierQuotationPOS.size() < this.supplierQuotationMinCount) {
            rspBO.setQuotationCount(supplierQuotationPOS.size());
        }
        List<String> fourQuotationIps = new ArrayList<String>();
        SscSupplierQuotationPO sscSupplierQuotation = new SscSupplierQuotationPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)sscSupplierQuotation);
        List<SscSupplierQuotationBO> fourQuotationIpList = this.sscSupplierQuotationDAO.getFourQuotationIPList(sscSupplierQuotation);
        if (!CollectionUtils.isEmpty(fourQuotationIpList) && !CollectionUtils.isEmpty(fourSameIpList = fourQuotationIpList.stream().filter(e -> e.getCount() >= 2).collect(Collectors.toList()))) {
            fourQuotationIps = fourSameIpList.stream().map(SscSupplierQuotationBO::getQuotationIp).collect(Collectors.toList());
            SscSupplierQuotationPO fourQuotationPO = new SscSupplierQuotationPO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fourQuotationPO);
            fourQuotationPO.setQuotationIps(fourQuotationIps);
            fourQuotationPO.setQuotationStatus("1");
            List<SscSupplierQuotationPO> sscSupplierQuotationPOS = this.sscSupplierQuotationDAO.getList(fourQuotationPO);
            if (!CollectionUtils.isEmpty(sscSupplierQuotationPOS)) {
                ArrayList<SscSupplierIpExceptionBO> fourIpExceptionBOs = new ArrayList<SscSupplierIpExceptionBO>();
                for (SscSupplierQuotationPO quotationPO : sscSupplierQuotationPOS) {
                    SscSupplierIpExceptionBO sscSupplierIpExceptionBO = new SscSupplierIpExceptionBO();
                    sscSupplierIpExceptionBO.setSupplierId(quotationPO.getSupplierId());
                    sscSupplierIpExceptionBO.setSupplierName(quotationPO.getSupplierName());
                    fourIpExceptionBOs.add(sscSupplierIpExceptionBO);
                }
                rspBO.setFourIpExceptionBOs(fourIpExceptionBOs);
            }
        }
        SscSupplierQuotationPO sscSupplierQuotationPO = new SscSupplierQuotationPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)sscSupplierQuotationPO);
        sscSupplierQuotationPO.setQuotationIps(fourQuotationIps);
        List<SscSupplierQuotationBO> threeQuotationIPList = this.sscSupplierQuotationDAO.getThreeQuotationIPList(sscSupplierQuotationPO);
        if (!CollectionUtils.isEmpty(threeQuotationIPList) && !CollectionUtils.isEmpty(threeSameIpList = threeQuotationIPList.stream().filter(e -> e.getCount() >= 2).collect(Collectors.toList()))) {
            List<String> threeQuotationIps = threeSameIpList.stream().map(SscSupplierQuotationBO::getQuotationIp).collect(Collectors.toList());
            SscSupplierQuotationPO threeQuotationPO = new SscSupplierQuotationPO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)threeQuotationPO);
            threeQuotationPO.setQuotationIps(fourQuotationIps);
            threeQuotationPO.setQuotationIpsLike(threeQuotationIps);
            List<SscSupplierQuotationPO> sscSupplierQuotationPOS = this.sscSupplierQuotationDAO.getListWithQuotationIp(threeQuotationPO);
            if (!CollectionUtils.isEmpty(sscSupplierQuotationPOS)) {
                ArrayList<SscSupplierIpExceptionBO> threeIpExceptionBOs = new ArrayList<SscSupplierIpExceptionBO>();
                for (SscSupplierQuotationPO quotationPO : sscSupplierQuotationPOS) {
                    SscSupplierIpExceptionBO sscSupplierIpExceptionBO = new SscSupplierIpExceptionBO();
                    sscSupplierIpExceptionBO.setSupplierName(quotationPO.getSupplierName());
                    sscSupplierIpExceptionBO.setSupplierId(quotationPO.getSupplierId());
                    threeIpExceptionBOs.add(sscSupplierIpExceptionBO);
                }
                rspBO.setThreeIpExceptionBOs(threeIpExceptionBOs);
            }
        }
        if (CollectionUtils.isEmpty(rspBO.getThreeIpExceptionBOs()) && CollectionUtils.isEmpty(rspBO.getFourIpExceptionBOs())) {
            rspBO.setIPException(false);
        } else {
            rspBO.setIPException(true);
        }
        rspBO.setRespDesc("\u4f9b\u5e94\u5546IP\u6821\u9a8c\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

