/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectAttachBO;
import com.tydic.ssc.common.SscProjectDetailBO;
import com.tydic.ssc.common.SscProjectExtBO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectDetailExtDAO;
import com.tydic.ssc.dao.SscProjectExtDAO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.dao.po.SscProjectDetailExtPO;
import com.tydic.ssc.dao.po.SscProjectExtPO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryProjectDetailListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProjectDetailListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProjectDetailListBusiRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryProjectDetailListBusiServiceImpl
implements SscQryProjectDetailListBusiService {
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscProjectExtDAO sscProjectExtDAO;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;
    @Autowired
    private SscProjectDetailExtDAO sscProjectDetailExtDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryProjectDetailListBusiRspBO qryProjectDetailList(SscQryProjectDetailListBusiReqBO reqBO) {
        Map<Long, List<SscProjectAttachPO>> projectDetailAttach;
        String jsonString;
        Map<Long, List<SscProjectExtPO>> projectDetailExt;
        List<SscProjectDetailBO> projectDetailList;
        SscQryProjectDetailListBusiRspBO rspBO = new SscQryProjectDetailListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (reqBO.getQueryPageFlag().booleanValue()) {
            projectDetailList = this.sscProjectDetailDAO.getProjectDetailList(reqBO, (Page<SscProjectDetailBO>)page);
        } else {
            page.setPageNo(-1);
            page.setPageSize(-1);
            projectDetailList = this.sscProjectDetailDAO.getProjectDetailList(reqBO, (Page<SscProjectDetailBO>)page);
        }
        if (CollectionUtils.isEmpty(projectDetailList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u9879\u76ee\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        for (SscProjectDetailBO bo : projectDetailList) {
            SscProjectDetailExtPO qryParam = new SscProjectDetailExtPO();
            qryParam.setProjectDetailId(bo.getProjectDetailId());
            SscProjectDetailExtPO qryResult = this.sscProjectDetailExtDAO.getModelBy(qryParam);
            if (null == qryResult) continue;
            bo.setUseDepartmentCode(qryResult.getField8Value());
            bo.setUseDepartmentId(qryResult.getField1Value());
            bo.setUseDepartmentName(qryResult.getField2Value());
            bo.setField8Value(qryResult.getField3Value());
            bo.setField9Value(qryResult.getField4Value());
            bo.setField10Value(qryResult.getField5Value());
            bo.setBuyerId(qryResult.getField6Value());
            bo.setBuyerName(qryResult.getField7Value());
        }
        List<Long> projectDetailIds = projectDetailList.stream().map(SscProjectDetailBO::getProjectDetailId).collect(Collectors.toList());
        if (reqBO.getQueryExtInfo().booleanValue() && null != (projectDetailExt = this.getProjectDetailExt(reqBO, projectDetailIds))) {
            for (SscProjectDetailBO sscProjectDetailBO : projectDetailList) {
                List<SscProjectExtPO> sscProjectExtPOS = projectDetailExt.get(sscProjectDetailBO.getProjectDetailId());
                if (CollectionUtils.isEmpty(sscProjectExtPOS)) continue;
                jsonString = JSON.toJSONString(sscProjectExtPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                List sscProjectExtBOS = JSON.parseArray((String)jsonString, SscProjectExtBO.class);
                sscProjectDetailBO.setSscProjectExtBOs(sscProjectExtBOS);
            }
        }
        if (reqBO.getQueryAttachFlag().booleanValue() && null != (projectDetailAttach = this.getProjectDetailAttach(reqBO, projectDetailIds))) {
            for (SscProjectDetailBO sscProjectDetailBO : projectDetailList) {
                List<SscProjectAttachPO> sscProjectAttachPOS = projectDetailAttach.get(sscProjectDetailBO.getProjectDetailId());
                if (CollectionUtils.isEmpty(sscProjectAttachPOS)) continue;
                jsonString = JSON.toJSONString(sscProjectAttachPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                List sscProjectAttachBOS = JSON.parseArray((String)jsonString, SscProjectAttachBO.class);
                sscProjectDetailBO.setSscProjectAttachBOs(sscProjectAttachBOS);
            }
        }
        Map<String, String> purchaserProductMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASER_PRODUCT_SCOPE");
        for (SscProjectDetailBO bo : projectDetailList) {
            if (!StringUtils.isNotBlank((CharSequence)bo.getProjectDetailExtField2())) continue;
            bo.setProjectDetailExtField2Str(purchaserProductMap.get(bo.getProjectDetailExtField2()));
        }
        rspBO.setRows(projectDetailList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespDesc("\u9879\u76ee\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private Map<Long, List<SscProjectExtPO>> getProjectDetailExt(SscQryProjectDetailListBusiReqBO reqBO, List<Long> projectDetailIds) {
        SscProjectExtPO sscProjectExtPO = new SscProjectExtPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)sscProjectExtPO);
        sscProjectExtPO.setProjectObjectType("8");
        sscProjectExtPO.setProjectObjectIds(projectDetailIds);
        List<SscProjectExtPO> sscProjectExtPOS = this.sscProjectExtDAO.getList(sscProjectExtPO);
        HashMap<Long, List<SscProjectExtPO>> extPOMap = new HashMap<Long, List<SscProjectExtPO>>(16);
        if (!CollectionUtils.isEmpty(sscProjectExtPOS)) {
            for (SscProjectExtPO projectExtPO : sscProjectExtPOS) {
                List<SscProjectExtPO> extPOList = new ArrayList<SscProjectExtPO>();
                Long projectObjectId = projectExtPO.getProjectObjectId();
                if (extPOMap.containsKey(projectObjectId)) {
                    extPOList = (List)extPOMap.get(projectObjectId);
                }
                extPOList.add(projectExtPO);
                extPOMap.put(projectObjectId, extPOList);
            }
        }
        return extPOMap;
    }

    private Map<Long, List<SscProjectAttachPO>> getProjectDetailAttach(SscQryProjectDetailListBusiReqBO reqBO, List<Long> projectDetailIds) {
        SscProjectAttachPO sscProjectAttachPO = new SscProjectAttachPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)sscProjectAttachPO);
        sscProjectAttachPO.setProjectObjectType("8");
        sscProjectAttachPO.setProjectObjectIds(projectDetailIds);
        List<SscProjectAttachPO> projectAttachPOS = this.sscProjectAttachDAO.getList(sscProjectAttachPO);
        HashMap<Long, List<SscProjectAttachPO>> attachPOMap = new HashMap<Long, List<SscProjectAttachPO>>(16);
        if (!CollectionUtils.isEmpty(projectAttachPOS)) {
            for (SscProjectAttachPO projectAttachPO : projectAttachPOS) {
                List<SscProjectAttachPO> attachPOList = new ArrayList<SscProjectAttachPO>();
                Long projectObjectId = projectAttachPO.getProjectObjectId();
                if (attachPOMap.containsKey(projectObjectId)) {
                    attachPOList = (List)attachPOMap.get(projectObjectId);
                }
                attachPOList.add(projectAttachPO);
                attachPOMap.put(projectObjectId, attachPOList);
            }
        }
        return attachPOMap;
    }
}

