/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.ability.bo.SscQryProjectDetailQuotationListAbilityReqBO;
import com.tydic.ssc.common.SscProjectDetailQuotationBO;
import com.tydic.ssc.dao.SscQryProjectDetailQuotationListDAO;
import com.tydic.ssc.dao.po.SscQryProjectDetailQuotationListBusiPO;
import com.tydic.ssc.service.busi.SscQryProjectDetailQuotationListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProjectDetailQuotationListBusiRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SscQryProjectDetailQuotationListBusiServiceImpl
implements SscQryProjectDetailQuotationListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscQryProjectDetailQuotationListBusiServiceImpl.class);
    @Autowired
    private SscQryProjectDetailQuotationListDAO sscQryProjectDetailQuotationListDAO;

    @Override
    public SscQryProjectDetailQuotationListBusiRspBO qryProjectDetailQuotationList(SscQryProjectDetailQuotationListAbilityReqBO reqBO) {
        SscQryProjectDetailQuotationListBusiRspBO rspBO = new SscQryProjectDetailQuotationListBusiRspBO();
        SscQryProjectDetailQuotationListBusiPO busiReqPO = new SscQryProjectDetailQuotationListBusiPO();
        busiReqPO.setProjectId(reqBO.getProjectId());
        busiReqPO.setSupplierId(reqBO.getSupplierId());
        busiReqPO.setStageId(reqBO.getStageId());
        busiReqPO.setQuotationRound(reqBO.getQuotationRound());
        if (reqBO.getQueryType() == null) {
            busiReqPO.setQueryType(1);
        } else {
            busiReqPO.setQueryType(reqBO.getQueryType());
        }
        busiReqPO.setProjectDetailIds(reqBO.getProjectDetailIds());
        if (!reqBO.getQueryPageFlag().booleanValue()) {
            reqBO.setPageNo(Integer.valueOf(-1));
            reqBO.setPageSize(Integer.valueOf(-1));
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectDetailQuotationBO> list = this.sscQryProjectDetailQuotationListDAO.getProjectDetailQuotationList(busiReqPO, (Page<SscQryProjectDetailQuotationListBusiPO>)page);
        log.debug("\u62a5\u4ef7\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c{}", (Object)JSON.toJSONString(list));
        ArrayList<SscProjectDetailQuotationBO> resultList = new ArrayList<SscProjectDetailQuotationBO>();
        if (!CollectionUtils.isEmpty(list)) {
            for (SscProjectDetailQuotationBO bo : list) {
                SscProjectDetailQuotationBO po = new SscProjectDetailQuotationBO();
                BeanUtils.copyProperties((Object)bo, (Object)po);
                if (null != bo.getBugetUnitPrice()) {
                    BigDecimal bugetUnitPriceBigDecimal = new BigDecimal(bo.getBugetUnitPrice());
                    po.setBugetUnitPriceBigDecimal(bugetUnitPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getBugetTotalPrice()) {
                    BigDecimal bugetTotalPriceBigDecimal = new BigDecimal(bo.getBugetTotalPrice());
                    po.setBugetTotalPriceBigDecimal(bugetTotalPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getQuotationUnitPrice()) {
                    BigDecimal quotationUnitPriceBigDecimal = new BigDecimal(bo.getQuotationUnitPrice());
                    po.setQuotationUnitPriceBigDecimal(quotationUnitPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getTotalQuotationPrice()) {
                    BigDecimal totalQuotationPriceBigDecimal = new BigDecimal(bo.getTotalQuotationPrice());
                    po.setTotalQuotationPriceBigDecimal(totalQuotationPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (StringUtils.isEmpty((Object)bo.getBuyerId())) {
                    po.setBuyerId(bo.getBuyerId());
                }
                if (StringUtils.isEmpty((Object)bo.getBuyerName())) {
                    po.setBuyerName(bo.getBuyerName());
                }
                if (StringUtils.isEmpty((Object)bo.getField8Value())) {
                    po.setField8Value(bo.getField8Value());
                }
                if (StringUtils.isEmpty((Object)bo.getField9Value())) {
                    po.setField9Value(bo.getField9Value());
                }
                if (StringUtils.isEmpty((Object)bo.getField10Value())) {
                    po.setField10Value(bo.getField10Value());
                }
                resultList.add(po);
            }
        }
        rspBO.setRows(resultList);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u660e\u7ec6\u4f9b\u5e94\u5546\u62a5\u4ef7\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

