/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.service.busi.SscErpUpdateProjectStatusBusiService;
import com.tydic.ssc.service.busi.SscSendMessageBusiService;
import com.tydic.ssc.service.busi.bo.SscErpUpdateProjectStatusBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscErpUpdateProjectStatusBusiRspBO;
import com.tydic.ssc.service.busi.bo.SscSendMessageReqBO;
import com.tydic.ssc.service.busi.bo.SscSendMessageRspBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscErpUpdateProjectStatusBusiServiceImpl
implements SscErpUpdateProjectStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscErpUpdateProjectStatusBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private SscSendMessageBusiService sscSendMessageBusiService;
    @Value(value="${ZTBProjectVfCodeTemplateCode}")
    private String ZTBProjectVfCodeTemplateCode;
    @Value(value="${XBJProjectVfCodeTemplateCode}")
    private String XBJProjectVfCodeTemplateCode;
    @Value(value="${isSendMsg}")
    private boolean isSendMsg;

    @Override
    public SscErpUpdateProjectStatusBusiRspBO erpUpdateProjectStatus(SscErpUpdateProjectStatusBusiReqBO reqBO) {
        SscErpUpdateProjectStatusBusiRspBO rspBO = new SscErpUpdateProjectStatusBusiRspBO();
        SscProjectPO qryParam = new SscProjectPO();
        qryParam.setProjectId(reqBO.getProjectId());
        SscProjectPO qryResult = this.sscProjectDAO.getModelBy(qryParam);
        if (qryResult == null) {
            throw new BusinessException("0000", "\u9879\u76ee\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        log.info("projectStatus=====================" + qryResult.getProjectStatus());
        if (qryResult.getProjectStatus().equals("2")) {
            log.info("erp\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7\uff0c\u56de\u8c03\u4fee\u6539\u9879\u76ee\u72b6\u6001");
            if ("2".equals(qryResult.getTenderMode()) && "4".equals(reqBO.getProjectStatus())) {
                reqBO.setProjectStatus("5");
            }
            SscProjectPO updateParam = new SscProjectPO();
            updateParam.setProjectId(reqBO.getProjectId());
            updateParam.setProjectStatus(reqBO.getProjectStatus());
            updateParam.setProjectExtField5(DateUtils.dateToStr((Date)reqBO.getApproveTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            int updateResult = this.sscProjectDAO.updateByPrimaryKeySelective(updateParam);
            if (updateResult < 1) {
                throw new BusinessException("8888", "\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
            }
            if (this.isSendMsg && reqBO.getProjectStatus().equals("5") && "2".equals(qryResult.getTenderMode())) {
                SscProjectSupplierPO projectSupplierPO = new SscProjectSupplierPO();
                projectSupplierPO.setProjectId(reqBO.getProjectId());
                List<SscProjectSupplierPO> projectSupplierList = this.sscProjectSupplierDAO.getList(projectSupplierPO);
                if (!CollectionUtils.isEmpty(projectSupplierList)) {
                    for (SscProjectSupplierPO projectSupplier : projectSupplierList) {
                        UmcQrySupplierInfoDetailAbilityReqBO toUmcParam = new UmcQrySupplierInfoDetailAbilityReqBO();
                        toUmcParam.setSupplierId(projectSupplier.getSupplierId());
                        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4f9b\u5e94\u5546\u8be6\u60c5\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)toUmcParam));
                        UmcQrySupplierInfoDetailAbilityRspBO umcResult = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(toUmcParam);
                        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)umcResult));
                        if (!"0000".equals(umcResult.getRespCode())) {
                            throw new BusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38\uff1a" + umcResult.getRespDesc());
                        }
                        String phoneNumber = umcResult.getPhoneNumber();
                        HashMap<String, String> templateParamMap = new HashMap<String, String>();
                        templateParamMap.put("supplierName", umcResult.getSupplierName());
                        templateParamMap.put("orgName", qryResult.getPurchaseUnitName());
                        templateParamMap.put("bidname", qryResult.getProjectName());
                        String templateCode = "";
                        if ("1".equals(qryResult.getPurchaseMode())) {
                            templateCode = this.ZTBProjectVfCodeTemplateCode;
                        } else if ("2".equals(qryResult.getPurchaseMode())) {
                            templateCode = this.XBJProjectVfCodeTemplateCode;
                        } else {
                            throw new BusinessException("0001", "\u91c7\u8d2d\u65b9\u5f0f\u975e\u6cd5");
                        }
                        this.sendSms(phoneNumber, templateParamMap, templateCode);
                    }
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u6210\u529f");
        return rspBO;
    }

    private void sendSms(String mobile, Map<String, String> templateParamMap, String templateCode) {
        SscSendMessageReqBO reqBO = new SscSendMessageReqBO();
        reqBO.setPhoneNumbers(mobile);
        reqBO.setTemplateCode(templateCode);
        reqBO.setTemplateParam(JSONObject.toJSONString(templateParamMap));
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u9879\u76ee\u9a8c\u8bc1\u7801\u53d1\u9001\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        SscSendMessageRspBO rspBO = this.sscSendMessageBusiService.sendMessgae(reqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u9879\u76ee\u9a8c\u8bc1\u7801\u53d1\u9001\u901a\u77e5\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)rspBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException(rspBO.getRespCode(), "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a" + rspBO.getRespDesc());
        }
    }
}

