/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscApprovalProjectBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryApprovalProjectListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryApprovalProjectListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryApprovalProjectListBusiRspBO;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscQryApprovalProjectListBusiServiceImpl
implements SscQryApprovalProjectListBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryApprovalProjectListBusiRspBO qryApprovalProjectList(SscQryApprovalProjectListBusiReqBO busiReqBO) {
        SscQryApprovalProjectListBusiRspBO rsp = new SscQryApprovalProjectListBusiRspBO();
        if (!busiReqBO.getQueryPageFlag().booleanValue()) {
            busiReqBO.setPageNo(-1);
            busiReqBO.setPageSize(-1);
        }
        if ("0".equals(busiReqBO.getApprovalStatus())) {
            busiReqBO.setTaskState(100);
            busiReqBO.setAuditResult(null);
        } else if ("1".equals(busiReqBO.getApprovalStatus())) {
            busiReqBO.setTaskState(102);
            busiReqBO.setAuditResult(0);
        } else if ("2".equals(busiReqBO.getApprovalStatus())) {
            busiReqBO.setTaskState(102);
            busiReqBO.setAuditResult(1);
        }
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        List<SscApprovalProjectBO> rows = this.sscProjectDAO.getListPageWithProjectApproval(busiReqBO, (Page<SscApprovalProjectBO>)page);
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
        Map<String, String> approvalStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "APPROVAL_STATUS");
        for (SscApprovalProjectBO bo : rows) {
            if (StringUtils.isNotBlank((CharSequence)bo.getTenderMode())) {
                bo.setTenderModeStr(tenderModeMap.get(bo.getTenderMode()));
            }
            if (100 == bo.getTaskState()) {
                bo.setApprovalStatus("0");
            } else if (102 == bo.getTaskState()) {
                if (0 == bo.getAuditResult()) {
                    bo.setApprovalStatus("1");
                } else if (1 == bo.getAuditResult()) {
                    bo.setApprovalStatus("2");
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)bo.getApprovalStatus())) continue;
            bo.setApprovalStatusStr(approvalStatusMap.get(bo.getApprovalStatus()));
        }
        rsp.setPageNo(page.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9879\u76ee\u5ba1\u6279\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }
}

