/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectOperateRecordDAO;
import com.tydic.ssc.dao.po.SscProjectOperateRecordPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.service.busi.SscExtendBidEndTimeService;
import com.tydic.ssc.service.busi.bo.SscExtendBidEndTimeReqBO;
import com.tydic.ssc.service.busi.bo.SscExtendBidEndTimeRspBO;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscExtendBidEndTimeServiceImpl
implements SscExtendBidEndTimeService {
    private static final Logger log = LoggerFactory.getLogger(SscExtendBidEndTimeServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectOperateRecordDAO sscProjectOperateRecordDAO;

    @Override
    public SscExtendBidEndTimeRspBO extendBidEndTime(SscExtendBidEndTimeReqBO bo) {
        SscProjectPO po = this.sscProjectDAO.selectByPrimaryKey(bo.getProjectId());
        if (po == null) {
            throw new BusinessException("8888", "\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (bo.getBidEndTime() == null) {
            throw new BusinessException("8888", "\u5ef6\u8fdf\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (po.getBidEndTime() != null && bo.getBidEndTime().getTime() < po.getBidEndTime().getTime()) {
            throw new BusinessException("8888", "\u5ef6\u8fdf\u65f6\u95f4\u5c0f\u4e8e\u539f\u7ed3\u675f\u65f6\u95f4");
        }
        if (!("5".equals(po.getProjectStatus()) || "6".equals(po.getProjectStatus()) || "8".equals(po.getProjectStatus()))) {
            throw new BusinessException("8888", "\u9879\u76ee\u4e0d\u5728\u62a5\u4ef7\u4e2d\u72b6\u6001");
        }
        if ("1".equals(po.getCompareType())) {
            if ("1".equals(po.getIsPark())) {
                throw new BusinessException("8888", "\u9879\u76ee\u5df2\u62c6\u5c01\uff0c\u4e0d\u80fd\u5ef6\u65f6\u62a5\u4ef7");
            }
        } else if (!"2".equals(po.getCompareType())) {
            throw new BusinessException("8888", "\u9879\u76ee\u6bd4\u4ef7\u7c7b\u578b\u4e3a\u7a7a");
        }
        Date now = new Date();
        SscProjectPO sscProjectPO = new SscProjectPO();
        sscProjectPO.setProjectId(bo.getProjectId());
        sscProjectPO.setBidEndTime(bo.getBidEndTime());
        sscProjectPO.setProjectUpdateId(bo.getUserId());
        sscProjectPO.setProjectUpdateName(bo.getName());
        sscProjectPO.setProjectUpdateTime(now);
        if ("6".equals(po.getProjectStatus())) {
            sscProjectPO.setProjectStatus("2".equals(po.getProjectExtField4()) ? "8" : "5");
        }
        this.sscProjectDAO.updateByPrimaryKeySelective(sscProjectPO);
        Long operNum = 0L;
        if (StringUtils.isNotEmpty((String)po.getProjectExtField4())) {
            operNum = Long.parseLong(po.getProjectExtField4());
        }
        SscProjectOperateRecordPO recordPO = new SscProjectOperateRecordPO();
        String msg = "\u5ef6\u65f6\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u81f3";
        if (operNum == 2L) {
            msg = "\u53d1\u8d77\u4e8c\u6b21\u8be2\u4ef7\u622a\u6b62\u65f6\u95f4\u81f3";
        }
        recordPO.setOperateContent(msg + DateFormatUtils.format((Date)bo.getBidEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        recordPO.setOperTime(now);
        recordPO.setOperNo(bo.getUserId());
        recordPO.setOperType("YS");
        recordPO.setOperName(bo.getName());
        recordPO.setProjectId(bo.getProjectId());
        recordPO.setOperateReason(bo.getReason());
        recordPO.setOperNum(operNum);
        this.sscProjectOperateRecordDAO.insertSscProjectOperateRecord(recordPO);
        SscExtendBidEndTimeRspBO rspBO = new SscExtendBidEndTimeRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ef6\u8fdf\u62a5\u4ef7\u6210\u529f");
        return rspBO;
    }
}

