/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectNoticeInfoBO;
import com.tydic.ssc.common.SscQryProjectNoticeBO;
import com.tydic.ssc.dao.SscProjectNoticeDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryProjectNoticeListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryNoticeListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProjectNoticeListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProjectNoticeListBusiRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscQryProjectNoticeListBusiServiceImpl
implements SscQryProjectNoticeListBusiService {
    @Autowired
    private SscProjectNoticeDAO sscProjectNoticeDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryProjectNoticeListBusiRspBO qryProjectNoticeList(SscQryProjectNoticeListBusiReqBO reqBO) {
        SscQryProjectNoticeListBusiRspBO rspBO = new SscQryProjectNoticeListBusiRspBO();
        ArrayList<SscQryProjectNoticeBO> rows = new ArrayList<SscQryProjectNoticeBO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SscQryNoticeListBusiReqBO qryParam = new SscQryNoticeListBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)qryParam));
        if (StringUtils.isEmpty((Object)reqBO.getPurchaseMode())) {
            qryParam.setPurchaseMode("1");
        }
        List<Object> noticeList = new ArrayList();
        noticeList = "1".equals(qryParam.getIsPublic()) ? this.sscProjectNoticeDAO.getNoticeList(qryParam, (Page<SscProjectNoticeInfoBO>)page) : this.sscProjectNoticeDAO.getNoticeEndList(qryParam, (Page<SscProjectNoticeInfoBO>)page);
        if (CollectionUtils.isEmpty(noticeList)) {
            rspBO.setPageNo(0);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u9879\u76ee\u516c\u544a\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        List<Long> projectIds = noticeList.stream().map(SscProjectNoticeInfoBO::getProjectId).collect(Collectors.toList());
        SscProjectSupplierPO sscProjectSupplier = new SscProjectSupplierPO();
        sscProjectSupplier.setProjectIds(projectIds);
        List<SscProjectSupplierPO> sscProjectSupplierList = this.sscProjectSupplierDAO.getList(sscProjectSupplier);
        Map<String, String> projectNoticeTypeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_NOTICE_TYPE");
        Map<String, String> purchaserModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_WAY");
        for (SscProjectNoticeInfoBO sscProjectNoticeInfoBO : noticeList) {
            SscQryProjectNoticeBO noticeBO = new SscQryProjectNoticeBO();
            BeanUtils.copyProperties((Object)sscProjectNoticeInfoBO, (Object)noticeBO);
            if (!StringUtils.isEmpty((Object)sscProjectNoticeInfoBO.getNoticeType())) {
                noticeBO.setNoticeTypeStr(projectNoticeTypeMap.get(sscProjectNoticeInfoBO.getNoticeType()));
            }
            if (!StringUtils.isEmpty((Object)sscProjectNoticeInfoBO.getPurchaseMode())) {
                noticeBO.setPurchaseModeStr(purchaserModeMap.get(sscProjectNoticeInfoBO.getPurchaseMode()));
            }
            if (!StringUtils.isEmpty((Object)sscProjectNoticeInfoBO.getTenderMode())) {
                noticeBO.setTenderModeStr(tenderModeMap.get(sscProjectNoticeInfoBO.getTenderMode()));
            }
            if (null != sscProjectNoticeInfoBO.getProjectExtField4() && Integer.valueOf(sscProjectNoticeInfoBO.getProjectExtField4()) > 1) {
                for (SscProjectSupplierPO sscProjectSupplierPO : sscProjectSupplierList) {
                    if (!sscProjectNoticeInfoBO.getProjectId().equals(sscProjectSupplierPO.getProjectId()) || !sscProjectSupplierPO.getSupplierId().equals(reqBO.getSupplierId()) || sscProjectSupplierPO.getQuotationRound() <= 1) continue;
                    noticeBO.setShowTowQuotation(Boolean.TRUE);
                }
            }
            rows.add(noticeBO);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u516c\u544a\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

