/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tanggula.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.tanggula.TanggulaClient;
import com.tydic.tanggula.advice.TanggulaLogAdvice;
import com.tydic.tanggula.properties.TanggulaProperties;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import com.tydic.tanggula.service.impl.TanggulaUserOperLogAbleImpl;
import com.tydic.tanggula.util.TanggulaLogCollectAbleManager;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnProperty(prefix="tanggula.client", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={TanggulaProperties.class})
public class TanggulaClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TanggulaClientConfiguration.class);
    private static final String POINT_CUT_EXPRESSION = "execution(* (@HTServiceImpl * || @Controller *)..*(..))";
    private TanggulaProperties properties;
    private CacheClient cacheClient;

    public TanggulaClientConfiguration(TanggulaProperties properties, CacheClient cacheClient) {
        this.cacheClient = cacheClient;
        this.properties = properties;
    }

    @Order(value=-1)
    @Bean(value={"pluginProvider"}, initMethod="startup", destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={ProxyProducerFactoryBean.class})
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        DefaultProxyMessageConfig config = new DefaultProxyMessageConfig();
        config.setId("");
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)config);
        return proxyProducerFactoryBean;
    }

    @Bean
    @Order(value=-2)
    public TanggulaUserOperLogAbleImpl tanggulaUserOperLogAbleImpl() {
        TanggulaUserOperLogAbleImpl tanggulaUserOperLogAble = new TanggulaUserOperLogAbleImpl(this.cacheClient);
        return tanggulaUserOperLogAble;
    }

    @Bean
    @Order(value=-3)
    public TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager(TanggulaUserOperLogAbleImpl tanggulaUserOperLogAble) {
        TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager = new TanggulaLogCollectAbleManager();
        tanggulaLogCollectAbleManager.registerLogCollectionAble((TanggulaLogCollectAble)tanggulaUserOperLogAble);
        return tanggulaLogCollectAbleManager;
    }

    @Order(value=-4)
    @Bean(value={"tanggulaClient"})
    public TanggulaClient tanggulaClient(ProxyMessageProducer pluginProvider, TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager) {
        TanggulaClient tanggulaClient = new TanggulaClient(pluginProvider, tanggulaLogCollectAbleManager);
        return tanggulaClient;
    }

    @Bean
    @Order(value=-5)
    public AspectJExpressionPointcutAdvisor userOperateLogRecordAdvisor(TanggulaClient tanggulaClient) {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        advisor.setExpression(POINT_CUT_EXPRESSION);
        advisor.setAdvice((Advice)new TanggulaLogAdvice(tanggulaClient, this.properties));
        advisor.setOrder(0x7FFFFF37);
        return advisor;
    }
}

