/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tanggula.advice;

import com.tydic.tanggula.TanggulaClient;
import com.tydic.tanggula.dto.TanggulaMethodParamDTO;
import com.tydic.tanggula.enums.TanggulaResultCodeEnum;
import com.tydic.tanggula.properties.TanggulaProperties;
import com.tydic.tanggula.result.TanggulaResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class TanggulaLogAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TanggulaLogAdvice.class);
    private TanggulaClient tanggulaClient;
    private TanggulaProperties properties;
    private static final String SPLIT_SEPARATOR = ",";

    public TanggulaLogAdvice(TanggulaClient tanggulaClient, TanggulaProperties properties) {
        this.tanggulaClient = tanggulaClient;
        this.properties = properties;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        HashMap<String, Object> inputMap = new HashMap<String, Object>(16);
        HashMap<String, Object> outputMap = new HashMap<String, Object>(16);
        this.dealInArgument(invocation.getArguments(), inputMap);
        Object rspObj = invocation.proceed();
        this.dealObject(rspObj, outputMap);
        String logMethodsStr = this.properties.getLogMethods();
        List<Object> logMethods = new ArrayList();
        try {
            logMethods = Arrays.stream(logMethodsStr.split(SPLIT_SEPARATOR)).map(Long::valueOf).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u91c7\u96c6\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        TanggulaMethodParamDTO methodParamDTO = TanggulaMethodParamDTO.builder().serviceCode(invocation.getMethod().getDeclaringClass().getName()).methodCode(invocation.getMethod().getName()).topic(this.properties.getTanggulaLogTopic()).tag(this.properties.getTanggulaLogTag()).inputMap(inputMap).outputMap(outputMap).logMethods(logMethods).build();
        TanggulaResult result = null;
        try {
            result = this.tanggulaClient.execute(methodParamDTO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (ObjectUtils.isEmpty((Object)result) || !TanggulaResultCodeEnum.SUCCESS.getCode().equals(result.getCode())) {
            log.error("\u65e5\u5fd7\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)result.getMessage());
        }
        return rspObj;
    }

    private void dealInArgument(Object[] arguments, Map<String, Object> map) throws Throwable {
        if (arguments != null) {
            for (Object arg : arguments) {
                this.dealObject(arg, map);
            }
        }
    }

    private void dealObject(Object dealObject, Map<String, Object> fieldValueMap) throws Throwable {
        List<Field> fields = TanggulaLogAdvice.getAllField(dealObject.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            String fieldName = f.getName();
            if (null == f.get(dealObject)) continue;
            Object fieldValue = f.get(dealObject);
            fieldValueMap.put(fieldName, fieldValue);
        }
    }

    private static List<Field> getAllField(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

