/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tanggula.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.RedisCacheStore;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.tanggula.TanggulaClient;
import com.tydic.tanggula.advice.TanggulaLogAdvice;
import com.tydic.tanggula.properties.TanggulaProperties;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import com.tydic.tanggula.service.impl.TanggulaUserOperLogAbleImpl;
import com.tydic.tanggula.util.TanggulaLogCollectAbleManager;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="tanggula.client", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={TanggulaProperties.class})
public class TanggulaClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TanggulaClientConfiguration.class);
    private static final String PACKAGE_DELIMITER = ",";
    private TanggulaProperties properties;
    private CacheClient cacheClient;

    public TanggulaClientConfiguration(TanggulaProperties properties, CacheClient cacheClient) {
        this.cacheClient = cacheClient;
        this.properties = properties;
    }

    @Bean(value={"pluginProvider"}, initMethod="startup", destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={ProxyProducerFactoryBean.class})
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        DefaultProxyMessageConfig config = new DefaultProxyMessageConfig();
        config.setId(this.properties.getTanggulaLogPid());
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)config);
        return proxyProducerFactoryBean;
    }

    @Bean
    public RedisCacheStore redisCacheStore() {
        RedisCacheStore redisCacheStore = new RedisCacheStore();
        return redisCacheStore;
    }

    @Bean
    public TanggulaUserOperLogAbleImpl tanggulaUserOperLogAbleImpl() {
        TanggulaUserOperLogAbleImpl tanggulaUserOperLogAble = new TanggulaUserOperLogAbleImpl(this.cacheClient);
        return tanggulaUserOperLogAble;
    }

    @Bean
    public TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager(TanggulaUserOperLogAbleImpl tanggulaUserOperLogAble) {
        TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager = new TanggulaLogCollectAbleManager();
        tanggulaLogCollectAbleManager.registerLogCollectionAble((TanggulaLogCollectAble)tanggulaUserOperLogAble);
        return tanggulaLogCollectAbleManager;
    }

    @Bean(value={"tanggulaClient"})
    @DependsOn(value={"pluginProvider"})
    public TanggulaClient tanggulaClient(@Qualifier(value="pluginProvider") ProxyMessageProducer pluginProvider, TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager) {
        TanggulaClient tanggulaClient = new TanggulaClient(pluginProvider, tanggulaLogCollectAbleManager);
        return tanggulaClient;
    }

    @Bean
    public AspectJExpressionPointcutAdvisor userOperateLogRecordAdvisor(TanggulaClient tanggulaClient) {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.properties.getPointcutPackages())) {
            if (this.properties.getPointcutPackages().contains(PACKAGE_DELIMITER)) {
                String[] nativeRpcPackageSplit;
                for (String nativeRpcPackageString : nativeRpcPackageSplit = this.properties.getPointcutPackages().split(PACKAGE_DELIMITER)) {
                    if (!StringUtils.hasText((String)nativeRpcPackageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                        continue;
                    }
                    expressionBuilder.append(" || (execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(this.properties.getPointcutPackages()).append("..*(..)))");
            }
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setExpression(expression);
        advisor.setAdvice((Advice)new TanggulaLogAdvice(tanggulaClient, this.properties));
        advisor.setOrder(0x7FFFFF37);
        return advisor;
    }
}

