package com.tydic.tanggula;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.tanggula.bo.TanggulaDealLogCollectRspBO;
import com.tydic.tanggula.dto.TanggulaMethodParamDTO;
import com.tydic.tanggula.enums.TanggulaResultCodeEnum;
import com.tydic.tanggula.result.TanggulaResult;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import com.tydic.tanggula.util.TanggulaLogCollectAbleManager;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题：类名称:TanggulaClient
 * 说明：描述一下类的作用TODO
 * 时间：2024/1/29 11:32
 * 作者 @author yyd
 */
@Slf4j
public class TanggulaClient {

    private TanggulaLogCollectAbleManager logCollectAbleManager;

    private ProxyMessageProducer pluginProvider;

    private String apiUrl;

    private static final String SEND_OK = "SEND_OK";


    public TanggulaClient(ProxyMessageProducer pluginProvider, TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager, String apiUrl){
        this.pluginProvider = pluginProvider;
        this.logCollectAbleManager = tanggulaLogCollectAbleManager;
        this.apiUrl = apiUrl;
    }

    public TanggulaResult execute(TanggulaMethodParamDTO dto){
        TanggulaResult tanggulaResult = new TanggulaResult(TanggulaResultCodeEnum.SUCCESS);

        dto.setQryGenObjNameListApi(apiUrl);

        List<Long> logMethods = dto.getLogMethods();
        if (CollectionUtils.isEmpty(logMethods)){
            tanggulaResult.buildFail("未配置日志采集能力");
            return tanggulaResult;
        }

        for (Long logMethod : logMethods){
            TanggulaLogCollectAble logCollcetionAble = logCollectAbleManager.getLogCollcetionAble(logMethod);
            TanggulaDealLogCollectRspBO collectRspBO = logCollcetionAble.doCollect(dto);
            if (!TanggulaResultCodeEnum.SUCCESS.getCode().equals(collectRspBO.getCode())){
               log.info("未配置推送：{},", logMethod);
            }else {
                log.info("开始发送日志消息：{}", JSON.toJSONString(collectRspBO));
                ProxyMessage proxyMessage = new ProxyMessage(dto.getTopic(), dto.getTag(), JSON.toJSONString(collectRspBO));
                ProxySendResult sendResult = pluginProvider.send(proxyMessage);
                if (!SEND_OK.equals(sendResult.getStatus())){
                    log.error("发送消息失败,消息内容：{},", proxyMessage.getContent());
                    tanggulaResult.buildFail("发送消息失败!");
                    return tanggulaResult;
                }
            }
        }
        return tanggulaResult;
    }
}
